/*
 * dstumbler v1.0 [screen.h]
 * by h1kari - (c) Dachb0den Labs 2001
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * size of windows
 * note: shouldn't modify these values unless you know what you're doing.
 */
/* ap_scr's values */
#define AP_SCR_LINES 7
#define AP_SCR_COLS  (max_cols - INFO_SCR_COLS - TOP_BORDER_LINES)
#define AP_SCR_Y     0
#define AP_SCR_X     0

/* info_scr's values */
#define INFO_SCR_LINES AP_SCR_LINES
#define INFO_SCR_COLS  26
#define INFO_SCR_Y     AP_SCR_Y
#define INFO_SCR_X     (AP_SCR_COLS + TOP_RIGHT_BORDER_COLS)

/* node_scr's values */
#define NODE_SCR_LINES node_scr_lines
#define NODE_SCR_COLS  (max_cols - MENU_SCR_COLS - RIGHT_BORDER_COLS)
#define NODE_SCR_Y     (AP_SCR_LINES + TOP_BORDER_LINES)
#define NODE_SCR_X     0
#define NODE_SCR_LINES_TOGGLE 5

/* graph_scr's values */
#define GRAPH_SCR_LINES (max_lines - AP_SCR_LINES - TOP_BORDER_LINES - \
 NODE_SCR_LINES - MIDDLE_BORDER_LINES - BOTTOM_BORDER_LINES - ALERT_SCR_LINES)
#define GRAPH_SCR_COLS  (max_cols - MENU_SCR_COLS - RIGHT_BORDER_COLS)
#define GRAPH_SCR_Y     (AP_SCR_LINES + TOP_BORDER_LINES + NODE_SCR_LINES + \
 MIDDLE_BORDER_LINES)
#define GRAPH_SCR_X     0

/* menu_scr's values */
#define MENU_SCR_LINES (GRAPH_SCR_LINES + NODE_SCR_LINES)
#define MENU_SCR_COLS  menu_scr_cols
#define MENU_SCR_Y     NODE_SCR_Y
#define MENU_SCR_X     INFO_SCR_X
#define MENU_SCR_COLS_TOGGLE INFO_SCR_COLS

/* alert_scr's values */
#define ALERT_SCR_LINES 1
#define ALERT_SCR_COLS  max_cols
#define ALERT_SCR_Y     (max_lines - ALERT_SCR_LINES)
#define ALERT_SCR_X     0

/*
 * size of border windows. please don't change these either
 */
/* top_border's values */
#define TOP_BORDER_LINES 1
#define TOP_BORDER_COLS  max_cols
#define TOP_BORDER_Y     AP_SCR_LINES
#define TOP_BORDER_X     0

/* top_right_border's values */
#define TOP_RIGHT_BORDER_LINES AP_SCR_LINES
#define TOP_RIGHT_BORDER_COLS  1
#define TOP_RIGHT_BORDER_Y     0
#define TOP_RIGHT_BORDER_X     AP_SCR_COLS

/* middle_border's values */
#define MIDDLE_BORDER_LINES middle_border_lines
#define MIDDLE_BORDER_COLS  GRAPH_SCR_COLS
#define MIDDLE_BORDER_Y     (AP_SCR_LINES + TOP_BORDER_LINES + NODE_SCR_LINES)
#define MIDDLE_BORDER_X     0
#define MIDDLE_BORDER_LINES_TOGGLE 1

/* right_border's values */
#define RIGHT_BORDER_LINES (GRAPH_SCR_LINES + MIDDLE_BORDER_LINES + \
 NODE_SCR_LINES)
#define RIGHT_BORDER_COLS  right_border_cols
#define RIGHT_BORDER_Y     NODE_SCR_Y
#define RIGHT_BORDER_X     GRAPH_SCR_COLS
#define RIGHT_BORDER_COLS_TOGGLE 1

/* bottom_border's values */
#define BOTTOM_BORDER_LINES 1
#define BOTTOM_BORDER_COLS  max_cols
#define BOTTOM_BORDER_Y     (ALERT_SCR_Y - BOTTOM_BORDER_LINES)
#define BOTTOM_BORDER_X     0
