/*
 * dwepcrack v0.4 [wordfile.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

#include "dwepcrack.h"

/*
 * read from the pcap file and then start trying to brute force with the
 * words in the wordfile.
 */
void
wordcrack(char *filename, char *wordfile)
{
  u_int i, diff, min, max, lines = 0;
  FILE *fd;
  pid_t pid[jobs];

  getsmallpkt(filename);

  printf("starting wordfile crack on smallest packet:\n");

  wep_init(small_pkt, small_len, 1);

  if((fd = fopen(wordfile, "r")) == NULL)
  {
    fprintf(stderr, "error: unable to open wordfile: %s\n", strerror(errno));
    exit(2);
  }

  while(!feof(fd))
    if(fgetc(fd) == '\n')
      lines++;

  fclose(fd);

  printf(" wordfile lines: %d\n\n", lines);
  printf(PROGRESS);
  fflush(stdout);

  if(jobs)
  {
    signal(SIGCHLD, chld_handler);

    diff = lines / jobs;
    for(i = 0; i < jobs; i++)
    {
      if(!(pid[i] = fork()))
      {
        min = diff * i;
        max = (i == jobs - 1 ? lines : diff * (i + 1));

        fd = fopen(wordfile, "r");
        exit(try_wordfile_keys(fd, min, max, lines));
      }
      else
        children++;
    }

    while(children > 0)
      sigpause(0);

    for(i = 0; i < jobs; i++)
      kill(pid[i], SIGKILL);
  }
  else
  {
    fd = fopen(wordfile, "r");
    try_wordfile_keys(fd, 0, lines, lines);
    fclose(fd);
  }

  printf("\n\n");
}

/*
 * try brute forcing the file using the words in the fd that are within the
 * specified range
 */
#define WORD_BUF_LEN 4096
int
try_wordfile_keys(FILE *fd, int idx, int len, int max)
{
  int i, mod;
  char word_buf[WORD_BUF_LEN];
  u_char keys[WEP_KEYS_SIZE];

  mod = MAX((max / (max_cols - PROG_OFFSET)), 2);

  for(i = 0; i < len && !feof(fd); i++)
  {
    fgets(word_buf, WORD_BUF_LEN - 1, fd);

    if(i < idx)
      continue;

    if((i % mod) == 0)
    {
      putchar('.');
      fflush(stdout);
    }

    word_buf[strlen(word_buf) - 1] = '\0';

    if(strong)
      wep_keygen104(word_buf, keys);
    else
      wep_keygen40(word_buf, keys);

    if(wep_try_verify_key(keys, strong ? 1 : 4, verify_pkt, verify_len) != -1)
      return 0;
  }

  return -1;
}
