/*
 * dwepdump v0.1 [dwepdump.c]
 * by h1kari - (c) Dachb0den Labs 2002
 */

/*
 * Copyright (c) 2002 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <openssl/md5.h>
#include <errno.h>

/*
 * definitions
 */
#define MD5_BUF_LEN   64
#define LOW_KEY_SIZE  5
#define LOW_KEY_KEYS  4
#define WEP_KEY_STORE (LOW_KEY_SIZE * LOW_KEY_KEYS)

#define BANNER \
 "* dwepkeygen v0.1 by h1kari <h1kari@dachb0den.com> *\n" \
 "* Copyright (c) Dachb0den Labs 2002 [http://dachb0den.com] *\n"
#define PROGRESS      "progress: "
#define PROG_OFFSET   13 /* lucky number */

/*
 * macros
 */
#ifndef MAX
#define MAX(x, y) ((x) > (y) ? (x) : (y))
#endif

/*
 * declarations
 */
static int max_lines, max_cols;

/*
 * get the size of the screen so we know how big to make the progress bar
 */
void
getscrmaxyx(void)
{
  struct winsize ws;

  if(ioctl(STDIN_FILENO, TIOCGWINSZ, &ws) < 0)
  {
    fprintf(stderr, "error: unable to determine screen size: %s",
     strerror(errno));
    exit(2);
  }

  max_lines = ws.ws_row;
  max_cols  = ws.ws_col;
}

/*
 * create md5 generated keys based on the user supplied seed
 */
void
getrandomkeys(char *seed, u_char *keys)
{
  int i, j;
  u_char md5_buf[MD5_BUF_LEN];
  MD5_CTX ctx;

  for(i = 0, j = 0; i < MD5_BUF_LEN; i++, j++)
  {
    if(seed[j] == 0)
      j = 0;
    md5_buf[i] = seed[j];
  }

  MD5_Init(&ctx);
  MD5_Update(&ctx, md5_buf, MD5_BUF_LEN);
  MD5_Final(md5_buf, &ctx);

  memcpy(keys, md5_buf, WEP_KEY_STORE);
}

/*
 * verify that the keys generated aren't part of the 24-bit block that is
 * vulnerable.
 */
#define MAX_SEED 0x1000000
int
verifykeys(u_char *keys)
{
  int i, j, k, mod;
  u_char vuln[WEP_KEY_STORE];

  printf(PROGRESS);
  fflush(stdout);

  mod = MAX((MAX_SEED / (max_cols - PROG_OFFSET)), 2);

  /*
   * loop through all of the weak 21 bit keys
   * (based on Tim Newsham's code demonstrating this vulnerability in the
   * 40-bit key generation).
   */
  for(i = 0; i < MAX_SEED; i++)
  {
    if((i % mod) == 0)
    {
      putchar('.');
      fflush(stdout);
    }

    if(i & 0x808080)
      continue;

    for(j = 0; j < WEP_KEY_STORE; j++)
    {
      k = i;
      k *= 0x343fd;
      k += 0x269ec3;
      vuln[j] = k >> 16;
    }
 
    /* compare all of the tx keys to make sure we're good */
    for(j = 0; j < LOW_KEY_KEYS; j++)
      if(memcmp(vuln + (j * LOW_KEY_SIZE), keys + (j * LOW_KEY_SIZE),
       LOW_KEY_SIZE) == 0)
      {
        putchar('\n');
        fflush(stdout);
        return -1;
      }
  }

  putchar('\n');
  fflush(stdout);
  return 0;
}

/*
 * print program usage
 */
void
usage(char *progname)
{
  printf("usage: %s <seed>\n", progname);
  exit(2);
}

/*
 * open device and log all data packets to file
 */
int
main(int argc, char *argv[])
{
  int i;
  char *seed;
  u_char keys[WEP_KEY_STORE], *key;

  if(argc < 2)
    usage(argv[0]);

  seed = argv[1];

  printf("\n%s\n", BANNER);
  printf("generating secure 40-bit keys...\n");
  printf(" seed: %s\n", seed);

  getrandomkeys(seed, keys);
  printf(" generated keys: \n");

  for(i = 0; i < LOW_KEY_KEYS; i++)
  {
    key = keys + i * LOW_KEY_SIZE;
    printf("  %d: %02x:%02x:%02x:%02x:%02x\n",
     i, key[0], key[1], key[2], key[3], key[4]);
  }
  putchar('\n');

  getscrmaxyx();

  if(verifykeys(keys) == -1)
  {
    fprintf(stderr, "error: generated key has at least one vulnerable key!\n");
    exit(2);
  }
  else
    printf("\nall good!\n\n");

  exit(0);
}
