/*
 * prism2dump v0.01 [fields_80211.c]
 * by h1kari - (c) Dachb0den Labs 2001
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/types.h>

#include <pcap.h>

#include "frames.h"
#include "prism2dump.h"


void
print_80211_status(u_int16_t status)
{
  if(status & WI_RXSTAT_MSG_TYPE)
  {
    printf("type: ");

    if(status & WI_STAT_1042)
      printf("rfc1042-enc ");
    if(status & WI_STAT_TUNNEL)
      printf("bridge-tun-enc ");
    if(status & WI_STAT_WMP_MSG)
      printf("wlii-mgmt ");
  }

  if(status & WI_STAT_MAC_PORT)
    printf("port: %d ", (status & WI_STAT_MAC_PORT) >> 8);

  if(status & WI_STAT_UNDECRYPTABLE)
    printf("enc ");

  if(status & WI_STAT_BADCRC)
    printf("err ");

  return;
}

void
print_80211_addrs(u_int8_t *addr1, u_int8_t *addr2, u_int8_t *addr3)
{
  printf("[%x:%x:%x:%x:%x:%x <- %x:%x:%x:%x:%x:%X <- %x:%x:%x:%x:%x:%x] ",
   MACIT(addr1), MACIT(addr2), MACIT(addr3));

  return;
}

void
print_80211_ts(u_int16_t ts0, u_int16_t ts1)
{
  u_int32_t timestamp;

  timestamp = ts1;
  timestamp <<= 16;
  timestamp |= ts0;

  printf("ts: %u.%u ", timestamp / 1000000, timestamp % 1000000);

  return;
}

void
print_80211_frame_ctl(u_int16_t frame_ctl)
{
  if(!(frame_ctl & WI_FCTL_OPT_MASK))
    return;

  printf("fctl: ");

  if(frame_ctl & WI_FCTL_TODS)
    printf("tods ");
  if(frame_ctl & WI_FCTL_FROMDS)
    printf("fds ");
  if(frame_ctl & WI_FCTL_MOREFRAGS)
    printf("mfrag ");
  if(frame_ctl & WI_FCTL_RETRY)
    printf("rtry ");
  if(frame_ctl & WI_FCTL_PM)
    printf("pmgt ");
  if(frame_ctl & WI_FCTL_MOREDATA)
    printf("mdata ");
  if(frame_ctl & WI_FCTL_WEP)
    printf("wep ");
  if(frame_ctl & WI_FCTL_ORDER)
    printf("odr ");

  return;
}

void
print_80211_id(u_int16_t id)
{
  printf("aid: %u ", id & WI_AID_MASK);

  return;
} 

void
print_80211_seq_ctl(u_int16_t seq_ctl)
{
  if(seq_ctl & WI_SCTL_FRAGNUM_MASK)
    printf("fn: %u ", seq_ctl & WI_SCTL_FRAGNUM_MASK);

  if(seq_ctl & WI_SCTL_SEQNUM_MASK)
    printf("sn: %u ", seq_ctl & WI_SCTL_SEQNUM_MASK);

  return;
}
   
void
print_80211_addr4(u_int8_t *addr4) 
{
  printf("(%x:%x:%x:%x:%x:%x) ", MACIT(addr4));

  return;
}

void
print_80211_dat_len(u_int16_t dat_len)
{
  printf("len: %u ", dat_len);

  return;
}
