/*
 * prism2dump v0.01 [prism2dump.c]
 * by h1kari - (c) Dachb0den Labs 2001
 */

/*
 * Copyright (c) 2001 Dachb0den Labs.
 *      David Hulton <h1kari@dachb0den.com>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by David Hulton.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY David Hulton AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL David Hulton OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#ifndef __FreeBSD__
#include <sys/endian.h>
#endif
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <net/if.h>

#include <pcap.h>

#include "frames.h"
#include "prism2dump.h"

/*
 * structures
 */
struct wi_stype_s {
  u_int8_t code;
  void (*func)(struct wi_rx_frame *, u_char *);
};


void
usage(char *progname)
{
  fprintf(stderr, "usage: %s <device> [-p] [-v 0|1|2]\n", progname);
  exit(2);
}

int
main(int argc, char *argv[])
{
  int c;

  if(argc > 1 && argv[1][0] != '-')
  {
    device = argv[1];
    optind++;
  }
  else
    usage(argv[0]);

  prism2 = 1;
  verbose = 2;

  while((c = getopt(argc, argv, "pv:")) != -1)
  {
    switch(c)
    {
      case 'p':
        prism2 = 0;
        break;
      case 'v':
        verbose = atoi(optarg);
        break;
      default:
        break;
    }
  }

  startloop();
  exit(0);
}

struct wi_stype_s wi_stypes[] = {
  /* management subtypes */
  { WI_STYPE_MGMT_ASREQ, &decode_mgmt_asreq },
  { WI_STYPE_MGMT_ASRESP, &decode_mgmt_asresp },
  { WI_STYPE_MGMT_REASREQ, &decode_mgmt_reasreq },
  { WI_STYPE_MGMT_REASRESP, &decode_mgmt_reasresp },
  { WI_STYPE_MGMT_PROBEREQ, &decode_mgmt_probereq },
  { WI_STYPE_MGMT_PROBERESP, &decode_mgmt_proberesp },
  { WI_STYPE_MGMT_BEACON, &decode_mgmt_beacon },
  { WI_STYPE_MGMT_ATIM, &decode_mgmt_atim },
  { WI_STYPE_MGMT_DISAS, &decode_mgmt_disas },
  { WI_STYPE_MGMT_AUTH, &decode_mgmt_auth },
  { WI_STYPE_MGMT_DEAUTH, &decode_mgmt_deauth },
  /* control subtypes */
  { WI_STYPE_CTL_PSPOLL, &decode_ctl_pspoll },
  { WI_STYPE_CTL_RTS, &decode_ctl_rts },
  { WI_STYPE_CTL_CFEND, &decode_ctl_cfend },
  { WI_STYPE_CTL_CFENDCFACK, &decode_ctl_cfendcfack },
  { WI_STYPE_CTL_CTS, &decode_ctl_cts },
  { WI_STYPE_CTL_ACK, &decode_ctl_ack },
  { 0xFF, NULL }
};

void
startloop(void)
{
  int i;
  u_char errbuf[PCAP_ERRBUF_SIZE], *buf, *data;
  struct pcap_pkthdr    h;
  struct wi_rx_frame   *wi_h;

  if((p = pcap_open_live(device, SNAPLEN, prism2 ? 0 : 1, TOMS, errbuf)) == 
   NULL)
  {
    fprintf(stderr, "prism2dump: unable to open pcap device: %s\n", errbuf);
    exit(2);
  }

  printf("prism2dump: listening on %s\n", device);

  while(1)
  {
    if((buf = (u_char *)pcap_next(p, &h)) == NULL)
      continue;

    wi_h = (struct wi_rx_frame *)buf;
    data = (u_char *)buf + sizeof(struct wi_rx_frame);

    if(le16toh(wi_h->wi_status) & WI_STAT_BADCRC)
      continue;

    if(verbose > 0)
    {
      /*
       * determine what type of packet this is
       */
      switch(wi_h->wi_frame_ctl & WI_FCTL_FTYPE)
      {
        case WI_FTYPE_DATA:
          decode_80211(wi_h);
          decode_data(wi_h, data);
          printeol(0);
          break;
        case WI_FTYPE_CTL:
        case WI_FTYPE_MGMT:
          decode_80211(wi_h);
          for(i = 0; wi_stypes[i].func != NULL; i++)
          {
            if(wi_stypes[i].code == (wi_h->wi_frame_ctl & WI_FCTL_STYPE))
            {
              (*wi_stypes[i].func)(wi_h, data);
              break;
            }
          }
          printeol(0);
          break;
        default:
          break;
      }
    }
  }
}
