#ifndef SNMPSNIFF_H
#define SNMPSNIFF_H

/* *************************************************************************
   snmpsniff.h, a promiscuous SNMP PDU sniffer.
   v.1.0
   Copyright, May 1998, Nuno Leitao (nuno.leitao@convex.pt), 
   Convex Informatica e Sistemas Portugal, Tel.: +351 1 4221040

   COPYRIGHT NOTICE:
   This code is provided *as is*, the author stands no responsability for 
   it's use. You may copy, distribute or modify this code, as long as you
   keep this copyright notice intact.
   This code uses the CMU-SNMP (v.1.10) API,  Copyright 1998 by Carnegie 
   Mellon University.
   ************************************************************************* */

/* A macro to convert a system OID (i.e., pdu->enterprise) to a string. */
#define ENTERPRISE2TXT(var, txt) sprint_objid(txt, var->name, var->name_length)

#define BUFFER_SIZE 65536	/* This should be enough... */

/* 255 communities should be enough for common applications. */
#define MAX_COMMF 255
/* 255 OID filters should be enough for common applications. */
#define MAX_OIDF 255

/* An OID filter structure. */
struct oid_filt
  {
    oid *oid_f;
    int oid_l;
    struct oid_filt *next;
  };

/* A data structure containing several filter information. */
struct filters
  {
    char **cf;			/* Communities */
    int *pf;			/* PDU Types */
    struct oid_filt *of;	/* OID's */
    char proxy_dest_on;		/* Is trap proxying on or off ? */
    struct hostent *proxy_dest;	/* Trap's proxying */
  };

unsigned short trap_port;
unsigned short snmp_port;

/* A handler for pcap, it needs to be global because there is no other way to
   pass it to the signal handler, the same can be said about the file descriptor
   for SOCK_PACKET. */
pcap_t *pcaphandler;

/* A structure containing capture statistics for a program run. */
struct pcap_stat pcap_intf_stats;

/* The name of the interface we are listening on. */
char *intf_name = NULL;

/* This flag decides if we should resolve names or not (default is *not*). */
char resolve_flag = 0;

/* Verbose output -- off be default */
char verbose_out = 0;

/* This is the hostname the process is running on. */
char myhostname[80];
struct sockaddr_in myhostaddr;

/* Function Prototypes: */

pcap_t *open_intf_promisc_pcap (char *intf, int snaplen, int promisc, int to_ms);
void build_bpf_filter (pcap_t * p, unsigned short snmp_port, unsigned short trap_port, char *filter_expression, char *cap_file);

void hook_protos (void);
char *filter_packet (int fd, int *size);
char *trap_description (int trap);
char *timeticks2string (u_int timeticks, char *date_string);
char *my_snprint_type (struct variable_list *var, char *buff, int length);
void my_print_variable (struct variable_list *var);
char *errstatus_description (int errstat, char *buff, int length);
void parse_pdu (struct filters *user_data, const struct pcap_pkthdr *p_header, const char *packet);
int pdu_send (struct hostent *dst_addr, short int dst_port, u_char * data, int length);

#endif /* SNMPSNIFF_H */
