/* 
 *	Copyright (C) Chia-chen Kuo - April 2001
 *
 *  This file is part of DVD2AVI, a free MPEG-2 decoder
 *	
 *  DVD2AVI is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  DVD2AVI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include "global.h"
#include "getbit.h"
#include "AC3Dec\ac3.h"

#define LOCATE												\
while (Rdptr >= (Rdbfr + BUFFER_SIZE))						\
{															\
	Read = _read(Infile[File_Flag], Rdbfr, BUFFER_SIZE);	\
	if (Read < BUFFER_SIZE) Next_File();					\
	Rdptr -= BUFFER_SIZE;									\
}

#define DECODE_AC3																\
{																				\
	size = 0;																	\
	while (Packet_Length > 0)													\
	{																			\
		if (Packet_Length+Rdptr > BUFFER_SIZE+Rdbfr)							\
		{																		\
			size = ac3_decode_data(Rdptr, BUFFER_SIZE+Rdbfr-Rdptr, size);		\
			Packet_Length -= BUFFER_SIZE+Rdbfr-Rdptr;							\
			Read = _read(Infile[File_Flag], Rdbfr, BUFFER_SIZE);				\
			if (Read < BUFFER_SIZE) Next_File();								\
			Rdptr = Rdbfr;														\
		}																		\
		else																	\
		{																		\
			size = ac3_decode_data(Rdptr, Packet_Length, size);					\
			Rdptr += Packet_Length;												\
			Packet_Length = 0;													\
		}																		\
	}																			\
}

#define DEMUX_AC3															\
while (Packet_Length > 0)													\
{																			\
	if (Packet_Length+Rdptr > BUFFER_SIZE+Rdbfr)							\
	{																		\
		fwrite(Rdptr, BUFFER_SIZE+Rdbfr-Rdptr, 1, ac3[AC3_Track].file);		\
		Packet_Length -= BUFFER_SIZE+Rdbfr-Rdptr;							\
		Read = _read(Infile[File_Flag], Rdbfr, BUFFER_SIZE);				\
		if (Read < BUFFER_SIZE) Next_File();								\
		Rdptr = Rdbfr;														\
	}																		\
	else																	\
	{																		\
		fwrite(Rdptr, Packet_Length, 1, ac3[AC3_Track].file);				\
		Rdptr += Packet_Length;												\
		Packet_Length = 0;													\
	}																		\
}

#define DEMUX_PCM														\
{																		\
	unsigned char tmp;													\
	size = 0;															\
	while (Packet_Length > 0)											\
	{																	\
		if (Packet_Length+Rdptr > BUFFER_SIZE+Rdbfr)					\
		{																\
			memcpy(PCM_Buffer+size, Rdptr, BUFFER_SIZE+Rdbfr-Rdptr);	\
			size += BUFFER_SIZE+Rdbfr-Rdptr;							\
			Packet_Length -= BUFFER_SIZE+Rdbfr-Rdptr;					\
			Read = _read(Infile[File_Flag], Rdbfr, BUFFER_SIZE);		\
			if (Read < BUFFER_SIZE) Next_File();						\
			Rdptr = Rdbfr;												\
		}																\
		else															\
		{																\
			memcpy(PCM_Buffer+size, Rdptr, Packet_Length);				\
			Rdptr += Packet_Length;										\
			size += Packet_Length;										\
			Packet_Length = 0;											\
		}																\
	}																	\
	for (i=0; i<size; i+=2)												\
	{																	\
		tmp = PCM_Buffer[i];											\
		PCM_Buffer[i] = PCM_Buffer[i+1];								\
		PCM_Buffer[i+1] = tmp;											\
	}																	\
}

#define DEMUX_MPA															\
while (Packet_Length > 0)													\
{																			\
	if (Packet_Length+Rdptr > BUFFER_SIZE+Rdbfr)							\
	{																		\
		fwrite(Rdptr, BUFFER_SIZE+Rdbfr-Rdptr, 1, mpa[MPA_Track].file);		\
		Packet_Length -= BUFFER_SIZE+Rdbfr-Rdptr;							\
		Read = _read(Infile[File_Flag], Rdbfr, BUFFER_SIZE);				\
		if (Read < BUFFER_SIZE) Next_File();								\
		Rdptr = Rdbfr;														\
	}																		\
	else																	\
	{																		\
		fwrite(Rdptr, Packet_Length, 1, mpa[MPA_Track].file);				\
		Rdptr += Packet_Length;												\
		Packet_Length = 0;													\
	}																		\
}

static char *FTType[5] = {
	"48KHz", "44.1KHz", "44.1KHz", "44.1KHz", "44.1KHz"
};

static char *AC3ModeDash[8] = {
	"1+1", "1_0", "2_0", "3_0", "2_1", "3_1", "2_2", "3_2"
};

static unsigned char PCM_Buffer[BUFFER_SIZE];
static short *ptrPCM_Buffer = (short*)PCM_Buffer;

void Initialize_Buffer()
{
	Rdptr = Rdbfr + BUFFER_SIZE;
	Rdmax = Rdptr;

	if (SystemStream_Flag)
	{
		if (Rdptr >= Rdmax)
			Next_Packet();
		CurrentBfr = *Rdptr++ << 24;

		if (Rdptr >= Rdmax)
			Next_Packet();
		CurrentBfr += *Rdptr++ << 16;

		if (Rdptr >= Rdmax)
			Next_Packet();
		CurrentBfr += *Rdptr++ << 8;

		if (Rdptr >= Rdmax)
			Next_Packet();
		CurrentBfr += *Rdptr++;

		Fill_Next();
	}
	else
	{
		Fill_Buffer();

		CurrentBfr = (*Rdptr << 24) + (*(Rdptr+1) << 16) + (*(Rdptr+2) << 8) + *(Rdptr+3);
		Rdptr += 4;

		Fill_Next();
	}

	BitsLeft = 32;
}

void Next_Packet()
{
	static int i, Packet_Length, Packet_Header_Length, size;
	static unsigned int code, AUDIO_ID, VOBCELL_Count, AC3_Track, MPA_Track;

	for (;;)
	{
		code = Get_Short();
		code = (code<<16) + Get_Short();

		while ((code & 0xffffff00) != 0x00000100)
			code = (code<<8) + Get_Byte();

		switch (code)
		{
			case PACK_START_CODE:
				Rdptr += 8;
				VOBCELL_Count = 0;
				break;

			case PRIVATE_STREAM_2:
				Packet_Length = Get_Short();

				if (++VOBCELL_Count==2)
				{
					Rdptr += 25;
					VOB_ID = Get_Short();
					CELL_ID = Get_Short();
					Rdptr += Packet_Length - 29;

					sprintf(szBuffer, "%d", VOB_ID);
					SetDlgItemText(hDlg, IDC_VOB_ID, szBuffer);

					sprintf(szBuffer, "%d", CELL_ID);
					SetDlgItemText(hDlg, IDC_CELL_ID, szBuffer);
				}
				else
					Rdptr += Packet_Length;
				break;

			case PRIVATE_STREAM_1:
				Packet_Length = Get_Short();

				Rdptr ++;
				code = Get_Byte();
				Packet_Header_Length = Get_Byte();

				if (code>=0x80)
				{
					code = Get_Byte();
					AudioPTS = (code & 0x0e) << 29;

					AudioPTS |= (Get_Short() & 0xfffe) << 14;
					AudioPTS |= (Get_Short()>>1) & 0x7fff;

					Rdptr += Packet_Header_Length-5;
				}
				else
					Rdptr += Packet_Header_Length;

				AUDIO_ID = Get_Byte();
				Packet_Length -= Packet_Header_Length+4;

				if (AUDIO_ID>=SUB_AC3 && AUDIO_ID<SUB_AC3+CHANNEL)
				{
					Rdptr += 3; Packet_Length -= 3; AC3_Track = AUDIO_ID-SUB_AC3;

					LOCATE

					if (!ac3[AC3_Track].rip && Rip_Flag && !CH[AC3_Track])
					{
						CH[AC3_Track] = FORMAT_AC3;

						code = Get_Byte();
						code = (code & 0xff)<<8 | Get_Byte();
						i = 0;

						while (code!=0xb77)
						{
							code = (code & 0xff)<<8 | Get_Byte();
							i++;
						}

						Get_Short();
						ac3[AC3_Track].rate = (Get_Byte()>>1) & 0x1f;
						Get_Byte();
						ac3[AC3_Track].mode = (Get_Byte()>>5) & 0x07;

						Rdptr -= 7; Packet_Length -= i;

						if ((Format_Flag==FORMAT_AC3 || !Format_Flag) && (AVI_Flag || D2V_Flag || Decision_Flag))
						{
							if (Decision_Flag && AC3_Track==Track_Flag)
							{
								InitialAC3();

								DECODE_AC3

								ac3[AC3_Track].rip = 1;
							}
							else if (AC3_Flag==AUDIO_DECODE && AC3_Track==Track_Flag)
							{
								sprintf(szBuffer, "%s AC3 T%02d %sch %dKbps %s.wav", szOutput, Track_Flag+1, 
									AC3ModeDash[ac3[AC3_Track].mode], AC3Rate[ac3[AC3_Track].rate], FTType[SRC_Flag]);

								strcpy(pcm.filename, szBuffer);
								pcm.file = fopen(szBuffer, "wb");

								fwrite(WAVHeader, sizeof(WAVHeader), 1, pcm.file);
								pcm.delay = ((AudioPTS-VideoPTS)/90) * 192;

								if (SRC_Flag)
								{
									DownWAV(pcm.file);
									InitialSRC();
								}

								if (pcm.delay > 0)
								{
									if (SRC_Flag)
										pcm.delay = ((int)(0.91875*pcm.delay)>>2)<<2;

									for (i=0; i<pcm.delay; i++)
										fputc(0, pcm.file);

									pcm.size += pcm.delay;
									pcm.delay = 0;
								}

								InitialAC3();

								DECODE_AC3

								if (-pcm.delay > size)
									pcm.delay += size;
								else
								{
									if (SRC_Flag)
										Wavefs44(pcm.file, size+pcm.delay, AC3Dec_Buffer-pcm.delay);
									else
										fwrite(AC3Dec_Buffer-pcm.delay, size+pcm.delay, 1, pcm.file);

									pcm.size += size+pcm.delay;
 									pcm.delay = 0;
								}

								ac3[AC3_Track].rip = 1;
							}
							else if (!AC3_Flag || (AC3_Flag==AUDIO_DEMUXONE && AC3_Track==Track_Flag))
							{
								sprintf(szBuffer, "%s AC3 T%02d %sch %dKbps DELAY %dms.ac3", szOutput, AC3_Track+1, 
									AC3ModeDash[ac3[AC3_Track].mode], AC3Rate[ac3[AC3_Track].rate], (AudioPTS-VideoPTS)/90);

								ac3[AC3_Track].file = fopen(szBuffer, "wb");

								DEMUX_AC3

								ac3[AC3_Track].rip = 1;
							}
						}
					}
					else if (ac3[AC3_Track].rip)
					{
						if (Decision_Flag)
							DECODE_AC3
						else if (AC3_Flag==AUDIO_DECODE)
						{
							DECODE_AC3

							if (-pcm.delay > size)
								pcm.delay += size;
							else
							{
								if (SRC_Flag)
									Wavefs44(pcm.file, size+pcm.delay, AC3Dec_Buffer-pcm.delay);
								else
									fwrite(AC3Dec_Buffer-pcm.delay, size+pcm.delay, 1, pcm.file);

								pcm.size += size+pcm.delay;
 								pcm.delay = 0;
							}
						}
						else
							DEMUX_AC3
					}
				}
				else if (AUDIO_ID-SUB_PCM == Track_Flag)
				{
					CH[Track_Flag] = FORMAT_LPCM;
					Rdptr += 6; Packet_Length -= 6;

					LOCATE

					if (!pcm.rip && Rip_Flag)
					{
						if ((Format_Flag==FORMAT_LPCM || !Format_Flag) && (AVI_Flag || D2V_Flag))
						{
							pcm.delay = ((AudioPTS-VideoPTS)/90) * 192;

							sprintf(szBuffer, "%s LPCM T%02d %s.wav", szOutput, Track_Flag+1, FTType[SRC_Flag]);
							strcpy(pcm.filename, szBuffer);

							pcm.file = fopen(szBuffer, "wb");
							fwrite(WAVHeader, sizeof(WAVHeader), 1, pcm.file);

							if (SRC_Flag)
							{
								DownWAV(pcm.file);
								InitialSRC();
							}

							if (pcm.delay > 0)
							{
								if (SRC_Flag)
									pcm.delay = ((int)(0.91875*pcm.delay)>>2)<<2;

								for (i=0; i<pcm.delay; i++)
									fputc(0, pcm.file);

								pcm.size += pcm.delay;
								pcm.delay = 0;
							}

							if (-pcm.delay > Packet_Length)
								pcm.delay += Packet_Length;
							else
							{
								DEMUX_PCM

								if (SRC_Flag)
									Wavefs44(pcm.file, size+pcm.delay, PCM_Buffer-pcm.delay);
								else
									fwrite(PCM_Buffer-pcm.delay, size+pcm.delay, 1, pcm.file);

								pcm.size += size+pcm.delay;
								pcm.delay = 0;
							}

							pcm.rip = 1;
						}
					}
					else if (pcm.rip)
					{
						if (-pcm.delay > Packet_Length)
							pcm.delay += Packet_Length;
						else
						{
							DEMUX_PCM

							if (SRC_Flag)
								Wavefs44(pcm.file, size+pcm.delay, PCM_Buffer-pcm.delay);
							else
							{
								fwrite(PCM_Buffer-pcm.delay, size+pcm.delay, 1, pcm.file);
								
								if (Normalization_Flag)
									for (i=0; i<(size>>1); i++)
										if (Sound_Max < abs(ptrPCM_Buffer[i]))
											Sound_Max = abs(ptrPCM_Buffer[i]);
							}

							pcm.size += size+pcm.delay;
							pcm.delay = 0;
						}
					}
				}
				else if (AUDIO_ID-SUB_DTS == Track_Flag)
					CH[Track_Flag] = FORMAT_DTS;

				Rdptr += Packet_Length;
				break;

			case AUDIO_ELEMENTARY_STREAM_7:
				MPA_Track++;
			case AUDIO_ELEMENTARY_STREAM_6:
				MPA_Track++;
			case AUDIO_ELEMENTARY_STREAM_5:
				MPA_Track++;
			case AUDIO_ELEMENTARY_STREAM_4:
				MPA_Track++;
			case AUDIO_ELEMENTARY_STREAM_3:
				MPA_Track++;
			case AUDIO_ELEMENTARY_STREAM_2:
				MPA_Track++;
			case AUDIO_ELEMENTARY_STREAM_1:
				MPA_Track++;
			case AUDIO_ELEMENTARY_STREAM_0:
				Packet_Length = Get_Short()-1;
				code = Get_Byte();

				if ((code & 0xc0)==0x80 && (Track_Flag==MPA_Track || !MPA_Flag))
				{
					CH[MPA_Track] = FORMAT_MPA;

					code = Get_Byte();
					Packet_Header_Length = Get_Byte();

					if (code>=0x80)
					{
						code = Get_Byte();

						AudioPTS = (code & 0x0e) << 29;
						AudioPTS |= (Get_Short() & 0xfffe) << 14;
						AudioPTS |= (Get_Short()>>1) & 0x7fff;

						Rdptr += Packet_Header_Length-5;
					}
					else
						Rdptr += Packet_Header_Length;

					Packet_Length -= Packet_Header_Length+2;

					LOCATE

					if (!mpa[MPA_Track].rip && Rip_Flag)
					{
						if ((Format_Flag==FORMAT_MPA || !Format_Flag) && (AVI_Flag || D2V_Flag))
						{
							code = Get_Byte();
							code = (code & 0xff)<<8 | Get_Byte();
							i = 0;

							while (code<0xfff0)
							{
								code = (code & 0xff)<<8 | Get_Byte();
								i++;
							}

							sprintf(szBuffer, "%s MPA T%02d DELAY %dms.mpa", szOutput, MPA_Track+1, (AudioPTS-VideoPTS)/90);
							mpa[MPA_Track].file = fopen(szBuffer, "wb");

							Rdptr -= 2; Packet_Length -= i;

							DEMUX_MPA

							mpa[MPA_Track].rip = 1;					
						}
					}
					else if (mpa[MPA_Track].rip)
						DEMUX_MPA
				}

				Rdptr += Packet_Length;
				MPA_Track = 0;
				break;

			case VIDEO_ELEMENTARY_STREAM:
				Packet_Length = Get_Short();
				Rdmax = Rdptr + Packet_Length;

				code = Get_Byte();

				if ((code & 0xc0)==0x80)
				{
					code = Get_Byte();
					Packet_Header_Length = Get_Byte();

					if (code>=0x80 && !Rip_Flag)
					{
						code = Get_Byte();
						VideoPTS = (code & 0x0e) << 29;
						VideoPTS |= (Get_Short() & 0xfffe) << 14;
						VideoPTS |= (Get_Short()>>1) & 0x7fff;

						Rdptr += Packet_Header_Length-5;
					}
					else
						Rdptr += Packet_Header_Length;

					Bitrate_Meter += Rdmax-Rdptr;
					return;
				}
				else
					Rdptr += Packet_Length-1;
				break;

			default:
				if (code>=SYSTEM_START_CODE)
				{
					Packet_Length = Get_Short();
					Rdptr += Packet_Length;
				}
				break;
		}
	}
}

unsigned int Get_Bits_All(unsigned int N)
{
	N -= BitsLeft;
	Val = (CurrentBfr << (32 - BitsLeft)) >> (32 - BitsLeft);

	if (N)
		Val = (Val << N) + (NextBfr >> (32 - N));

	CurrentBfr = NextBfr;
	BitsLeft = 32 - N;
	Fill_Next();

	return Val;
}

void Flush_Buffer_All(unsigned int N)
{
	CurrentBfr = NextBfr;
	BitsLeft = BitsLeft + 32 - N;
	Fill_Next();
}

void Fill_Buffer()
{
	Read = _read(Infile[File_Flag], Rdbfr, BUFFER_SIZE);

	if (Read < BUFFER_SIZE)
		Next_File();

	if (KeyOp_Flag && (Rdbfr[20] & 0x10))
	{
		BufferOp(Rdbfr, lfsr0, lfsr1);
		Rdbfr[20] &= ~0x10;
	}

	Rdptr = Rdbfr;

	if (SystemStream_Flag)
		Rdmax -= BUFFER_SIZE;
	else
		Bitrate_Meter += Read;
}

void Next_File()
{
	int i;

	if (File_Flag < File_Limit-1)
	{
		File_Flag++;

		process.run = 0;
		for (i=0; i<File_Flag; i++)
			process.run += process.length[i];

		_lseeki64(Infile[File_Flag], 0, SEEK_SET);
		_read(Infile[File_Flag], Rdbfr + Read, BUFFER_SIZE - Read);
	}
	else
	{
		Fault_Flag = 98;
		Write_Frame(NULL, d2v_current, 0);
	}
}
