/* 
 *	Copyright (C) Chia-chen Kuo - April 2001
 *
 *  This file is part of DVD2AVI, a free MPEG-2 decoder
 *	
 *  DVD2AVI is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  DVD2AVI is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include "global.h"
#include "vfapi.h"

HRESULT __stdcall vfGetPluginInfo(LPVF_PluginInfo info);
HRESULT __stdcall vfGetPluginFunc(LPVF_PluginFunc func);

HRESULT __stdcall open_file(char *path, LPVF_FileHandle out);
HRESULT __stdcall close_file(VF_FileHandle p);
HRESULT __stdcall get_file_info(VF_FileHandle in, LPVF_FileInfo out);
HRESULT __stdcall get_stream_info(VF_FileHandle in, DWORD s, void *out);
HRESULT __stdcall read_data(VF_FileHandle in, DWORD s, void *out);

HRESULT __stdcall vfGetPluginInfo(LPVF_PluginInfo info)
{
	if (info == NULL)
		return VF_ERROR;

	if (info->dwSize != sizeof(VF_PluginInfo))
		return VF_ERROR;

	info->dwAPIVersion = 1;
	info->dwVersion = 1;
	info->dwSupportStreamType = VF_STREAM_VIDEO;

	strcpy(info->cPluginInfo, "DVD2AVI Project File Reader 1.76");
	strcpy(info->cFileType, "DVD2AVI Project File (*.d2v)|*.d2v");

	return VF_OK;
}

HRESULT __stdcall vfGetPluginFunc(LPVF_PluginFunc func)
{
	if (func == NULL)
		return VF_ERROR;

	if (func->dwSize != sizeof(VF_PluginFunc))
		return VF_ERROR;

	func->OpenFile = open_file;
	func->CloseFile = close_file;
	func->GetFileInfo = get_file_info;
	func->GetStreamInfo = get_stream_info;
	func->ReadData = read_data;

	return VF_OK;
}

HRESULT __stdcall open_file(char *path, LPVF_FileHandle out)
{
	D2VFAPI **d2v;

	d2v = (D2VFAPI **)out;
	*d2v = (D2VFAPI *)malloc(sizeof(D2VFAPI));
	if (*d2v == NULL)
		return VF_ERROR;

	if (!Open_D2VFAPI(path, *d2v))
	{
		free(*d2v);
		*d2v = NULL;
		return VF_ERROR;
	}

	return VF_OK;
}

HRESULT __stdcall close_file(VF_FileHandle in)
{
	D2VFAPI *d2v;

	d2v = (D2VFAPI *)in;
	Close_D2VFAPI(d2v);

	return VF_OK;
}

HRESULT __stdcall get_file_info(VF_FileHandle in, LPVF_FileInfo out)
{
	if (out == NULL)
		return VF_ERROR;

	if (out->dwSize != sizeof(VF_FileInfo))
		return VF_ERROR;

	out->dwHasStreams = VF_STREAM_VIDEO;

	return VF_OK;
}

HRESULT __stdcall get_stream_info(VF_FileHandle in, DWORD stream, void *out)
{
	D2VFAPI *d2v;
	LPVF_StreamInfo_Video info;

	if (stream != VF_STREAM_VIDEO)
		return VF_ERROR;

	d2v = (D2VFAPI *)in;
	info = (LPVF_StreamInfo_Video)out;

	if (info == NULL)
		return VF_ERROR;
	
	if (info->dwSize != sizeof(VF_StreamInfo_Video))
		return VF_ERROR;

	info->dwLengthL = d2v->VF_FrameLimit;
	info->dwRate = d2v->VF_FrameRate;
	info->dwScale = 1000;
	info->dwWidth = Clip_Width;
	info->dwHeight = Clip_Height;
	info->dwBitCount = 24;

	return VF_OK;
}
	
HRESULT __stdcall read_data(VF_FileHandle in, DWORD stream, void *out)
{
	unsigned char *dst;
	D2VFAPI *d2v;
	LPVF_ReadData_Video data;

	if (stream != VF_STREAM_VIDEO)
		return VF_ERROR;

	d2v = (D2VFAPI *)in;
	data = (LPVF_ReadData_Video)out;
	dst = (unsigned char *)data->lpData;

	if (data == NULL)
		return VF_ERROR;
	
	if (data->dwSize != sizeof(VF_ReadData_Video))
		return VF_ERROR;

	Decode_D2VFAPI(d2v, dst, data->dwFrameNumberL, data->lPitch);

	return VF_OK;
}
