/******************************************************************************
fgdump - by fizzgig and the foofus.net group
Copyright (C) 2005 by fizzgig
http://www.foofus.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
******************************************************************************/
#include "stdafx.h"
#include "McAfeeControl.h"
#include "AVStatus.h"
#include "ServiceControl.h"

McAfeeControl::McAfeeControl()
{

}

McAfeeControl::~McAfeeControl()
{

}

int McAfeeControl::GetServiceState(const char* lpszMachine)
{
	SERVICE_STATUS sStatus;
	ServiceControl sc;
	int nResult = AV_UNKNOWN;

	if (sc.QueryServiceStatus(lpszMachine, "mcshield", &sStatus) == INSTALLED)
	{
		if (sStatus.dwCurrentState == SERVICE_RUNNING)
			nResult = AV_STARTED;
		else if (sStatus.dwCurrentState == SERVICE_STOPPED)
			nResult = AV_STOPPED;
	}
	else
	{
		nResult = AV_UNKNOWN;
	}

	return nResult;
}

bool McAfeeControl::IsServiceInstalled(const char* lpszMachine)
{
	SERVICE_STATUS sStatus;
	ServiceControl sc;

	if (sc.QueryServiceStatus(lpszMachine, "mcshield", &sStatus) == INSTALLED)
	{
		return true;
	}
	else
	{
		return false;
	}
}

bool McAfeeControl::StopService(const char* lpszMachine)
{
	ServiceControl sc;

	if (sc.StopService(lpszMachine, "mcshield", 30))
	{
		Log.ReportError(INFO, "Stopped McShield successfully\n");
		return true;
	}
	else
	{
		Log.ReportError(CRITICAL, "Unable to stop McAfee, see previous errors for details. Stopping pwdump.\n");
		return false;
	}
}

bool McAfeeControl::StartService(const char* lpszMachine)
{
	ServiceControl sc;

	if (sc.StartService(lpszMachine, "mcshield", 30))
	{
		Log.ReportError(INFO, "Started McAfee successfully\n");
		return true;
	}
	else
	{
		Log.ReportError(CRITICAL, "Unable to start McAfee, see previous errors for details.\n");
		return false;
	}
}
