/******************************************************************************
fgdump - by fizzgig and the foofus.net group
Copyright (C) 2005 by fizzgig
http://www.foofus.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
******************************************************************************/
#include "StdAfx.h"
#include ".\servicecontrol.h"

ServiceControl::ServiceControl(void)
{
}

ServiceControl::~ServiceControl(void)
{
}

FG_SERVICE_STATUS ServiceControl::QueryServiceStatus(const char* szMachine, const char* szServiceShortName, SERVICE_STATUS* lpStatus)
{
	SC_HANDLE hSCM = NULL;
	SC_HANDLE hService = NULL;
	bool bRet;

	::ZeroMemory(lpStatus, sizeof(SERVICE_STATUS));

	hSCM = OpenSCManager(szMachine, NULL, GENERIC_READ);
	if (NULL == hSCM)
	{
		ErrorHandler("QueryServiceStatus", "OpenSCManager", GetLastError());
		return UNKNOWN;
	}

	hService = OpenService(hSCM, szServiceShortName, SERVICE_QUERY_STATUS);
	if (NULL == hService)
	{
		//printf("Unable to open service %s on %s\n", szServiceShortName, szMachine);
		CloseServiceHandle(hSCM);
		return NOT_INSTALLED;
	}

	bRet = ::QueryServiceStatus(hService, lpStatus);
	if (!bRet)
	{
		ErrorHandler("QueryServiceStatus", "QueryServiceStatus", GetLastError());
		CloseServiceHandle(hService);
		CloseServiceHandle(hSCM);
		return NOT_INSTALLED;
	}

	CloseServiceHandle(hService);
	CloseServiceHandle(hSCM);

	return INSTALLED;
}

bool ServiceControl::StartService(const char* szMachine, const char* szServiceShortName, int nMaxWait)
{
	SC_HANDLE hSCM = NULL;
	SC_HANDLE hService = NULL;
	SERVICE_STATUS sStatus;
	bool bRet;
	int nTimeWaited = 0;

	hSCM = OpenSCManager(szMachine, NULL, GENERIC_READ);
	if (NULL == hSCM)
	{
		ErrorHandler("StartService", "OpenSCManager", GetLastError());
		return false;
	}

	hService = OpenService(hSCM, szServiceShortName, GENERIC_EXECUTE | SERVICE_QUERY_STATUS);
	if (NULL == hService)
	{
		ErrorHandler("StartService", "OpenService", GetLastError());
		CloseServiceHandle(hSCM);
		return false;
	}

	bRet = ::StartService(hService, 0, NULL);
	if (!bRet)
	{
		ErrorHandler("StartService", "StartService", GetLastError());
		CloseServiceHandle(hService);
		CloseServiceHandle(hSCM);
		return false;
	}

	bRet = ::QueryServiceStatus(hService, &sStatus);
	if (!bRet)
	{
		ErrorHandler("StartService", "QueryServiceStatus", GetLastError());
		CloseServiceHandle(hService);
		CloseServiceHandle(hSCM);
		return false;
	}

	while(SERVICE_RUNNING != sStatus.dwCurrentState && nTimeWaited < nMaxWait)
	{
		Sleep(1000);
		bRet = ::QueryServiceStatus(hService, &sStatus);
		if (!bRet)
		{
			ErrorHandler("StartService", "QueryServiceStatus", GetLastError());
			CloseServiceHandle(hService);
			CloseServiceHandle(hSCM);
			return false;
		}

		nTimeWaited++;
	}

	if (SERVICE_RUNNING != sStatus.dwCurrentState)
	{
		ErrorHandler("StartService", "QueryServiceStatus", GetLastError());
		CloseServiceHandle(hService);
		CloseServiceHandle(hSCM);
		return false;
	}

	CloseServiceHandle(hService);
	CloseServiceHandle(hSCM);

	return true;
}

bool ServiceControl::StopService(const char* szMachine, const char* szServiceShortName, int nMaxWait)
{
	SC_HANDLE hSCM = NULL;
	SC_HANDLE hService = NULL;
	SERVICE_STATUS sStatus;
	bool bRet;
	int nTimeWaited = 0;

	hSCM = OpenSCManager(szMachine, NULL, GENERIC_READ);
	if (NULL == hSCM)
	{
		ErrorHandler("StopService", "OpenSCManager", GetLastError());
		return false;
	}

	hService = OpenService(hSCM, szServiceShortName, GENERIC_EXECUTE | SERVICE_QUERY_STATUS);
	if (NULL == hService)
	{
		ErrorHandler("StopService", "OpenService", GetLastError());
		CloseServiceHandle(hSCM);
		return false;
	}

	bRet = ::ControlService(hService, SERVICE_CONTROL_STOP, &sStatus);
	if (!bRet)
	{
		ErrorHandler("StopService", "StopService", GetLastError());
		CloseServiceHandle(hService);
		CloseServiceHandle(hSCM);
		return false;
	}

	while(SERVICE_STOPPED != sStatus.dwCurrentState && nTimeWaited < nMaxWait)
	{
		Sleep(1000);
		bRet = ::QueryServiceStatus(hService, &sStatus);
		if (!bRet)
		{
			ErrorHandler("StopService", "QueryServiceStatus", GetLastError());
			CloseServiceHandle(hService);
			CloseServiceHandle(hSCM);
			return false;
		}

		nTimeWaited++;
	}

	if (SERVICE_STOPPED != sStatus.dwCurrentState)
	{
		ErrorHandler("StopService", "QueryServiceStatus", GetLastError());
		CloseServiceHandle(hService);
		CloseServiceHandle(hSCM);
		return false;
	}

	CloseServiceHandle(hService);
	CloseServiceHandle(hSCM);

	return true;
}

bool ServiceControl::InstallService(const char* szMachine, const char* szServiceName, const char* szDisplayName, const char* szBinaryPath)
{
	SC_HANDLE hSCM = NULL;
	SC_HANDLE hService = NULL;

	hSCM = OpenSCManager(szMachine, NULL, SC_MANAGER_CREATE_SERVICE);
	if (NULL == hSCM)
	{
		ErrorHandler("InstallService", "OpenSCManager", GetLastError());
		return false;
	}
		
	hService = CreateService(hSCM, szServiceName, szDisplayName, GENERIC_READ, SERVICE_WIN32_OWN_PROCESS,
							 SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL, szBinaryPath, NULL, NULL, NULL, NULL, NULL);
	if (NULL == hService)
	{
		ErrorHandler("InstallService", "CreateService", GetLastError());
		CloseServiceHandle(hSCM);
		return false;
	}
	
	Log.ReportError(DEBUG, "Successfully installed service '%s' on %s\n", szServiceName, szMachine);
	CloseServiceHandle(hService);
	CloseServiceHandle(hSCM);

	return true;
}

bool ServiceControl::UninstallService(const char* szMachine, const char* szServiceShortName)
{
	SC_HANDLE hSCM = NULL;
	SC_HANDLE hService = NULL;
	bool bRet;

	hSCM = OpenSCManager(szMachine, NULL, SC_MANAGER_CONNECT);
	if (NULL == hSCM)
	{
		ErrorHandler("UninstallService", "OpenSCManager", GetLastError());
		return false;
	}
		
	hService = OpenService(hSCM, szServiceShortName, DELETE);
	if (NULL == hService)
	{
		ErrorHandler("UninstallService", "OpenService", GetLastError());
		CloseServiceHandle(hSCM);
		return false;
	}

	bRet = ::DeleteService(hService);
	if (!bRet)
	{
		ErrorHandler("UninstallService", "DeleteService", GetLastError());
		CloseServiceHandle(hService);
		CloseServiceHandle(hSCM);
		return false;
	}

	Log.ReportError(DEBUG, "Successfully uninstalled service '%s' on %s\n", szServiceShortName, szMachine);
	CloseServiceHandle(hService);
	CloseServiceHandle(hSCM);

	return true;
}
