/******************************************************************************
fgdump - by fizzgig and the foofus.net group
Copyright (C) 2005 by fizzgig
http://www.foofus.net

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
******************************************************************************/
#include "stdafx.h"
#include "SymantecAVControl.h"
#include "AVStatus.h"
#include "ServiceControl.h"

SymantecAVControl::SymantecAVControl()
{
	m_szServiceName = NULL;
}

SymantecAVControl::~SymantecAVControl()
{

}

int SymantecAVControl::GetServiceState(const char* lpszMachine)
{
	SERVICE_STATUS sStatus;
	ServiceControl sc;
	int nResult = AV_UNKNOWN;

	if (sc.QueryServiceStatus(lpszMachine, m_szServiceName, &sStatus) == INSTALLED)
	{
		if (sStatus.dwCurrentState == SERVICE_RUNNING)
			nResult = AV_STARTED;
		else if (sStatus.dwCurrentState == SERVICE_STOPPED)
			nResult = AV_STOPPED;
	}
	else
	{
		nResult = AV_UNKNOWN;
	}

	return nResult;
}

bool SymantecAVControl::IsServiceInstalled(const char* lpszMachine)
{
	SERVICE_STATUS sStatus;
	ServiceControl sc;

	m_szServiceName = "Norton AntiVirus Auto-Protect Service";

	if (sc.QueryServiceStatus(lpszMachine, m_szServiceName, &sStatus) == INSTALLED)
	{
		return true;
	}
	else
	{
		m_szServiceName = "Symantec AntiVirus";
		if (sc.QueryServiceStatus(lpszMachine, m_szServiceName, &sStatus) == INSTALLED)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}

bool SymantecAVControl::StopService(const char* lpszMachine)
{
	ServiceControl sc;

	if (sc.StopService(lpszMachine, m_szServiceName, 120))
	{
		Log.ReportError(INFO, "Stopped Norton AV successfully\n");
		return true;
	}
	else
	{
		Log.ReportError(CRITICAL, "Unable to stop Norton AV, see previous errors for details. Stopping pwdump.\n");
		return false;
	}
}

bool SymantecAVControl::StartService(const char* lpszMachine)
{
	ServiceControl sc;

	if (sc.StartService(lpszMachine, m_szServiceName, 120))
	{
		Log.ReportError(INFO, "Started Norton AV successfully\n");
		return true;
	}
	else
	{
		Log.ReportError(CRITICAL, "Unable to start Norton AV, see previous errors for details.\n");
		return false;
	}
}
