/*h---------------------------------------------------------------------------+
|   fpted.h                                                                   |
+-----------------------------------------------------------------------------+
|                                                                             |
|   Description: FPTED -> Constants and data type definitions.                |
|                                                                             |
|   Contact: Fernando Joaquim Ganhao Pereria (fjp@minerva.inesc.pt).          |
|                                                                             |
|   Dependences: TABS will probably have to be changed in some terminals.     |
|                                                                             |
+----------------------------------------------------------------------------*/

#ifndef _FPTED_DEFS
#define _FPTED_DEFS


#define ESC_TIMEOUT	2		/* Number of seconds after ESC */
#define DEFVAR		"FPTED_DEFS"
#define HELPVAR		"FPTED_HELP"
#define CLIPVAR		"FPTED_CLIPFILE"
#define LSIZE    	256
#define NSIZE		32
#define TABS		8
#define DEF_SHIFT	4
#define JUMP_SCROLL	3
#define MAX_KEYS	12
#define MAX_WAREAS	21

#define SCREEN_LINES	(stdscr->_maxy - stdscr->_begy)

#ifdef USE_LAST_COLUMN
#define SCREEN_COLS 	(stdscr->_maxx)
#else /* USE_LAST_COLUMN */
#define SCREEN_COLS 	(stdscr->_maxx-1)
#endif /* USE_LAST_COLUMN */

#define LAT_SHIFT	((SCREEN_COLS/5)+TABS-(SCREEN_COLS/5)%TABS)

#define CSZ(c, l) (((c)=='\t')?TABS-(l)%TABS:((c)>=' '&&(c)!=K_DELETE)?1:2)
#define EOL( line ) (strlen( line->l ) -1 )
#define ADJUST_X() ( x = act_x > EOL( curr ) ? EOL( curr ) : act_x )
#define is_print( c ) ( (c) >= K_TAB && (c) < 256 && isprint(c) )
#define beep()	putchar( '\007' )

#define BEFORE_BUTTON_DEF( b ) (MOUSE_EVENT + b)
#define AFTER_BUTTON_DEF( b ) (PREF + MOUSE_EVENT + b)

#define head		(working_area._head)
#define curr		(working_area._curr)
#define screen_top	(working_area._screen_top)
#define changed		(working_area._changed)
#define l_number	(working_area._l_number)
#define buffer_size	(working_area._buffer_size)
#define x		(working_area._x)
#define y		(working_area._y)
#define act_x		(working_area._act_x)
#define fname		(working_area._fname)
#define l_mark		(working_area._l_mark)
#define x_mark		(working_area._x_mark)


#define BLOCK_SIZE	4		/* Must be a power of 2: 4, 8 or 16 */

#ifdef AVOID_FRAGMENTATION
#define NEAR_SIZE( s )		((s)|(BLOCK_SIZE-1))
#else /* AVOID_FRAGMENTATION */
#define NEAR_SIZE( s )		(s)
#endif /* AVOID_FRAGMENTATION */

#define ALLOC(size)		(uchar*)malloc( NEAR_SIZE( size ) )
#define REALLOC(line, size)	(uchar*)realloc( line, NEAR_SIZE( size ) )


typedef unsigned char uchar;


typedef struct line {
    uchar *l;
    struct line *prev, *next;
} line;


typedef struct w_area {
    line _head;
    line *_curr;
    line *_screen_top;
    int _l_number;
    int _buffer_size;
    int _changed;
    int _x;
    int _y;
    int _act_x;
    uchar _fname[LSIZE];
    int _l_mark;
    int _x_mark;
} w_area;


typedef struct alias {
    uchar key[MAX_KEYS+1];
    uchar subs[4*MAX_KEYS+1];
} alias;


typedef struct kdef {
    int key;
    char multi[NSIZE];
    int meaning[LSIZE];
} kdef;


#endif /* _FPTED_DEFS */
