//-------------------------------------------------------------------------------
//
//      authtool.h - Using a file of captured SIP messages, for
//                             each request message that includes an
//                             Authorization header line, this tool performs
//                             a dictionary attack in an attempt to produce
//                             the same MD5 digest contained in the message.
//                             The production of the same MD5 digest 
//                             constitutes the discovery of the password 
//                             for the user identified in the message From
//                             header line.
//
//                             A single password may be input on the
//                             command line in lieu of a dictionary.
//
//                             The tool records the results of the attack
//                             to a specified file and/or to the screen. 
//
//    Copyright (C) 2004  Mark D. Collier/Mark O'Brien
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier/Mark O'Brien - 09/20/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-------------------------------------------------------------------------------

/* includes */
#ifndef _AUTHTOOLH
#define _AUTHTOOLH 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <net/if.h>             //where if_nameindex() was hiding
#include <linux/sockios.h>      //for ioctl() arg

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <sys/time.h>
#include <unistd.h>

#include <pcap.h>
#include <libnet.h>
#include <pthread.h>
#include <semaphore.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "global.h"
#include "md5.h"
#include "digcalc.h"

#define	__AUTHTOOL_VERSION "Authentication Tool - Version 1.0"
#define __AUTHTOOL_DATE    "                      09/20/2004"

char    szNonceCount[9]             = "",       // Auth parm
        *psMethod                   = NULL,     // Request's Method     
        *psFrom                     = NULL,     // "From:" header's user's uri
        *psUri                      = NULL,     // Auth header's uri
        *psNonce                    = NULL,     // Auth header's nonce
        *psCNonce                   = "",       // Auth cnonce parm
        *psQop                      = "",       // Auth qop parm
        *psRealm                    = NULL,     // Auth header's realm
        *psUser                     = NULL,     // Auth header's username
        *psPassword                 = NULL,     // password attempted/confirmed
        *psDigest                   = NULL,     // Auth header's MD5 digest
        
        *psDictionaryFile           = NULL,
        *psCapturedMessagesFile     = NULL,
        *psResultsFile              = NULL;

bool    bVerbose                    = false;    //  verbose printing

int     solutions                   = 0;        //  number of user/password solutions

FILE *hCapturedMessagesFile         = NULL;     // captured messages to evaluate
FILE *hDictionaryFile               = NULL;     // dictionary of passwords
FILE *hResultsFile                  = NULL;     // output results file handle

//  MD5 results

HASHHEX HA1;
HASHHEX HA2 = "";
HASHHEX digestResponse;

// function prototypes

bool    foundRequest( char *psLine, char **psMethod );

bool    foundFrom( char *psLine, char **psFrom );

bool    foundAuthorization( char  *psLine,
                            char **psUser,
                            char **psRealm,
                            char **psNonce,
                            char **psUri,
                            char **psDigest
                          );
                        
bool    passwordHammer( void );

void	catch_signals( int signo );      //  signal handler
void	CleanupAndExit( int status );	 //  speaks for itself
void	usage( void );                   //  print usage (arg: program name)

#endif //  _AUTHTOOLH
