//-----------------------------------------------------------------------------
//
// RtpHandler.h - Handler all RTP/RTCP traffic.
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef RTP_HANDLER_H
#define RTP_HANDLER_H

#include <sys/time.h>

#include "jrtplib/rtpsession.h"
#include "jrtplib/rtppacket.h"

class  RtpHandler
{
    public:

        class  RtpEndPoint
        {
            public:
                virtual ~RtpEndPoint( void ) {};

                virtual RTPSession *  GetSession( void ) = 0;
                virtual int           GetRtpSpacing( void ) = 0;
                virtual timeval       GetBurstUntil( void ) = 0;
                virtual timeval       GetJitterUntil( void ) = 0;
                // Returned packet should be deleted.
                virtual RTPPacket *   GetNextRtpPacket( void ) = 0;
                virtual bool          GetUuTest( void ) = 0;
                // Should delete packet given.
                virtual void          IncomingRtpPacket( RTPPacket * ) = 0;
        };

        RtpHandler( void );
        ~RtpHandler( void );

        void   Run( void );
        void   Stop( void );

        void   AddEndPoint( RtpEndPoint *  aValue );
        void   RemoveEndPoint( RtpEndPoint *  aValue );

    private:

        class  sessionNode
        {
            public:
                sessionNode *  Next;
                RtpEndPoint *  EndPoint;
                timeval        NextTransmission;
        };

        bool             mStopFlag;
        pthread_mutex_t  mSessionsMutex;
        sessionNode *    mSessions;
};

#endif

