//-----------------------------------------------------------------------------
//
// SipEndPoint.h - Handles a single end point, placing
//                 and receiving calls by creating new SipCall
//                 objects.
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>

#include "util.h"
#include "SipMessage.h"
#include "SipUdpPort.h"
#include "RtpHandler.h"
#include "SipDispatcher.h"
#include "SipRegistrarConnector.h"
#include "AttackAudio.h"
#include "SipCall.h"
#include "ControlPort.h"

#ifndef SIP_END_POINT_H
#define SIP_END_POINT_H

class RtpHandler;
class SipDispatcher;
class SipRegistrarConnector;
class SipIdentifier;
class ControlPort;

class  SipEndPoint
{
    public:
        SipEndPoint( void );
        ~SipEndPoint( void );

        char *                   GetUser( void );
        // aValue should be malloced, as it will be freed.
        void                     SetUser( char *  aValue );

        char *                   GetTextName( void );
        // aValue should be malloced, as it will be freed.
        void                     SetTextName( char *  aValue );

        SipDispatcher *          GetDispatcher( void );
        void                     SetDispatcher( SipDispatcher *  aDispatcher );

        SipRegistrarConnector *  GetRegistrarConnector( void );
        void                     SetRegistrarConnector( SipRegistrarConnector *
                                                                       aValue );

        RtpHandler *             GetRtpHandler( void );
        void                     SetRtpHandler( RtpHandler *  aValue );

        ControlPort *            GetControlPort( void );
        void                     SetControlPort( ControlPort *  aPort );

        int                      GetControlPortConnectionId( void );
        void                     SetControlPortConnectionId( int  aId );

        unsigned int             GetRingingMinimum( void );
        void                     SetRingingMinimum( unsigned int
                                                    aMilliseconds );

        unsigned int             GetRingingMaximum( void );
        void                     SetRingingMaximum( unsigned int
                                                    aMilliseconds );

        void                     SetAcceptCalls( bool aValue );

        // If true is returned, aMessage has been handled and deleted.
        bool                     Incoming( SipMessage *  aMessage );

        void                     RelayCallsTo( SipIdentifier *  aIdentifier );

        void                     TapCallsTo( SipIdentifier *  aIdentifier );
        
        bool                     PrepAttackAudio(
                                    bool bToCaller,
                                    char *  psInputAudioFile,
                                    AttackAudioMethod attackAudioMethod );
                                             
        AttackAudio *            GetCallerAttackAudio( void );
        AttackAudio *            GetCalleeAttackAudio( void );

    private:

        char *                   mUser;
        char *                   mTextName;
        SipDispatcher *          mDispatcher;
        SipRegistrarConnector *  mRegistrarConnector;
        RtpHandler *             mRtpHandler;
        ControlPort *            mControlPort;
        int                      mControlPortConnectionId;
        unsigned int             mRingingMinimum;
        unsigned int             mRingingMaximum;
        bool                     mAcceptCalls;
        SipIdentifier *          mRelayCallsTo;
        SipIdentifier *          mTapCallsTo;
        
        //
        //  A sipendpoint can be commanded to relay incoming calls 
        //  addressed to its uri to a different NamedUri. If a sipendpoint
        //  has been commanded to relay calls, then it behaves as a
        //  B2BUA when a call arrives that is addressed to the uri
        //  of the sipendpoint. In that context, the "callee" is the
        //  NamedUri to which the call is relayed. The "caller" is the
        //  uri from which the call was received by this sipendpoint.
        //
        //  If the sipendpoint has not been commanded to relay calls 
        //  when a call arrives, then it answers the call and loops
        //  back the incoming audio. If an audio attack command
        //  (i.e. mix, insert) is pending at the time the call is received
        //  or is issued while the call is up, the nomenclature
        //  "caller" and "callee" is irrelevant and the endpoint 
        //  attacked (i.e. mix, insert) is the uri from whom the call
        //  was received. 
        //
        
        AttackAudio *            mCallerAttackAudio;
        AttackAudio *            mCalleeAttackAudio;        
};

#endif

