//-----------------------------------------------------------------------------
//
// SipHeader.h - Class for a single SIP header line.
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef SIP_HEADER_H
#define SIP_HEADER_H

#include "SipIdentifier.h"

class  SipHeader
{
    public:
        SipHeader( SipHeader *  aCopyFrom );
        // Ensure aFullText is malloced, as it will be freed.
        SipHeader( char *  aFullText );
        // aName and aValue don't need to be malloced, as they won't be freed.
        SipHeader( char *  aName, char *  aValue );
        ~SipHeader( void );

        char *           GetFullText( void );
        char *           GetName( void );
        char *           GetValue( void );

        int              GetIdentifierCount( void );
        SipIdentifier *  GetIdentifier( int  aIndex );

    private:
        class  identifierNode
        {
            public:
                SipIdentifier *   Value;
                identifierNode *  Next;
        };

        char *            mFullText;
        char *            mName;
        char *            mValue;
        int               mIdentifierCount;
        identifierNode *  mIdentifiers;
};

#endif

