//-----------------------------------------------------------------------------
//
// SipIdentifier.h - Class for a single SIP identifier, which
//                   could be a SIP URI, SIPS URI, Absolute URI,
//                   or a display name + any of the previous. Also,
//                   SIP identifier can have parameters of their
//                   own.
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef SIP_IDENTIFIER_H
#define SIP_IDENTIFIER_H

#include "SipUri.h"

class  SipIdentifier
{
    public:
        SipIdentifier( SipIdentifier *  aCopyFrom );
        // Ensure aFullText is malloced, as it will be freed.
        SipIdentifier( char *  aFullText );
        ~SipIdentifier( void );

        char *    GetFullText( void );
        char *    GetName( void );
        SipUri *  GetUri( void );

        int       GetParameterCount( void );
        char *    GetParameterName( int  aIndex );
        char *    GetParameterValue( int  aIndex );
        char *    GetParameterValue( char *  aName );

    private:
        class  parameterNode
        {
            public:
                char *           Name;
                char *           Value;
                parameterNode *  Next;
        };

        char *           mFullText;
        char *           mName;
        SipUri *         mUri;
        char *           mStartOfParameters;
        int              mParameterCount;
        parameterNode *  mParameters;
};

#endif

