//-----------------------------------------------------------------------------
//
// SipProxyEndPoint.h
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef SIP_PROXY_END_POINT_H
#define SIP_PROXY_END_POINT_H

class SipDispatcher;
class SipRegistrarConnector;
class SipRegistrar;
class SipIdentifier;
class ControlPort;

class  SipProxyEndPoint
{
    public:
        SipProxyEndPoint( void );
        ~SipProxyEndPoint( void );

        char *                   GetUser( void );
        // aValue should be malloced, as it will be freed.
        void                     SetUser( char *  aValue );

        char *                   GetTextName( void );
        // aValue should be malloced, as it will be freed.
        void                     SetTextName( char *  aValue );

        SipIdentifier *          GetTo( void );
        void                     SetTo( SipIdentifier *  aTo );

        SipDispatcher *          GetDispatcher( void );
        void                     SetDispatcher( SipDispatcher *  aDispatcher );

        SipRegistrarConnector *  GetRegistrarConnector( void );
        void                     SetRegistrarConnector( SipRegistrarConnector *
                                                                       aValue );

        ControlPort *            GetControlPort( void );
        void                     SetControlPort( ControlPort *  aPort );

        int                      GetControlPortConnectionId( void );
        void                     SetControlPortConnectionId( int  aId );

        void                     SetParentRegistrar(
                                                   SipRegistrar *  aRegistrar );

        // If true is returned, aMessage has been handled and deleted.
        bool                     Incoming( SipMessage *  aMessage );


    private:
        char *                   mUser;
        char *                   mTextName;
        SipIdentifier *          mTo;
        in_addr_t                mToAddress;
        in_port_t                mToPort;
        SipDispatcher *          mDispatcher;
        SipRegistrarConnector *  mRegistrarConnector;
        ControlPort *            mControlPort;
        int                      mControlPortConnectionId;
        SipRegistrar *           mParentRegistrar;
};

#endif

