//-----------------------------------------------------------------------------
//
// SipRegistrar.h
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef SIP_REGISTRAR_H
#define SIP_REGISTRAR_H

#define SIP_REGISTRAR_TABLE_SIZE 1024   // Use powers of 2
#define SIP_REGISTRAR_TABLE_MASK 0x03ff // Size - 1

class SipDispatcher;
class SipMessage;
class SipProxyEndPoint;
class ControlPort;

class  SipRegistrar
{
    public:
        SipRegistrar( void );
        ~SipRegistrar( void );

        char *                   GetDomain( void );
        // aValue should be malloced, as it will be freed.
        void                     SetDomain( char *  aValue );

        SipDispatcher *          GetDispatcher( void );
        void                     SetDispatcher( SipDispatcher *  aDispatcher );

        // If true is returned, aMessage has been handled and deleted.
        bool                     Incoming( SipMessage *  aMessage );

        char *                   GetFirstResolution( char *  mName );
        char *                   GetRandomResolution( char *  mFromName,
                                                      char *  mToName );

        ControlPort *            GetControlPort( void );
        void                     SetControlPort( ControlPort *  aPort );

        int                      GetControlPortConnectionId( void );
        void                     SetControlPortConnectionId( int  aId );

        bool                     GetRandomization( void );
        void                     SetRandomization( bool  aValue );


    private:
        class  registrationEntry
        {
            public:
                registrationEntry *  Next;
                char *               ToUser;
                char *               ContactLine;
                SipProxyEndPoint *   ProxyEndPoint;
        };

        SipDispatcher *      mDispatcher;
        char *               mDomain;
        registrationEntry *  mEntryTable[SIP_REGISTRAR_TABLE_SIZE];
        ControlPort *        mControlPort;
        int                  mControlPortConnectionId;
        bool                 mRandomization;
};

#endif

