//-----------------------------------------------------------------------------
//
// SipRegistrarConnector.h - 
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#ifndef SIP_REGISTRAR_CONNECTOR_H
#define SIP_REGISTRAR_CONNECTOR_H

#include <netinet/in.h>
#include <sys/time.h>
#include <pthread.h>

class SipDispatcher;
class SipEndPoint;
class SipProxyEndPoint;

class  SipRegistrarConnector : public SipDispatcher::Timer,
                               public SipDispatcher::UndispatchedHandler
{
    public:
        SipRegistrarConnector( void );
        ~SipRegistrarConnector( void );

        SipDispatcher *  GetDispatcher( void );
        void             SetDispatcher( SipDispatcher *  aValue );
        in_addr_t        GetAddress( void );
        void             SetAddress( in_addr_t  aValue );
        in_port_t        GetPort( void );
        void             SetPort( in_port_t  aValue );
        // Do not free return value.
        char *           GetDomain( void );
        // Ensure aValue is malloced, as it will be freed.
        void             SetDomain( char *  aValue );
        void             AddEndPoint( SipEndPoint *  aValue );
        void             RemoveEndPoint( SipEndPoint *  aValue );
        void             AddProxyEndPoint( SipProxyEndPoint *  aValue );
        void             RemoveProxyEndPoint( SipProxyEndPoint *  aValue );

        // Timer Functions
        //

        // When is in milliseconds. Now is formulated with:
        //   ( timeval.tv_sec & 0x003fffff ) * 1000
        // + timeval.tv_usec / 1000
        unsigned long  GetWhen( void );
        void           Fire( void );

        //
        // End of Timer Functions

        // UndispatchedHandler Function
        //
        bool  Incoming( SipMessage *  aMessage );
        //
        // End of UndispatchedHandler Function

    private:
        typedef enum
        {
            STATE_INVALID = -1,
            STATE_CREATED,
            STATE_REGISTER_SENT,
            STATE_REGISTERED
        }  endPointNodeState;

        class  endPointNode
        {
            public:
                endPointNode( void );
                ~endPointNode( void );

                struct endPointNode *  Next;
                SipEndPoint *          EndPoint;
                endPointNodeState      State;
                timeval                RegistrationExpires;
                char *                 Branch;
                char *                 Tag;
                int                    CSeq;
        };

        class  proxyEndPointNode
        {
            public:
                proxyEndPointNode( void );
                ~proxyEndPointNode( void );

                struct proxyEndPointNode *  Next;
                SipProxyEndPoint *          ProxyEndPoint;
                endPointNodeState      State;
                timeval                RegistrationExpires;
                char *                 Branch;
                char *                 Tag;
                int                    CSeq;
        };

        // Must already hold lock of mEndPointsMutex.
        bool  sendRegister( endPointNode *  aNode );

        // Must already hold lock of mProxyEndPointsMutex.
        bool  sendRegister( proxyEndPointNode *  aNode );

        SipDispatcher *  mDispatcher;
        in_addr_t        mLocalAddress;
        in_addr_t        mRemoteAddress;
        in_port_t        mRemotePort;
        char *           mDomain;
        unsigned long    mTimerWhen;
        pthread_mutex_t  mEndPointsMutex;
        endPointNode *   mEndPoints;
        pthread_mutex_t  mProxyEndPointsMutex;
        proxyEndPointNode *   mProxyEndPoints;
        char *           mCallId;
        int              mCseq;
};

#endif

