//-----------------------------------------------------------------------------
//
// waitfor.c - Quick pipe tool that will exit upon matching a string.
//
//    Copyright (C) 2004  Mark D. Collier
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//   Author: Mark D. Collier   - 12/01/2006   v1.1
//                   Mark D. Collier   -  04/26/2004  v1.0
//         www.securelogix.com - mark.collier@securelogix.com
//         www.hackingexposedvoip.com
//
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <string.h>

int  main( int  argc, char **  argv )
{
    char    line[1024];
    char *  marker;

    switch ( argc )
    {
        case 1:
            marker = "WAIT_FOR_MARKER";
            break;
        case 2:
            marker = argv[1];
            break;
        default:
            printf( "Syntax: waitfor [marker]\n" );
            return -1;
    }

    while ( fgets( line, 1024, stdin ) )
    {
        printf( "%s", line );
        if ( strstr( line, marker ) )
        {
            return 1;
        }
    }

    return 0;
}

