/*
*
* Deception Finger Daemon 0.7
*
* BE SURE TO READ THE FILE README!
* Reading this file may save you a lot of head scratching later.
*
* Feel free to change and mess around with the code. However, if redistributed,
* please include credits to myself and/or decfingerd.
*
*/

#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <dirent.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>

void FatalError(char msg[100]);
void ShowUser(char user[256]);
void EmptyRequest(char *remote);
void ForwardRequest(char *remote, char whereto[]);

struct sockaddr_in foonet;

int main(void) {
	
	char input[20], message[100];
	struct dirent *direntry;
	char *remoteIP;
	int length;
	int counter=0;  // Counter for the loop looking for a '@'

	DIR *dir;

	openlog("decfingerd", LOG_PID, 0);

	length = sizeof(foonet);
	if(getpeername(0, (struct sockaddr *)&foonet, &length) == -1) {
		/* Let's hope this never happens */
		printf("Unable to get user information!\n");
		syslog(0, "A serious type error: getpeername failed\n");
		exit(1);
	}

	remoteIP = inet_ntoa(foonet.sin_addr);

	if(!(dir = opendir("/etc/decfingerd/"))) 
		FatalError("Unable to open directory to get user data");

	fgets(input, sizeof(input), stdin);

	/* Make sure they sent something (I dont know how well this works) */
	if((strlen(input) == 2) && (input[1] != '\n')) {
		sprintf(message, "POSSIBLE TCP PORT SCAN: Client %s connected but did not make a request\n", remoteIP);
		syslog(0, message, sizeof(message));
		exit(0);
	}  

	/* Get rid of the junk */
	input[strlen(input) - 2] = '\0';

	if(input[1] == '\n') 
		EmptyRequest(remoteIP);

	while(input[counter] != '\0') {
		if(input[counter] == '@')
			ForwardRequest(remoteIP, input);
		counter++;
	}

	sprintf(message, "Client %s requested info for %s\n", remoteIP, input);
	syslog(0, message, sizeof(message));

	while((direntry = readdir(dir))) {
		if(!strcmp(".", direntry->d_name))
			continue;
		if(!strcmp("..", direntry->d_name))
			continue;
		if(!strcmp("empty.request", direntry->d_name))
			continue;
		if(!strcmp("forward.request", direntry->d_name))
			continue;
		if(!strcmp(input, direntry->d_name)) 
			ShowUser(input);
	}
	/* If we're here, then there's no such "user". */
	printf("No such user.\n");
	exit(0);
}

void FatalError(char msg[100]) {

	printf("FATAL ERROR: %s\n", msg);
	syslog(0, "FATAL ERROR: %s\n", msg);
	exit(1);
}

void ShowUser(char user[256]) {

	FILE *file;

	char line[1000];   // Line from the file
	char pathname[256] = "/etc/decfingerd/";
	char message[100];
	strcat(pathname, user);

	if((file = fopen(pathname, "r")) == NULL) {
		/* If you get this, check permissions */
		printf("Unable to get user information!\n");
		sprintf(message, "Unable to open /etc/decfingerd/%s, check permissions\n", user);
		syslog(0, message);
		exit(1);
	}

	while(fgets(line, sizeof(line), file)) 
		printf("%s", line);
	
	exit(0);	
}

void EmptyRequest(char *remote) {

	FILE *file;

	char line[1000];   // Line from the file
	char message[100];

	if((file = fopen("/etc/decfingerd/empty.request", "r")) == NULL) {
		/* If you get this, check permissions */
		printf("Unable to get user information!\n");
		syslog(0, "Unable to open /etc/decfingerd/empty.request, check permissions\n");		
		exit(1);
	}

	sprintf(message, "Client %s performed an empty request\n", remote);
	syslog(0, message, sizeof(message));

	while(fgets(line, sizeof(line), file))
		printf("%s", line);

	exit(0);
}

void ForwardRequest(char *remote, char whereto[]) {

	FILE *file;

	char line[1000];
	char message[100];

	if((file = fopen("/etc/decfingerd/forward.request", "r")) == NULL) {
		/* If you get this, check permissions */
		printf("Unable to get user information!\n");
		syslog(0, "Unable to open /etc/decfingerd/forward.reqeust, check permissions\n");
		exit(1);
	}

        sprintf(message, "Client %s performed a forward request to %s\n", remote, whereto);
        syslog(0, message, sizeof(message));

	while(fgets(line, sizeof(line), file))
		printf("%s", line);

	exit(0);
}

