/*
 *
 *	This is free software. You can redistribute it and/or modify under
 *	the terms of the GNU Library General Public License version 2.
 * 
 *	Copyright (C) 1999 by kra
 *
 */
#include <string.h>
#include <qpthr/qp.h>

void QpBase::SetName(const char *name)
{
	if (b_name)
		delete [] b_name;
	if (name) {
		if (!(b_name = new char[strlen(name) + 1]))
			throw QpOutOfMemoryException();
		strcpy(b_name, name);
	} else
		b_name = NULL;
}

extern "C" {
	
void do_msg(const char *fmt, ...)
{
        va_list ap;
	
	if (fmt) {
	        va_start(ap, fmt);
        	vfprintf(stderr, fmt, ap);
	        va_end(ap);
		fflush(stderr);
	}
}

void do_exit(const char *fmt, ...)
{
        va_list ap;

	if (fmt) {
	        va_start(ap, fmt);
        	vfprintf(stderr, fmt, ap);
	        va_end(ap);
		fflush(stderr);
	}
	if (QpInit::Capability(QpInit::QP_SIGNAL)) {
		/* 
		 * tell the signal thread to exit everything
		 * because it is not reliable to exit from
		 * signal handler within thread that received it
		 */
		QpSignal::Exit();
	} else {
#ifdef LINUX
		exit(1);	/* well, Linux has some thread cleaning on on_exit */
#else
		_exit(1);
#endif
	}
	_exit(1);
}

} /* extern "C" */

