/* Definitions */
/* Lengths of the different fixed-length codes */
#define CUECAT_DEVICE_ID_LEN    18
#define CUECAT_BARCODE_TYPE_LEN  3
#define CUECAT_BARCODE_SUBTYPE_LEN  1

/* Barcode decoder return codes */
#define BARCODE_DECODER_ERROR                 -1	/* Internal error */
#define NO_BARCODE_DECODING_IN_PROGRESS       0
#define POSSIBLE_BARCODE_DECODING_IN_PROGRESS 1
#define BARCODE_DECODED                       2 

/* Maximum number of scancodes sent by the cuecat in one transmission :
     ALT-F10 = 4 scancodes
   + '.'     = 2 scancodes
   + 6*4 capital letters (4 scancodes each)
   + '.'     = 2 scancodes
   + 4 capital letters (4 scancodes each)
   + '.'     = 2 scancodes
   + 12*4+3 capital letters (4 scancodes each)
   + '.'     = 2 scancodes
   + '\n'    = 2 scancodes
   = 330 scancodes

   NOTE : it has been measured that the longest barcode the CueCat can send is
          a CODE128-B of 19 characters (that can all be uppercase) or a
          CODE128-C of 38 digits. In the first case, 19 characters are coded on
          26 coded triplet characters, i.e. 4*26=104 scancodes if all of them
          are uppercase. In the second case, 38 digits are coded on 51 coded
          triplet characters, i.e. 4*51=204 scancodes if all of them are upper-
          case. So the longest barcode will be sent with 204 scancodes.
*/ 
#define CUECAT_MAX_SCANCODE_SEQUENCE 4+2+(6*4*4)+2+(4*4)+2+((12*4+3)*4)+2+2



/* Types */
/* This structure has all the variables necessary to describe the state of
   the scancode decoder */
struct scancode_decoder_state
{
  char got_shift_press;
  char got_alt_press;
  char got_letter_press;
  char got_letter_release;
  char temp_read_char;
  char prev_read_char;
  char read_char;
  char ALT_F10_early_notice;
};

/* This structure has all the variables necessary to describe the state of
   the barcode decoder */
struct barcode_decoder_state
{
  char global_barcode_decoder_state;
  char nb_dots_read;
  int  nb_codes_read;
  char triplet_encoded_char_counter;
  char current_coded_triplet_char;
  char coded_triplet_chars[4];

  struct scancode_decoder_state scancode_decoder_state;
};



/* Function prototypes */
void cuecat_reset_barcode_decoder(struct barcode_decoder_state *state);
char cuecat_decode_barcode(struct barcode_decoder_state *state,
                           unsigned char scancode,
                           char *cuecat_id,
                           char *barcode_type,
                           char *barcode);
