/*
 * Catches errordocument requests, looks up barcode. If the barcode is found,
 * it writes information into a file with the name of the barcode.
 *
 * Put this into .htaccess
 * AddHandler cgi-script .x
 * Options +ExecCGI
 * ErrorDocument 404 /barcode/fooweb.x
 * DirectoryIndex index.html index.txt
 *
 */
 
#include <stdio.h>
#include <string.h>
#include "libfoocat.h"

#define BUFSIZE 4096

// move to libcue later
int isbarcode(char * data);


int main(int argc, char **argv) 
{
	int 						l;
	char					 	path[BUFSIZE];
	char					 	scan[BUFSIZE];
	char						*cptr=NULL;
	struct chunks 	*c=NULL;
	struct bookinfo	*bi=NULL;
	struct cueinfo	*ci=NULL;

	printf("Content-type: text/plain\r\n\r\n");

	memset(path,0,BUFSIZE);
	memset(scan,0,BUFSIZE);

	if (getenv("SCRIPT_NAME"))
	{
		strncpy(path,getenv("SCRIPT_NAME"),BUFSIZE);
		
		l=strlen(argv[0]);
		if (l<BUFSIZE)
		{
			path[1+l]=0;
		};
		l=strlen(path);
		if (getenv("SCRIPT_NAME"))
		{
			strncpy(path,getenv("REQUEST_URI"),BUFSIZE);
		};
		cptr=(&path[l]);
		strncpy(path,cptr,BUFSIZE);
		strcpy(scan,path);
	};

	printf("path:[%s]\n",path);


	if (strlen(path)>0)
	{

		c=convert(scan);

		if (c!=NULL)
		{
			decode_type(c);
			bi=doamazon(c,6);
			ci=docue(c,NULL,6);
			// this is a cuecat barcode scan
			printf("scan data:[%s]\n",c->data);
		}
		else
		{
			// it's something else
			// here's where we run the sample through various
			// filters to see what kind of barcode it is.
			if (isbarcode(path))
			{
				printf("barcode queued for discovery.\n");
			}
			else
			{
				printf("unrecognized barcode format.\n");
			};
		};
	}
	else
	{
		// it's nothing.
		printf("no data\n");
	};
	
	return 0;
};

int isbarcode(char * data)
{
	return 1;
};

