/*
 *
 * CueCat decoder
 *
 * (c) 2000 Michael Rothwell
 * rothwell@holly-springs.nc.us
 *
 * CueCat decoder section of decode_type provided by Leonid A. Broukhis, leob@mailcom.com
 * Thanks!
 *
 * Released under the GPL
 *
 * Due to legal boogabooga from Kenyon and Kenyon, the paid shills
 * of Digital Hemmorhoid, Inc., I have disabled the cuecat lookup
 * portions of this library. I will not be updating them for the time
 * being, and they do not currently work.
 * 
 * URLs to look stuff up at:
 * http://shop.barnesandnoble.com/booksearch/isbnInquiry.asp?isbn=0345333926
 * http://mbln.lib.ma.us/MARION?key=0395563526&ind=B
 * http://www.amazon.com/exec/obidos/ASIN/031286308X
 * http://www.dlis.dla.mil/upc/scripts/oleisapi2.dll/isapi.isapidb.normal?TARGET=CHOOSE.HTX&UPC=720642470626
 * http://www.debarcode.com/deBarcode/cgi-bin/deBarcode.cgi?type=U.P.C.%20A&barcode=720642470626
 *
 */

#include "libfoocat.h"

char codetable[256];
int	__base64_codetable_initialized=0;

// doesn't free null pointers
void deallocmem(void *ptr)
{
	if (ptr != NULL)
	{
//		printf("freeing memory\n");
		free(ptr);
		ptr=NULL;
	}
	else
	{
//		fprintf(stderr,"trying to free null pointer\n");
	};
};

struct chunks *convert(char *sample)
{
	struct chunks *c;
	int i;

	c=chunk(sample);

	if (c != NULL)
	{
		c->serial 	= decode(c->serial,strlen(c->serial));
		c->data		= decode(c->data,strlen(c->data));
		c->ctype	= decode(c->ctype,strlen(c->ctype));
	};
	
	return c;
};


struct chunks *chunk(char *sample)
{
	int 					x,y,l,i;
	struct chunks *ret;
	char 					*sd=NULL, 
								*cue=NULL, 
								*cueptr=NULL;

	if (sample==NULL)
	{
		return NULL;
	};

	ret=(struct chunks *)malloc(sizeof(struct chunks));
	sd=(char *)malloc(sizeof(char) * strlen(sample));
	memset(sd,0,strlen(sample));
	
	for(i=0; i<strlen(sample);i++)
	{
		if((sample[i]==10) | (sample[i]==13))
		{
			sample[i]=0;
		};
	};

	cueptr=index(sample,'.');
	if (cueptr==NULL)
	{
		deallocmem(ret);
		deallocmem(sd);
		return NULL;
	};
	strcpy(sd,cueptr);
	
	ret->scandata=sd;
	ret->serial=NULL;
	ret->ctype=NULL;
	ret->data=NULL;
	ret->formatted=NULL;

	y=0;
	l=strlen(sample);
	
	for (x=0; x<l; x++)
	{
		if (sample[x]=='.')
		{	
			y++;
			sample[x]=0;
			switch(y)
			{
				case 1:
					ret->serial=(&sample[x])+1;
					break;
				case 2:
					ret->ctype=(&sample[x])+1;
					break;
				case 3:
					ret->data=(&sample[x])+1;
					break;
			};
		};
		if (y>=4) {break;};
	};
	if (y!=4)
	{
		deallocmem(ret);
		return NULL;
	}
	else
	{
		return ret;
	};
}; //chunk


void init_codetable()
{
	int i;

	
	for (i=0; i<255; i++)
	{
		codetable[i]=0x80;
	};

	for (i='a'; i <= 'z'; i++)
	{
		codetable[i] = (i - 'a');
	};

	for (i='A'; i <= 'Z'; i++)
	{
		codetable[i] = 26 + (i - 'A');
	};

	for (i='0'; i <= '9'; i++)
	{
		codetable[i] = 52 + (i - '0');
	};

	codetable['+']=62;
	codetable['-']=63; //  "Leonid A. Broukhis"
	
};

// advance 4 chars at a time through encoded sequence,
// produce base64-decoded output
char *decode(char *buf, int length)
{
	char 	*ret=NULL;
	char 	*txt=NULL;
	int 	i,j,k,t,z,l,x;
	unsigned char	a[4], b[4], c[4];
	unsigned long int n;

	if (__base64_codetable_initialized==0)
	{
		__base64_codetable_initialized=1;
		init_codetable();
	};

	
	if (length > 0)
	{
		// malloc more than enough space for return value
		ret=(char *)malloc(sizeof(char)*length);
		memset(ret,0,length);

		// copy source string into zeros-padded area
		txt=(char *)malloc(sizeof(char)*length+50);
		memset(txt,0,length+50);
		memcpy(txt,buf,length);
		length=strlen(txt);

		l=4-((length)%4);
		j=0;
		k=0;

		while(1)
		{
			memset(a,0,4);
			memset(b,0,4);
			memset(c,0,4);
			
			n=0;

			x=0;
			for(i=0; i<4; i++)
			{
				x++;
				if (x>length)
				{
					deallocmem(ret);
					deallocmem(txt);
					return NULL;
				};
				// skip invalid chars
				if (codetable[ txt[j+1] ] & 0x80) 
				{
					i--;
					continue;
				};
				b[i]=(unsigned char)codetable[ txt[j+i] ];
			};

			n = ((b[0] << 6 | b[1]) << 6 | b[2]) << 6 | b[3];
			ret[k]=(char)((n>>16)^67);
			ret[k+1]=(char)((n>>8 & 255)^67);
			ret[k+2]=(char)((n & 255)^67);

			j+=4;
			k+=3;

			if(j >= length)
			{
				if (l!=4)
				{
					ret[strlen(ret)-l]=0;
				};

				if (txt !=NULL)
				{
					deallocmem(txt);
					txt=NULL;
				};
				return ret;
			};
		};
	}
	else
	{
		return NULL;
	};
}		

void upa(struct chunks *c)
{
	char	buf[100];
	char	*ptr,*ret;

	if (c==NULL)
	{
		return;
	};
	if (c->data==NULL)
	{
		return;
	};
	if (strlen(c->data)!=12)
	{
		return;
	};

	strncpy(buf,c->data,100);
	ptr=(&buf[1]);
	buf[strlen(buf)-1]=0;
	ret=(char *)malloc(sizeof(char)*strlen(ptr));
	strcpy(ret,ptr);
	c->formatted=ret;
	return;
};

int decode_type(struct chunks *c)
{
	int 	ret=0;
	int 	i,j,s;
	char	buf[1024];
	char	*fret;

	memset(buf,0,1024);
	s=0;

	if (c==NULL)
	{
		return -1;
	};

	if (c->ctype==NULL)
	{
		return -1;
	};

	if (strcmp(c->ctype,"UPA")==0)
	{
		upa(c);
	};

	if ((strcmp(c->ctype,"IB5")==0) || (strcmp(c->ctype,"IBN")==0))
	{
		for (i=3; i<=11; i++)
		{
			buf[i-3]=c->data[i];
		};
		for (i=0; i<strlen(buf); i++)
		{
			j=buf[i]-48;
			if (j==40 || j==72) {j=10;};
			if (j>10) {j=0;};
			if (j<0) {j=0;};
			s+=j*(i+1);
		};
		s=s%11;
		if (s==10)
		{
			buf[9]=88;
		}
		else
		{
			buf[9]=(s+48);
		};
		fret=(char *)malloc(sizeof(char)*strlen(buf));
		strcpy(fret,buf);
		c->formatted=fret;
		return 0;
   } 
   else if (strncmp(c->ctype,"CC", 2)==0) 
   {
		unsigned char x = c->ctype[2];
		fret = (char *)malloc(4 + strlen(c->data) * 2);
		c->formatted = fret;
		fret[0] = 'C';
		fret[1] = (x - ' ') / 10 + '0';
		fret[2] = (x - ' ') % 10 + '0';
		for (i = 0, j = 3; i < strlen(c->data); i++, j += 2) 
		{
			x = c->data[i];
			fret[j] = (x - ' ') / 10 + '0';
			fret[j+1] = (x - ' ') % 10 + '0';
		}
		fret[strlen(c->data) * 2 + 3] = '\0';
		c->formatted=fret;
		return 0;
	}
	return -1;
};


int http_head(char* url, int timeout)
{
	char									headers[2048];
	char									server[1024],
												path[2048];
	char 									*i = NULL;
	struct sockaddr_in		sin;
	int 									rb,
												tb,
												p;
	int 									sock;
	struct hostent 				*hp;
	char 									buffer[FETCH_CHUNK+1024];
	fd_set 								fds_read;
	fd_set 								fds_write;
	struct 								timeval tv;
	char									*ret;
	char 									bs;
	int										x,y,z;

	if (timeout < 0)
	{
		timeout=0;
	};

	if (timeout > 360)
	{
		timeout=360;
	};
	
//	printf("timeout:%d\n",timeout);

	server[0]=0;
	path[0]=0;

	sscanf(url,"http://%s",headers);
	i=index(headers,'/');
	*i=32;
	sscanf(headers,"%s%s",server,path);
	sprintf(headers,"HEAD /%s HTTP/1.0\r\n\r\n",path);

	if((hp = gethostbyname(server)) == NULL)
			// oops
			return 500;
	else
	{
		bzero(&sin, sizeof(sin));
    memcpy((char *) &sin.sin_addr, hp->h_addr, sizeof(struct in_addr));
		sin.sin_family = AF_INET;
    sin.sin_port = (unsigned short) htons( 80 );		
	};

	if((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0)
			return 500;
	if(connect(sock, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) < 0)
			return 500;

	FD_ZERO(&fds_write);
	FD_SET(sock, &fds_write);
	tv.tv_sec = 5; // 5 sec timeout
	tv.tv_usec = 0;

	if(select(sock+1, NULL, &fds_write, NULL, &tv) < 1) {
			close(sock);
			return 500;
	};

	write(sock, headers, strlen(headers)),strlen(headers);

	FD_ZERO(&fds_read);
	FD_SET(sock, &fds_read);
	tv.tv_sec = timeout; // 5 sec timeout
	tv.tv_usec = 0;

	if(select(sock+1, &fds_read, NULL, NULL, &tv) < 1) {
			shutdown(sock,2);
			close(sock);
			fprintf(stderr,"timeout waiting for server\n");
			return 500;
	};

//	printf("[1]\n");

	ret=(char *)malloc(sizeof(char) * FETCH_CHUNK);
	if (ret==NULL)
	{
		fprintf(stderr, "No memory. Killing kswapd\n"); //linux
		return 500;
	}

//	printf("[2]\n");

	memset(ret,0,FETCH_CHUNK);
	tb=0;
	p=0;
	
	do
	{
		FD_ZERO(&fds_read);
		FD_SET(sock, &fds_read);
		tv.tv_sec = timeout; // 5 sec timeout
		tv.tv_usec = 0;

		if(select(sock+1, &fds_read, NULL, NULL, &tv) < 1) {
				shutdown(sock,2);
				close(sock);
				fprintf(stderr, "timeout waiting to read\n");
				break;
		};

		rb = read(sock, buffer, FETCH_CHUNK-1);
		tb+=rb;
		if (tb > 0)
		{
			ret=(char *)realloc(ret,sizeof(char) * tb);
			if (ret==NULL)	
			{
				// out of memory
				fprintf(stderr, "No memory. Killing kswapd\n"); //linux
				return 500;
			};
			memcpy((char *)(&ret[p]), (char *)buffer, rb);
		};
		p=tb;
	} while (rb>0);

	shutdown(sock,2);
	close(sock);
	
	if ((tb > 0) & (ret !=NULL))
	{
		z=500;
		// get code
		sscanf(ret,"HTTP/%i.%i %i ",&x,&y,&z);
		deallocmem(ret);
		return z;
	}
	else
	{
		// assume 404
		deallocmem(ret);
		return 404;
	};
		
};

struct httpreq *new_httpreq()
{
	struct httpreq	*ret;
	ret=malloc(sizeof(struct httpreq));
	if (ret==NULL)
	{
		return NULL;
	};
	ret->host=NULL;
	ret->path=NULL;
	ret->op=NULL;
	ret->status=NULL;
	ret->data=NULL;
	ret->length=0;
	ret->port=80;
	ret->proxy=0;
	ret->fd=-1;
	return ret;
};

void free_httpreq(struct httpreq *h)
{
	deallocmem(h->host);
	deallocmem(h->path);
	deallocmem(h->op);
	deallocmem(h->status);
	deallocmem(h->data);
	deallocmem(h);	
};

struct httpreq *parse_url(char *url)
{
	struct httpreq 	*ret;
	char						buf[2048];
	char						buf2[2048];
	char						*i,*j = NULL;
	char						**k;
	int							x=0;
	
	if (url==NULL)
	{
		return NULL;
	};

	buf[0]=0;

	strcpy(buf,url);
	for (x=0; x<strlen(url); x++)
	{
		buf[x]=tolower(buf[x]);
	};

	i=strstr(buf,"http://");
	if (strlen(buf)==0 | i==NULL)
	{
		return NULL;
	};

	strcpy(buf,url);
	j=(&buf[7]);
	
	i=index(j,'/');
	if (i!=NULL)
	{
		*i=32;
	}
	else
	{
		strcat(j," /");
	};

	ret=new_httpreq();
	ret->host=(char *)malloc(sizeof(char)*2048);
	ret->path=(char *)malloc(sizeof(char)*2048);
	sscanf(j,"%s%s",ret->host,ret->path);

	strcpy(buf,ret->host);

	i=strstr(buf,":");
	if (i!=NULL)
	{
		*i=32;
		sscanf(buf,"%s%s",ret->host,buf);
		x=0;
		x=strtol(buf,k,10);
		ret->port=x;
	};
	
	return ret;
	
};

char * fetch(char* url, int * buflen, int timeout)
{
	char									headers[2048];
	char									server[1024],
												path[2048];
	char 									*i = NULL;
	struct sockaddr_in		sin;
	int 									rb,
												tb,
												p;
	int 									sock;
	struct hostent 				*hp;
	char 									buffer[FETCH_CHUNK+1024];
	fd_set 								fds_read;
	fd_set 								fds_write;
	struct 								timeval tv;
	char									*ret;
	char bs;

	if (timeout < 0)
	{
		timeout=0;
	};

	if (timeout > 360)
	{
		timeout=360;
	};
	
//	printf("timeout:%d\n",timeout);

	server[0]=0;
	path[0]=0;

	sscanf(url,"http://%s",headers);
	i=index(headers,'/');
	*i=32;
	sscanf(headers,"%s%s",server,path);
	sprintf(headers,"GET /%s HTTP/1.0\r\n\r\n",path);

	if((hp = gethostbyname(server)) == NULL)
			return NULL;
	else
	{
		bzero(&sin, sizeof(sin));
    memcpy((char *) &sin.sin_addr, hp->h_addr, sizeof(struct in_addr));
		sin.sin_family = AF_INET;
    sin.sin_port = (unsigned short) htons( 80 );		
	};

	if((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0)
			return NULL;
	if(connect(sock, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) < 0)
			return NULL;

	FD_ZERO(&fds_write);
	FD_SET(sock, &fds_write);
	tv.tv_sec = 5; // 5 sec timeout
	tv.tv_usec = 0;

	if(select(sock+1, NULL, &fds_write, NULL, &tv) < 1) {
			close(sock);
			return NULL;
	};

	write(sock, headers, strlen(headers)),strlen(headers);

	FD_ZERO(&fds_read);
	FD_SET(sock, &fds_read);
	tv.tv_sec = timeout; // 5 sec timeout
	tv.tv_usec = 0;

	if(select(sock+1, &fds_read, NULL, NULL, &tv) < 1) {
			shutdown(sock,2);
			close(sock);
			fprintf(stderr,"timeout waiting for server\n");
			return NULL;
	};

//	printf("[1]\n");

	ret=(char *)malloc(sizeof(char) * FETCH_CHUNK);
	if (ret==NULL)
	{
		fprintf(stderr, "No memory. Killing kswapd\n"); //linux
		return NULL;
	}

//	printf("[2]\n");

	memset(ret,0,FETCH_CHUNK);
	tb=0;
	p=0;
	
	do
	{
		FD_ZERO(&fds_read);
		FD_SET(sock, &fds_read);
		tv.tv_sec = timeout; // 5 sec timeout
		tv.tv_usec = 0;

		if(select(sock+1, &fds_read, NULL, NULL, &tv) < 1) {
				shutdown(sock,2);
				close(sock);
				fprintf(stderr, "timeout waiting to read\n");
				return ret;
		};

		rb = read(sock, buffer, FETCH_CHUNK-1);
		tb+=rb;
		if (tb > 0)
		{
			ret=(char *)realloc(ret,sizeof(char) * tb);
			if (ret==NULL)	
			{
				// out of memory
				fprintf(stderr, "No memory. Killing kswapd\n"); //linux
				return NULL;
			};
			memcpy((char *)(&ret[p]), (char *)buffer, rb);
		};
		p=tb;
	} while (rb>0);

	shutdown(sock,2);
	close(sock);

	*buflen=tb;
	
	if ((tb > 0) & (ret !=NULL))
	{
		return ret;
	}
	else
	{
		return NULL;
	};
		
};



// this picks a DCNV server to query at random.
int	randchar()
{
	// a.dcnv.com
	// o.dcnv.com
	// s.dcnv.com
	// t.dcnv.com
	// u.dcnv.com

	struct 	timeval tv;
	int		ret;
	int		hn[5];

	hn[0] = 'a';
	hn[1] = 'o';
	hn[2] = 's';
	hn[3] = 't';
	hn[4] = 'u';

	gettimeofday(&tv,NULL);

	ret = tv.tv_sec;

	ret =  hn[(ret%5)];
	
	return ret;
};

// may cause vague legal-type warning letters if used
struct cueinfo *dcnv_request(char *actcode, struct chunks *cnk)
{
	char 	*ret, *buf;
	int 	c,i,j,k,l;
	char	tmp;
	struct cueinfo *rv=NULL;


	c=0;

	if ( cnk == NULL )
	{
		return NULL;
	}
	else 
	{
		if (cnk->data != NULL)
		{
//			if (strcmp(cnk->ctype,"CC!") != 0)
//			{
//				return NULL;
//			};
			
			if (cnk->formatted == NULL)
			{
				decode_type(cnk);
			};

			rv=new_cueinfo();

			if (rv == NULL)
			{
				return NULL;
			};

			j=strlen(cnk->scandata);
			k=strlen(actcode);
			l=j+k+15; // padding
			ret=(char *)malloc(sizeof(char) * l);
			buf=(char *)malloc((sizeof(char) * l) + 50);
			memset(ret,0,sizeof(char) * l);
			c=0;
			ret[c]='1';
			c++;
			ret[c]='.';
			c++;
			ret[c]='.';
			c++;
			for (i=0; i<k; i++)
			{
				ret[c]=actcode[i];
				c++;
			};
			ret[c]='.';
			c++;
			ret[c]='0';
			c++;
			ret[c]='4';
			c++;
			for (i=0; i<j; i++)
			{
				tmp=cnk->scandata[i];
				if (tmp>=65 & tmp<=90)
				{
					tmp=tmp+32;
				}
				else if (tmp>=97 & tmp<=122)
				{
					tmp=tmp-32;
				};
				ret[c]=tmp;
				c++;
			};
			ret[c]='0';
			sprintf(buf,"http://%c.dcnv.com/CRQ/%s",randchar(),ret);
			deallocmem(ret);
			rv->cuereq=buf;
			return rv;
		}; // cnk->cuereq !=NULL
	}; // cnk != NULL
	
	return NULL;
};



/*
// warning: use of this function may cause frivolous
// legalistic letters
// also, struct chunks no longer contains cue members
*/
struct 		cueinfo *docue(struct chunks *c, char * actcode, int timeout)
{
	struct 		cueinfo	*s = NULL;
	char							*ret=NULL, *ret2=NULL;
	char							*cue,*url,*desc=NULL;
	int								buflen, i;
	

	if (c != NULL)
	{
		if (actcode != NULL)
		{
			s=dcnv_request(actcode,c); //fix
		}
		else
		{
			s=dcnv_request("ACTIVATIONCODE",c); //fix
		};
	};

	// don't actually touch their servers, see legal threat from DCNV
//	return s;

	if (s !=NULL)
	{
		cue=fetch(s->cuereq,&buflen,timeout);

		if (cue != NULL)
		{
			if(strstr(cue,"c-me-register"))
			{
				deallocmem(cue);
				cue=NULL;
			};
		}
		else
		{
			printf("no cue\n");
		};

		if (cue != NULL)
		{
			url=strstr(cue,"url=");
			if (url != NULL)
			{
				url=strstr(url,"http");
				for(i=0; i<strlen(url); i++)
				{
					if ((url[i]==10) | (url[i]==13))
					{
						url[i]=0;
						if (desc==NULL)
						{
							desc=(&url[i+1]);
						};
					};
				};
				ret=(char *)malloc(sizeof(char)*strlen(url));
				strcpy(ret,url);
				s->cueurl=ret;
				
				url=strstr(desc,"desc=");
				if (url != NULL)
				{
					for(i=0; i<strlen(url); i++)
					{
						if ((url[i]==10) | (url[i]==13))
						{
							url[i]=0;
						};
					};
					url=(&url[5]);
//					printf("U:%d\n",strlen(url));
					if (strlen(url)>0)
					{
						ret2=(char *)malloc(sizeof(char)*strlen(url));
						if (ret2 != NULL)
						{
							strcpy(ret2,url);
						}
						else
						{
							ret2=NULL;
							strcpy(url,"");
						};
					}
					else
					{
						ret2=NULL;
						strcpy(url,"");
					};
					if (cue !=NULL)
					{
						deallocmem(cue);
					};
					s->cuedesc=ret2;
					return s;
				}
				return NULL;
			}
			else
			{
				return NULL;
			};
		}
		else
		{
			return NULL;
		}; // cue !=NULL
	}; // s != NULL
	return NULL;
}

struct bookinfo *doamazon_isbn(char *isbn, int timeout)
{
	struct chunks *c;
	struct bookinfo *ret;
	
	c=(struct chunks *)malloc(sizeof(struct chunks));
	if (c!=NULL)
	{
		c->formatted=isbn;
		ret=doamazon(c, timeout);
		deallocmem(c);
		return ret;
	}
	else
	{
		return NULL;
	};
};


struct bookinfo *doamazon(struct chunks *c, int timeout)
{
	// http://www.amazon.com/exec/obidos/ASIN/0345333926
	char							*ama=NULL,
										*p1=NULL,
										*p2=NULL,
										*p3=NULL,
										*p4=NULL;
	int								i, 
										bl=0;
	char							title[2048],
										url[2048],
										author[2048],
										image[2048];
	struct bookinfo 	*ret;

	if (c == NULL)
	{
		return NULL;
	}
	else
	{
		if (c->formatted == NULL)
		{
			decode_type(c);
		};
		if ((c->formatted == NULL) && ((strcmp(c->ctype,"IB5")==0) || (strcmp(c->ctype,"IBN")==0)))
		{
			return NULL;
		}
		else
		{
			sprintf(url,"http://www.amazon.com/exec/obidos/ASIN/%s",c->formatted);
//			printf("url:[%s]\n",url);
			ama=fetch(url,&bl,timeout);
			if (ama == NULL)
			{
				return NULL;
			}
			else
			{
				p1=strstr(ama,"ocation: ");
				if (p1 != NULL)
				{
					p2=index(p1,10);
					if (p2 != NULL)
					{
						*p2=0;
					};
					p2=index(p1,13);
					if (p2 != NULL)
					{
						*p2=0;
					};
					p1=(&p1[9]);
//					sprintf(url,"%s",p1);
					strncpy(url,p1,500);
					url[500]=0;
					deallocmem(ama);
					ama=fetch(url,&bl,timeout);
				}

				// taken care of redirect, process page
				if (ama == NULL)
				{
					return NULL;
				}
				else
				{

					p1=strstr(ama, "buying info: ");
					p3=p1;
					if (p1 != NULL)
					{
						p1=(&p1[13]);
						p2=strstr(p1,"<");
						if (p2 != NULL)
						{
							*p2=0;
							p3=(&p2[1]);
							strncpy(title,p1,2047);
							title[2047]=0;
							p1=p3;
						};

						p1=strstr(p3,"/exec/obidos/Author=");
						p3=p1;
						if (p1 != NULL)
						{
							p2=strstr(p1,">");
							if (p2 != NULL)
							{
								p1=(&p2[1]);
							};
							p2=strstr(p1,"<");
							if (p2 != NULL)
							{
								*p2=0;
								strncpy(author,p1,2047);
								author[2047]=0;
								p3=(&p2[1]);
								p1=p3;
							};
						}
						else
						{
							author[0]=0;
						};

						if (p1 != NULL)
						{
							p2=strstr(p1,"See larger photo");
							if (p2 != NULL)
							{
								*p2=0;
								p4=NULL;

								do
								{
									p2=strstr(p1,"http://");
									if (p2==NULL)
									{
										break;
									};
									p4=p2;
									p1=(&p2[1]);
								} 
								while (p2 !=NULL );
								
								if (p4 !=NULL)
								{
									p1=p4;
									p2=strstr(p1,"\">");
									if (p2 != NULL)
									{
										*p2=0;
										strncpy(image,p1,2047);
										image[2047]=0;
									};
								}
								else
								{
									// no image
								};
							} // p1 != NULL
							else
							{
								image[0]=0;
							};
						};

						ret=new_bookinfo();

//						printf("A:%s\n%s\n%s\n%s\n",url,title,author,image);
						
						if (strlen(url)>0)
						{
							p1=(char *)malloc(2+(sizeof(char)*strlen(url)));
							memset(p1,0,2+(sizeof(char)*strlen(url)));
							strcpy(p1,url);
							ret->url=p1;
						};
						if (strlen(title)>0)
						{
							p1=(char *)malloc(2+(sizeof(char)*strlen(title)));
							memset(p1,0,2+(sizeof(char)*strlen(title)));
							strcpy(p1,title);
							ret->title=p1;
						};
						if (strlen(author)>0)
						{
							p1=(char *)malloc(2+(sizeof(char)*strlen(author)));
							memset(p1,0,2+(sizeof(char)*strlen(author)));
							strcpy(p1,author);
							ret->author=p1;
						};
						if (strlen(image)>0)
						{
							p1=(char *)malloc(2+(sizeof(char)*strlen(image)));
							memset(p1,0,2+(sizeof(char)*strlen(image)));
							strcpy(p1,image);
							ret->image=p1;
						};

					}
					else
					{
						ret=NULL;
					}; // if p1 != NULL
					if (ama != NULL)
					{
						deallocmem(ama);
					};
					return ret;
				};
			};
		};
	};
};


struct cueinfo *new_cueinfo()
{
	struct cueinfo *ret;
	ret=(struct cueinfo *)malloc(sizeof(struct cueinfo));
	if (ret != NULL)
	{
		ret->cuereq=NULL;
		ret->cueurl=NULL;
		ret->cuedesc=NULL;
		return ret;
	} 
	else
	{
		return NULL;
	};
};


struct bookinfo *new_bookinfo()
{
	struct bookinfo *ret;
	ret=(struct bookinfo *)malloc(sizeof(struct bookinfo));
	if (ret != NULL)
	{
		ret->url=NULL;
		ret->title=NULL;
		ret->author=NULL;
		ret->image=NULL;
		return ret;
	} 
	else
	{
		return NULL;
	};
};

void free_cueinfo(struct cueinfo *c)
{
	if (c!=NULL)
	{
		deallocmem(c->cueurl);
		deallocmem(c->cuereq);
		deallocmem(c->cuedesc);
		deallocmem(c);
	};
};


void free_bookinfo(struct bookinfo *c)
{
	if (c!=NULL)
	{
		deallocmem(c->url);
		deallocmem(c->title);
		deallocmem(c->author);
		deallocmem(c->image);
		deallocmem(c);
	};
};


struct bookinfo *dobn(struct chunks *c, int timeout)
{
	// not yet operational
	// video:
	// http://search.borders.com/fcgi-bin/db2www/search/search.d2w/Details?code=043396434592&mediaType=Video&searchType=ISBNUPC&prodID=&srchPage=Details
	// cd:
	// http://search.borders.com/fcgi-bin/db2www/search/search.d2w/Details?code=720642470626&mediaType=Music&searchType=ISBNUPC&prodID=
	// book:
	// http://shop.barnesandnoble.com/booksearch/isbnInquiry.asp?isbn=0345333926
	char							*ama=NULL,
										*p1=NULL,
										*p2=NULL,
										*p3=NULL,
										*p4=NULL;
	int								i,
										bl=0;
	char							title[2048],
										url[2048],
										author[2048],
										image[2048];
	struct bookinfo 	*ret;

	if (c == NULL)
	{
		return NULL;
	}
	else
	{
			sprintf(url,"http://search.borders.com/fcgi-bin/db2www/search/search.d2w/Details?code=%s&mediaType=Music&searchType=ISBNUPC&prodID=",c->data);
			ama=fetch(url,&bl,timeout);
			if (ama == NULL)
			{
				return NULL;
			}
			else
			{
				p1=strstr(ama,"ocation: ");
				if (p1 != NULL)
				{
					p2=index(p1,10);
					if (p2 != NULL)
					{
						*p2=0;
					};
					p2=index(p1,13);
					if (p2 != NULL)
					{
						*p2=0;
					};
					p1=(&p1[9]);
					strncpy(url,p1,500);
					url[500]=0;
					deallocmem(ama);
					ama=fetch(url,&bl,timeout);
				};

				if (strstr(ama,"found no matches"))
				{
					sprintf(url,"http://search.borders.com/fcgi-bin/db2www/search/search.d2w/Details?code=%s&mediaType=Video&searchType=ISBNUPC&prodID=",c->data);
					ama=fetch(url,&bl,timeout);
					if (ama == NULL)
					{
						return NULL;
					}
					else
					{
						p1=strstr(ama,"ocation: ");
						if (p1 != NULL)
						{
							p2=index(p1,10);
							if (p2 != NULL)
							{
								*p2=0;
							};
							p2=index(p1,13);
							if (p2 != NULL)
							{
								*p2=0;
							};
							p1=(&p1[9]);
							strncpy(url,p1,500);
							url[500]=0;
							deallocmem(ama);
							ama=fetch(url,&bl,timeout);
						};
					};
				}; //				if (strstr(ama,"found no matches")


				// taken care of redirect, process page
				if (ama == NULL)
				{
					return NULL;
				}
				else
				{

					p1=strstr(ama, "<title>");
					p3=p1;
					if (p1 != NULL)
					{
						p1=(&p1[21]);
						p2=strstr(p1,"</title");
						if (p2 != NULL)
						{
							*p2=0;
							p3=(&p2[1]);
							strncpy(title,p1,2047);
							title[2047]=0;
							p1=p3;
						}
						else
						{
							title[0]=0;
						};

						p1=strstr(p3,"/web_images/products/");
						p3=p1;
						if (p1 != NULL)
						{
							p2=strstr(p1,"\"");
							if (p2 != NULL)
							{
								*p2=0;
								p3=(&p2[1]);
								strcpy(image,"http://www.borders.com");
								strncat(image,p1,2000);
								image[2047]=0;
							}
							else
							{
								image[0]=0;
							};
						}
						else
						{
							image[0]=0;
						};
			
						if (p3 != NULL)
						{
							p1=strstr(p3,"Performer:");
						}
						else
						{
							p1=NULL;
						};
						p3=p1;
						if (p1 != NULL)
						{
							p1=strstr(p3,"> ");
							p1=(&p1[2]);
							p2=strstr(p1," &nbsp;");
							if (p2 != NULL)
							{
								*p2=0;
								p3=1;
								strncpy(author,p1,2047);
								author[2047]=0;
							}
							else
							{
								author[0]=0;
							};
						}
						else
						{
							author[0]=0;
						};
						
						

						ret=new_bookinfo();

//						printf("B:%s\n%s\n%s\n%s\n",url,title,author,image);
						
						if (strlen(url)>0)
						{
							p1=(char *)malloc(2+(sizeof(char)*strlen(url)));
							memset(p1,0,2+(sizeof(char)*strlen(url)));
							strcpy(p1,url);
							ret->url=p1;
						};
						if (strlen(title)>0)
						{
							p1=(char *)malloc(2+(sizeof(char)*strlen(title)));
							memset(p1,0,2+(sizeof(char)*strlen(title)));
							strcpy(p1,title);
							ret->title=p1;
						};
						if (strlen(author)>0)
						{
							p1=(char *)malloc(2+(sizeof(char)*strlen(author)));
							memset(p1,0,2+(sizeof(char)*strlen(author)));
							strcpy(p1,author);
							ret->author=p1;
						};
						if (strlen(image)>0)
						{
							p1=(char *)malloc(2+(sizeof(char)*strlen(image)));
							memset(p1,0,2+(sizeof(char)*strlen(image)));
							strcpy(p1,image);
							ret->image=p1;
						};

					}
					else
					{
						ret=NULL;
					}; // if p1 != NULL
					if (ama != NULL)
					{
						deallocmem(ama);
					};
					return ret;
				};
			};
		};
};


