#!/usr/local/bin/perl -s
#
# histogram summary of nstat logs (file or stdin)
#
# nsum [- M | A | D | E | N ] [- w | W ] [ filename ... ]
#        M = morning (8am-11am)
#        A = afternoon (noon - 5pm)
#        D = day  (morning | afternoon)
#        E = evening (6pm - 11pm)
#        N = night (midnignt - 7am)
#
#        w = workday
#        W = weekend
#

# tailor this for your site: our fractional T1 has 384 Kbits/sec:
$BANDWIDTH=((384*1024)/8);

# N-Night, M-Morning, D-Day, A-Afternoon, E-Evening
for (0..7){$HOURCLASS[$_]="N";}
for (8..11){$HOURCLASS[$_]="MD";}
for (12..17){$HOURCLASS[$_]="AD";}
for (18..23){$HOURCLASS[$_]="E";}

$DAYCLASS{"Mon"}="work";
$DAYCLASS{"Tue"}="work";
$DAYCLASS{"Wed"}="work";
$DAYCLASS{"Thu"}="work";
$DAYCLASS{"Fri"}="work";
$DAYCLASS{"Sat"}="wend";
$DAYCLASS{"Sun"}="wend";

sub sortsub {
    $AR{$b} <=> $AR{$a};
}

$reportcount=0;
    
$record=1;

while(<>){
    chop;
    ($proto, $port, $x, $count, $y, $bytes) = split;
    if(/^#Start/){
       ($x, $dow, $mon, $dom, $tod, $year) = split;
       ($hour, $min, $sec) = split(/:/,$tod);
       $record = 1;
       $record = 0 if($W && $DAYCLASS{$dow} ne "wend");
       $record = 0 if($w && $DAYCLASS{$dow} ne "work");
       $record = 0 if($N && $HOURCLASS[$hour] !~ /N/);
       $record = 0 if($M && $HOURCLASS[$hour] !~ /M/);
       $record = 0 if($D && $HOURCLASS[$hour] !~ /D/);
       $record = 0 if($A && $HOURCLASS[$hour] !~ /A/);
       $record = 0 if($E && $HOURCLASS[$hour] !~ /E/);
       $reportcount++ if($record);
    }
    if(/^#Stop/){
       ($x, $dow, $mon, $dom, $tod, $year) = split;
    }
    if($record == 1){
	if($proto eq "t"){
	    $TCP{$port} += $bytes;
	    $TCPtotal += $bytes;
	}
	elsif($proto eq "u"){
	    $UDP{$port} += $bytes;
	    $UDPtotal += $bytes;
	}
	elsif($proto eq "i"){
	    $IP{$port} += $bytes;
	    $IPtotal += $bytes;
	}
	elsif($proto eq "e"){
	    if(hex($port) < 1514){
		$ETHER{"0"} += $bytes;
	    }
	    else {
		$ETHER{hex($port)} += $bytes;
	    }
	    $ETHERtotal += $bytes;
	}
    }
}

if($reportcount){
    printf("Utilization: %5.2f%%\n\n", 
	   (($ETHERtotal/36.00)/$BANDWIDTH)/$reportcount);
}
$TCPtotal /= 120.00;
$UDPtotal /= 120.00;
$IPtotal /= 60.00;
$ETHERtotal /= 60.00;

for (keys %TCP){
    $TCPpercent{$_} = $TCP{$_}/$TCPtotal if($TCP{$_} >= $TCPtotal);
}

for (keys %UDP){
    $UDPpercent{$_} = $UDP{$_}/$UDPtotal if($UDP{$_} >= $UDPtotal);
}

$IPlow = $IPtotal/10;

for (keys %IP){
    $IPpercent{$_} = $IP{$_}/$IPtotal if($IP{$_} >= $IPlow);
}

$ETHERlow = $ETHERtotal/10;

for (keys %ETHER){
    $ETHERpercent{$_} = $ETHER{$_}/$ETHERtotal if($ETHER{$_} >= $ETHERlow);
}

*AR=ETHERpercent;
$ethtype{"0"}="802.3";
$ethtype{hex("0800")}="IP";
$ethtype{hex("0BAD")}="Banyan";
$ethtype{hex("6002")}="DECRCONS";
$ethtype{hex("6003")}="DECIVDNA";
$ethtype{hex("6004")}="DECLAT";
$ethtype{hex("6007")}="DECLAVC";
$ethtype{hex("8037")}="IPX";
$ethtype{hex("8038")}="DECLBM"; #/* DEC LAN Bridge Mgt */
$ethtype{hex("8137")}="oldIPX";

$count=0;
for (sort(sortsub keys %ETHERpercent)){
    $iperc = int($ETHERpercent{$_} + 0.5);
    if(defined($ethtype{$_})){
	$name=$ethtype{$_};
    }
    else {
	$name=sprintf("%04X", $_);
    }
    printf("ETH %-8s  (%2.0f%%/%2.0f%%):%s\n",
	   $name,
	   $ETHERpercent{$_},
	   (($ETHER{$_}/36.00)/$BANDWIDTH)/$reportcount,
	   '#' x $iperc);
    last if(++$count >= 10);
}

print "\n";

*AR=IPpercent;

$IPproto{1}="ICMP";
$IPproto{6}="TCP";
$IPproto{9}="IGP";
$IPproto{17}="UDP";

$count=0;
for (sort(sortsub keys %IPpercent)){
    $iperc = int($IPpercent{$_} + 0.5);
    $name=$_;
    $name=$IPproto{$_} if(defined($IPproto{$_}));
    printf("IP  %-8s (%2.0f%%/%2.0f%%):%s\n",
	   $name,
	   $IPpercent{$_},
	   $IP{$_}/$ETHERtotal,
	   '#' x $iperc);
    last if(++$count >= 10);
}

print "\n";

*AR=TCPpercent;

$count=0;
for (sort(sortsub keys %TCPpercent)){
    $iperc = int($TCPpercent{$_} + 0.5);
    @se = getservbyport($_, "tcp");
    $name = $_;
    $name = $se[0] if($#se != -1);
    printf("TCP %-8s (%2.0f%%/%2.0f%%):%s\n",
	   $name,
	   $TCPpercent{$_},
	   $TCP{$_}/$ETHERtotal,
	   '#' x $iperc);
    last if(++$count >= 10);
}

print "\n";

*AR=UDPpercent;

$count=0;
for (sort(sortsub keys %UDPpercent)){
    $iperc = int($UDPpercent{$_} + 0.5);
    @se = getservbyport($_, "udp");
    $name = $_;
    $name = $se[0] if($#se != -1);
    printf("UDP %-8s (%2.0f%%/%2.0f%%):%s\n",
	   $name,
	   $UDPpercent{$_},
	   $UDP{$_}/$ETHERtotal,
	   '#' x $iperc);
    last if(++$count >= 10);
}

print "\n";
