/****************************************************************************\
**    Killer Cracker v9.11 LTD - Un*x /etc/passwd 'FAST' cracking engine    **
** ======================================================================== **
**                 Sourcefile: kc.c -- Last Update: 10/07/91                **
** ======================================================================== **
**           Written By Doctor Dissector, Copyright (C) 1990, 1991          **
** ======================================================================== **
**                   LIMITED EDITION -- DO NOT DISTRIBUTE                   **
\****************************************************************************/

/*=[ License ]==============================================================*/

/*
**  Killer Cracker - Version 9.11 LTD
**  Copyright (C) 1991 By Doctor Dissector
**
**  This program is NOT free software BUT may be used without charge or
**  payment in any form IF your copy is a "registered" distributed version.
**  You may modify it as much as you please, however, you MAY NOT re-
**  distribute it, in any shape or for: ie. modified OR unmodified,
**  without the expressed written consent (ie. e-mail) of
**  Doctor Dissector.
**
**  This program was initially distributed in the hope that it will be
**  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/*=[ Disclaimer ]===========================================================*/

/*
**  The author of this package, Doctor Dissector, will not assume liability
**  for ANY of the effects of the use or distribution of this package.  If
**  you, at ANY time compile or use this package, you will assume full
**  liability for your own actions; Doctor Dissector can neither enforce the
**  lawful use of this package nor your actions before, during, or after
**  exposure to this package.  Doctor Dissector does NOT endorse your unlawful
**  use of this package to appropriate computer accounts not under your lawful
**  ownership.
**
**  The original intent of this package was to prove that Un*x accounts can be
**  easily, efficiently, and effectively cracked utilizing modified DES
**  encryption routines and proper statistical, mathematical, logical, and
**  programming skills.
*/

/*=[ Copyright ]============================================================*/

char kc_c_msg[] = "Source: kc.c, Copyright (c)1991 Doctor Dissector";

/*=[ Include: kc.h Header ]=================================================*/

#include "kc.h"

/*=[ Variable: _stklen ]====================================================*/

#ifdef _TURBO
unsigned _stklen = 8192;                /* 8k stack, Turbo/Borland C/C++ */
#endif

/*=[ Include Header Files ]=================================================*/

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <errno.h>

#ifndef _STRIPPED
#include <signal.h>
#else
#include <stdlib.h>
#endif

#ifdef _MSDOS
#include <sys\types.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#endif

#ifdef _TURBO
#include <alloc.h>
#endif

#ifdef _MICROSOFT
#include <malloc.h>
#endif

#ifdef _BSD
#include <sys/resource.h>
#endif

/*=[ Include: bcrypt.c Encryption Routines ]================================*/

#include "bcrypt.c"

/*=[ Structure: acc_struct ]================================================*/

struct acc_list {
    char            *login,             /* Login field of /etc/passwd */
                    *epw,               /* Password field of /etc/passwd */
                    *gecos,             /* GECOS field of /etc/passwd */
                    *home,              /* Home dir field of /etc/passwd */
                    *shell;             /* Shell field of /etc/passwd */

    unsigned        uid,                /* UID field of /etc/passwd */
                    gid;                /* GID field of /etc/passwd */

    struct acc_list *next,              /* Pointer to next struct */
                    *prev;              /* Pointer to previous struct */

    U32             SL[2];              /* salt "mask" of this account */
    BU64            encode;             /* 64 bits from "decryption" */
};

/*=[ Global Variables ]=====================================================*/

char            progname[MAX_FILE];     /* KC's current executable name */

int             cracked,                /* Amount of accounts cracked */
                fork_process,           /* Fork process into background? */
                inactive,               /* Write inactive accounts? */
                lastuser,               /* Sequential user # */
                maximize,               /* Maximize resource usage? */
                quiet,                  /* Quiet mode, no stdout output? */
                restoring,              /* Restoring a session? */
                stdin_words,            /* Read words from stdin? */
                single,                 /* Single-crack mode? */
                num_accs;               /* Total number of accounts */

unsigned long   timeout,                /* Timeout (minutes) */
                combinations;           /* Total encryption/comparisions */

char            lastword[MAX_WORD],     /* Last word read from wordfile */
                pwfile[MAX_FILE],       /* PWfile filename */
                restorefile[MAX_FILE],  /* Restorefile filename */
                validfile[MAX_FILE],    /* Validfile filename */
                wordfile[MAX_FILE];     /* Wordfile filename */

FILE            *vf,                    /* Valid account file stream */
                *gf;                    /* Word guess file stream */

time_t          timer;                  /* Performance timing variable */

/*==========================================================================*/

/*
**     function: void print_title(void)
**  description: displays the title of this program
**      returns: nothing
*/

void print_title()
{
    printf("\n");
    printf("Killer Cracker, Version 9.11 LTD (10/7/91)\n");
    printf("Copyright (C) 1991, By Doctor Dissector\n");
    printf("*** DO NOT DISTRIBUTE THIS VERSION ***\n\n");
}

/*==========================================================================*/

/*
**     function: void print_usage(void)
**  description: displays program usage & options
**      returns: nothing
*/

void print_usage()
{
    printf("Brief:  Unix /etc/passwd 'FAST' password cracking engine.\n\n");
    printf("Usage:  %s [[flag] ...] [-stdin < [wordfile]]\n\n", progname);
    printf("Flags:  -?                  display this usage menu\n");

#ifdef _UNIX
    printf("        -Fork               fork session process into the background\n");
#endif

    printf("        -Help               display this usage menu\n");
    printf("        -Inactive           display and write inactive accounts\n");

#ifdef _BSD
    printf("        -Maximize           maximize use of system resources\n");
#endif

    printf("        -Pwfile:<file>      set passwordfile to <file>\n");
    printf("        -Quiet              suppress all output from stdout\n");
    printf("        -Restore:<file>     restore session using <file> as restorefile\n");
    printf("        -SIngle             read wordfile in 'single-crack' format\n");
    printf("        -STdin              read words from stdin instead of 'wordfile'\n");
    printf("        -TEst               test crypt result for proper encryption\n");
    printf("        -TImeout:<time>     abort session after a period of <time> minutes\n");
    printf("        -Validfile:<file>   set validfile to <file>\n");
    printf("        -Wordfile:<file>    set wordfile to <file>\n\n");
}

/*==========================================================================*/

/*
**     function: void print_files(void)
**  description: displays settings for pwfile, wordfile, and validfile
**      returns: nothing
*/

void print_files()
{
    if ((!pwfile[0]) && (!restoring)) {
        printf("PWfile    : ");
        gets(pwfile);
    }
    else
        printf("PWfile    : %s\n", pwfile);
    if (((!wordfile[0]) && (!stdin_words)) && (!restoring)) {
        printf("Wordfile  : ");
        gets(wordfile);
    }
    else
        printf("Wordfile  : %s\n", (stdin_words ? "stdin" : wordfile));
    if (!validfile[0]) {
        printf("Validfile : ");
        gets(validfile);
        printf("\n");
    }
    else
        printf("Validfile : %s\n\n", validfile);
}

/*==========================================================================*/

/*
**     function: void print_stat(void)
**  description: displays various settings/flags
**      returns: nothing
*/

void print_stat()
{
    int ok=0;

    if (single) {
        printf("->  Single-crack mode\n");
        ok=1;
    }
    if (inactive) {
        printf("->  Write inactive accounts\n");
        ok=1;
    }
    if (maximize) {
        printf("->  Maximize use of system resources\n");
        ok=1;
    }
    if (timeout) {
        printf("->  Session timeout: %ld minutes\n", timeout);
        ok=1;
    }
    if (ok)
        printf("\n");
}

/*==========================================================================*/

/*
**     function: void init_vars(void)
**  description: pre-initialize global variables
**      returns: nothing
*/

void init_vars()
{
    vf=NULL;
    gf=NULL;
    timer=0;
    cracked=0;
    combinations=0;
    fork_process=0;
    inactive=0;
    lastuser=0;
    maximize=0;
    quiet=0;
    restoring=0;
    stdin_words=0;
    single=0;
    timeout=0;
    lastword[0]=0;
    pwfile[0]=0;
    restorefile[0]=0;
    validfile[0]=0;
    wordfile[0]=0;
}

/*==========================================================================*/

/*
**     function: void kc_exit(int exitcode, char *desc1, char *desc2)
**  description: displays an exit/error message and exits with an exit
**               code of <exitcode>
**      returns: nothing
*/

void kc_exit(exitcode, desc1, desc2)
    register int  exitcode;
    const    char *desc1, *desc2;
{
    if (!((quiet) && (!exitcode))) {
        fprintf(stderr, "\n%s: ", progname);
        if (desc1)
            fprintf(stderr, "%s", desc1);
        else
            fprintf(stderr, "abnormal program termination");
        if (desc2)
            fprintf(stderr, ": %s", desc2);
        fprintf(stderr, "\n\n");
    }
    exit(exitcode);
}

/*==========================================================================*/

/*
**     function: void show_string(char *str)
**  description: writes <str> to stdout
**      returns: nothing
*/

void show_string(str)
    char *str;
{
    write(1, str, strlen(str));
}

/*==========================================================================*/

/*
**     function: char *lowcase(char *str)
**  description: produces the lowercase equivalent of <str>
**      returns: lowercase equivalent of <str>
*/

char *lowcase(str)
    register char *str;
{
    register char *ptr;
    static   char s[MAX_TAIL];

    ptr=s;
    while(*str)
        (*ptr++)=(((*str)>='A') && ((*str)<='Z') ? (*str++)+32 : (*str++));
    *ptr=0;
    return(s);
}

/*===========================================================================*/

/*
**     function: int open_valid(void)
**  description: opens & prepares the [vf] file stream for writing
**      returns: 0 on success, -1 on error
*/

int open_valid()
{
    vf=fopen(validfile, "a");
    if (!vf)
        return(-1);
    fprintf(vf, "\n========================================");
    fprintf(vf, "\nPWfile   : %s ", pwfile);
    fprintf(vf, "\nWordfile : %s", (stdin_words ? "stdin" : wordfile));
    fprintf(vf, "\n----------------------------------------");
    fclose(vf);
    return(0);
}

/*===========================================================================*/

/*
**     function: int open_words(void)
**  description: opens & prepares the [gf] file stream for reading
**      returns: 0 on success, -1 on error
*/

int open_words()
{
    gf=fopen(wordfile, "r");
    return(!gf ? (-1) : 0);
}

/*===========================================================================*/

/*
**     function: void close_valid(time_t elapsed, int aborted)
**  description: prepares & closes the [vf] file stream
**      returns: nothing
*/

void close_valid(elapsed, aborted)
    time_t elapsed;
    int    aborted;
{
    double performance;

    if (elapsed<1)
        elapsed=1;
    vf=fopen(validfile, "a");
    if (!vf)
        kc_exit(1, "error opening validfile", validfile);
    if (aborted)
        if (single)
            fprintf(vf, "\n*** Session aborted, user #%d", lastuser);
         else
            fprintf(vf, "\n*** Session aborted, word: %s", lastword);
    fprintf(vf,"\n----------------------------------------");
    performance=(double)((double)combinations/(double)elapsed);
    fprintf(vf, "\nEncryption/Comparisions: %lu", combinations);
    fprintf(vf, "\nTime Elapsed In Seconds: %lu", elapsed);
    fprintf(vf, "\nMean Encryptions/Second: %.2f", performance);
    fprintf(vf, "\n=======================================");
    fclose(vf);
}

/*===========================================================================*/

/*
**     function: void close_all(time_t elapsed)
**  description: calls function [close_valid] and closes the [gf] file stream
**      returns: nothing
*/

void close_all(elapsed)
    time_t elapsed;
{
    close_valid(elapsed, 0);
    fclose(gf);
}

/*===========================================================================*/

/*
**     function: void found_valid(char *login, char *pw, unsigned uid,
**                  unsigned gid, char *gecos, char *home, char *shell)
**  description: writes "valid" account information to the [vf] file stream
**      returns: nothing
*/

void found_valid(login, pw, uid, gid, gecos, home, shell, ia)
    char     *login, *pw, *gecos, *home, *shell;
    unsigned uid, gid;
    int      ia;
{
    static char s[MAX_LINE];


    vf=fopen(validfile, "a");
    if (!vf)
        kc_exit(1, "error opening validfile", validfile);
    fprintf(vf, "\n%s:%s:%u:%u:%s:%s:%s", login, pw, uid,
        gid, gecos, home, shell);
    fclose(vf);
    if (!quiet) {
        if (ia)
            sprintf(s, "\b[%s]  ", login);
        else
            sprintf(s, "\b(%s)  ", login);
        show_string(s);
    }
}

/*==========================================================================*/

/*
**     function: void *kc_malloc(long size)
**  description: allocates memory, simplifies the use of "malloc" type
**               functions between different compilers
**      returns: pointer to a block of allocated memory, exits upon error
*/

void *kc_malloc(size)
    long size;
{
    void *buf;
    char s[21];

#if defined(_TURBO) || defined(_MICROSOFT)

#ifdef _TURBO
    buf=(void *)farmalloc(size);
#else
    buf=(void *)_fmalloc(size);
#endif

#else
    buf=(void *)malloc((size_t)size);
#endif

    if (!buf) {
        sprintf(s, "%ld bytes", size);
        kc_exit(1, "memory allocation error", s);
    }
    return(buf);
}

/*==========================================================================*/

/*
**     function: void kc_free(void *buf)
**  description: de-allocates memory, simplifies the use of "malloc" type
**               functions between different compilers
**      returns: nothing
*/

void kc_free(buf)
    void *buf;
{

#if defined(_TURBO) || defined(_MICROSOFT)

#ifdef _TURBO
    farfree(buf);
#else
    _ffree(buf);
#endif

#else
    free(buf);
#endif

}

/*==========================================================================*/

/*
**     function: void acc_free(struct acc_list *acc)
**  description: de-allocates memory from a member of the linked-list
**      returns: nothing
*/

void acc_free(acc)
    struct acc_list *acc;
{
    kc_free(acc->login);
    kc_free(acc->epw);
    kc_free(acc->gecos);
    kc_free(acc->home);
    kc_free(acc->shell);
    kc_free(acc);
}

/*==========================================================================*/

/*
**     function: struct acc_list *acc_remove(struct acc_list *root,
**                   struct acc_list *remove)
**  description: removes a member from a linked-list, and calls [acc_free]
**               to de-allocate it
**      returns: root of the new linked-list
*/

struct acc_list *acc_remove(root, remove)
    struct acc_list *root, *remove;
{
    if (root==remove) {
        root=remove->next;
        if(root)
            root->prev=NULL;
    }
    if (remove->next)
        remove->next->prev=remove->prev;
    if (remove->prev)
        remove->prev->next=remove->next;
    acc_free(remove);
    return(root);
}

/*==========================================================================*/

/*
**     function: struct acc_list *acc_create(char *login, char *epw,
**                  unsigned uid, unsigned gid, char *gecos, char *home,
**                  char *shell)
**  description: allocates and creates a member of the linked list
**      returns: created member
*/

struct acc_list *acc_create(login, epw, uid, gid, gecos, home, shell)
    char      *login, *epw, *gecos, *home, *shell;
    unsigned  uid, gid;
{
    struct acc_list *acc;

    acc=(struct acc_list *)kc_malloc((long)sizeof(struct acc_list));
    acc->login=(char *)kc_malloc((long)strlen(login)+1);
    strcpy(acc->login, login);
    acc->epw=(char *)kc_malloc((long)13+1);
    epw[13]=0;
    strcpy(acc->epw, epw);
    acc->uid=uid;
    acc->gid=gid;
    acc->gecos=(char *)kc_malloc((long)strlen(gecos)+1);
    strcpy(acc->gecos, gecos);
    acc->home=(char *)kc_malloc((long)strlen(home)+1);
    strcpy(acc->home, home);
    acc->shell=(char *)kc_malloc((long)strlen(shell)+1);
    strcpy(acc->shell, shell);
    bcrypt_salt_to_E(epw[0], epw[1], acc->SL);
    acc->encode=bcrypt_pw_to_BU64(epw+2);
    acc->next=NULL;
    acc->prev=NULL;
    return(acc);
}

/*==========================================================================*/

/*
**     function: struct acc_list *acc_read_one(char *line)
**  description: reads data from one line of the /etc/passwd file and passes
**               it to [acc_create] to create a new member of the linked-list
**      returns: created member
*/

struct acc_list *acc_read_one(line)
    char *line;
{
    int  i, ok=0;
    char *login, *epw, *uid, *gid, *gecos, *home, *sh;

    for(login=line; (*line!=':') && (*line); line++)
        ;
    if (*line) {
        *line=0;
        for(epw=++line; (*line!=':') && (*line); line++)
            ;
        if (*line) {
            *line=0;
            for(uid=++line; (*line!=':') && (*line); line++)
                ;
            if (*line) {
                *line=0;
                for(gid=++line; (*line!=':') && (*line); line++)
                    ;
                if (*line) {
                    *line=0;
                    for(gecos=++line; (*line!=':') && (*line); line++)
                        ;
                    if (*line) {
                        *line=0;
                        for(home=++line; (*line!=':') && (*line); line++)
                            ;
                        if (*line) {
                            *line=0;
                            for(sh=++line; (*line!=':') && (*line); line++)
                                ;
                            *line=0;
                            ok=1;
                        }
                    }
                }
            }
        }
    }
    if (ok)
        return(acc_create(login, epw, (unsigned)atoi(uid),
            (unsigned)atoi(gid), gecos, home, sh));
    return(NULL);
}

/*==========================================================================*/

/*
**     function: struct acc_list *acc_strip(struct acc_list *root)
**  description: strips inactive accounts and non-passworded accounts from
**               the linked list <root>
**      returns: result linked-list
*/

struct acc_list *acc_strip(root)
    struct acc_list *root;
{
    int               delete;
    struct acc_list *cur, *remove;

    for(cur=root; cur; ) {
        delete=1;
        if (!cur->epw[0]) {
            found_valid(cur->login, "\0", cur->uid, cur->gid,
                cur->gecos, cur->home, cur->shell, 0);
            cracked++;
        }
        else if ((cur->epw[0]=='*') || (strlen(cur->epw)!=13)) {
            if (inactive)
                found_valid(cur->login, "*INACTIVE*", cur->uid, cur->gid,
                    cur->gecos, cur->home, cur->shell, 1);
        }
        else if (cur->login[0]!='+') {
            delete=0;
            cur=cur->next;
        }
        if (delete) {
            remove=cur;
            cur=cur->next;
            root=acc_remove(root, remove);
        }
    }
    return(root);
}

/*==========================================================================*/

/*
**     function: struct acc_list *read_pwfile()
**  description: creates the full linked-list from an /etc/passwd file
**      returns: result linked-list
*/

struct acc_list *read_pwfile()
{
    char              line[MAX_LINE];
    FILE              *fp;
    struct acc_list *root, *new;

    root=NULL;
    fp=fopen(pwfile, "r");
    if (!fp)
        kc_exit(1, "error reading pwfile", pwfile);
    while(fgets(line, MAX_LINE-1, fp)) {
        if (line[strlen(line)-1]=='\n')
            line[strlen(line)-1]=0;
        if ((new=acc_read_one(line))!=NULL) {
            ++num_accs;
            if (root)
                root->prev=new;
            new->next=root;
            root=new;
        }
    }
    return(root);
}

/*==========================================================================*/

/*
**     function: int restore_nextword(char *word)
**  description: reads the next word from a wordlist, used in conjunction
**               with other restore functions
**      returns: 1 upon success, 0 on error; places the word in <word>
*/

int restore_nextword(word)
    char *word;
{
    if (((!stdin_words) && (fgets(word, MAX_WORD-1, gf))) ||
        ((stdin_words) && (fgets(word, MAX_WORD-1, stdin)))) {
        if (word[strlen(word)-1]=='\n')
            word[strlen(word)-1]=0;
        return(1);
    }
    return(0);
}

/*==========================================================================*/

/*
**     function: int nextword(void)
**  description: reads the next word from a wordlist and prepares it for
**               encryption routines
**      returns: 1 upon success, 0 on error; places the word in [lastword]
*/

int nextword()
{
    if (((!stdin_words) && (fgets(lastword, MAX_WORD-1, gf))) ||
        ((stdin_words) && (fgets(lastword, MAX_WORD-1, stdin)))) {
        if (lastword[strlen(lastword)-1]=='\n')
            lastword[strlen(lastword)-1]=0;
        lastword[8]=0;
        bcrypt_set_word(lastword);
        return(1);
    }
    return(0);
}

/*===========================================================================*/

/*
**     function: void save_options(int done)
**  description: saves the current options and place to the [restorefile]
**      returns: nothing
*/

void save_options(done)
    int done;
{
    FILE *rf;

    if (!restorefile[0])
        rf=fopen("restore", "w");
    else
        rf=fopen(restorefile, "w");
    if (!rf)
        kc_exit(1, "error opening restorefile", restorefile);
    fprintf(rf, "PWfile=%s\n", pwfile);
    fprintf(rf, "Wordfile=%s\n", wordfile);
    fprintf(rf, "Validfile=%s\n", validfile);

    if (fork_process)
        fprintf(rf, "Flag=fork\n");
    if (quiet)
        fprintf(rf, "Flag=quiet\n");
    if (stdin_words)
        fprintf(rf, "Flag=stdin\n");
    if (single)
        fprintf(rf, "Flag=single\n");

#ifdef _BSD
    if (maximize)
        fprintf(rf, "Flag=maximize\n");
#endif

    if (timeout)
        fprintf(rf, "Flag=timeout:%ld\n", timeout);
    if (single) {
        if (done)
            fprintf(rf, "Lastuser=-1\n");
        else
            fprintf(rf, "Lastuser=%d\n", lastuser);
    }
    else {
        if (done)
            fprintf(rf, "Lastword=*****DONE*****\n");
        else
            fprintf(rf, "Lastword=%s\n", lastword);
    }
    fclose(rf);
}

/*==========================================================================*/

/*
**     function: void/int handler(void)
**  description: handles all interrupt routines, aborts session
**      returns: nothing
*/

#ifndef _STRIPPED
#ifdef _UNIX
int handler()
#else
void handler()
#endif

{
    time_t temp;

#ifdef _UNIX
    signal(SIGQUIT, SIG_IGN);
    signal(SIGTERM, SIG_IGN);
    signal(SIGINT, SIG_IGN);
    signal(SIGALRM, SIG_IGN);
#endif

#ifdef _MSDOS
    signal(SIGINT, SIG_IGN);
#endif

    close_valid(time(&temp)-timer, 1);
    save_options(0);
    fclose(gf);
    kc_exit(0, "session aborted", NULL);

#ifdef _UNIX
    return(0);
#endif

}

/*==========================================================================*/

/*
**     function: void crk_s(struct acc_list *root)
**  description: cracks the given linked-list <root> against a wordfile in
**               single-crack format
**      returns: nothing
*/

void crk_s(root)
    register struct acc_list *root;
{
    register char            spin_index=0, to_remove=0;
    static   char            s[MAX_WORD],
                             *spin[4] = { "\b-","\b\\", "\b|", "\b/" };
    static   time_t          temp;
    register long            info_index=0;
    register BU64            ec;
    register struct acc_list *cur, *remove;

    lastuser=0;
    for(cur=root; (cur) && (lastword[0]); ) {
        lastuser++;
        sprintf(s, "\b \n%-12s  ", cur->login);
        show_string(s);
        do {
            if (!strcmp(lastword, "***!***")) {
                if (!nextword())
                    lastword[0]=0;
                break;
            }

#ifdef DEBUGGING
            show_string(lastword);
            show_string("/");
#endif

            ec=bcrypt_encode(cur->SL[0], cur->SL[1]);
            if (!((long)++combinations%30)) {
                show_string(spin[spin_index]);
                spin_index=(spin_index>2 ? 0 : spin_index+1);

#ifndef _UNIX
                if (timeout) {
                    if ((timeout*60L)<(time(&temp)-timer))
                        handler();
                }
#endif

            }
            if ((ec.L.U==cur->encode.L.U) && (ec.R.U==cur->encode.R.U)) {
                cracked++;
                found_valid(cur->login, lastword, cur->uid, cur->gid,
                    cur->gecos, cur->home, cur->shell, 0);
                remove=cur;
                to_remove=1;
                cur=cur->prev;
                root=acc_remove(root, remove);
                if (!root)
                    return;
                while(nextword()) {
                    if (!strcmp(lastword, "***!***")) {
                        if (!nextword())
                            lastword[0]=0;
                        break;
                    }
                }
                break;
            }
        } while(nextword());
        if (to_remove)
            to_remove=0;
        else
            cur=cur->prev;
        if (!(++info_index%10)) {
            temp=time(&temp)-timer;
            sprintf(s, "\b \n**Status**   [ c: %lu, v: %d, s: %lu, c/s: %.2f, v/u: %.3f ] ",
                (unsigned long)combinations,
                cracked,
                (unsigned long)temp,
                (double)combinations/(double)(temp+.001),
                (double)cracked/(double)info_index);
            show_string(s);
        }
    }
}

/*==========================================================================*/

/*
**     function: void crk(struct acc_list *root)
**  description: cracks the given linked-list <root> against a wordfile
**      returns: nothing
*/

void crk(root)
    register struct acc_list *root;
{
    register char            spin_index=0;
    static   char            s[MAX_WORD],
                             *spin[4] = { "\b-","\b\\", "\b|", "\b/" };
    static   time_t          temp;
    register long            info_index=0;
    register BU64            ec;
    register struct acc_list *cur, *remove;

    do {
        sprintf(s, "\b \n%-12s  ", lastword);
        show_string(s);
        for(cur=root; cur; ) {
            ec=bcrypt_encode(cur->SL[0], cur->SL[1]);
            if (!((long)++combinations%30)) {
                show_string(spin[spin_index]);
                spin_index=(spin_index>2 ? 0 : spin_index+1);

#ifndef _UNIX
                if (timeout) {
                    if ((timeout*60L)<(time(&temp)-timer))
                        handler();
                }
#endif

            }
            if ((ec.L.U==cur->encode.L.U) && (ec.R.U==cur->encode.R.U)) {
                cracked++;
                found_valid(cur->login, lastword, cur->uid, cur->gid,
                    cur->gecos, cur->home, cur->shell, 0);
                remove=cur;
                cur=cur->prev;
                root=acc_remove(root, remove);
                if (!root)
                    return;
            }
            else
                cur=cur->prev;
        }
        if (!(++info_index%10)) {
            temp=time(&temp)-timer;
            sprintf(s, "\b \n**Status**   [ c: %lu, v: %d, s: %lu, c/s: %.2f, v/w: %.3f ] ",
                (unsigned long)combinations,
                cracked,
                (unsigned long)temp,
                (double)combinations/(double)(temp+.001),
                (double)cracked/(double)info_index);
            show_string(s);
        }
    } while(nextword());
}

/*==========================================================================*/

/*
**     function: void crk_s_q(struct acc_list *root)
**  description: cracks the given linked-list <root> against a wordfile in
**               single-crack format (quiet mode)
**      returns: nothing
*/

void crk_s_q(root)
    register struct acc_list *root;
{
    register char            to_remove=0, i=0;
    register BU64            ec;
    register struct acc_list *cur, *remove;
    static   time_t          temp;

    lastuser=0;
    for(cur=root; (cur) && (lastword[0]); ) {
        lastuser++;
        do {
            if (!strcmp(lastword, "***!***")) {
                if (!nextword())
                    lastword[0]=0;
                break;
            }
            ec=bcrypt_encode(cur->SL[0], cur->SL[1]);
            combinations++;

#ifndef _UNIX
            if (timeout) {
                if (i++>=30) {
                    if ((timeout*60L)<(time(&temp)-timer))
                        handler();
                    i=0;
                }
            }
#endif

            if ((ec.L.U==cur->encode.L.U) && (ec.R.U==cur->encode.R.U)) {
                cracked++;
                found_valid(cur->login, lastword, cur->uid, cur->gid,
                    cur->gecos, cur->home, cur->shell, 0);
                remove=cur;
                to_remove=1;
                cur=cur->prev;
                root=acc_remove(root, remove);
                if (!root)
                    return;
                while(nextword()) {
                    if (!strcmp(lastword, "***!***")) {
                        if (!nextword())
                            lastword[0]=0;
                        break;
                    }
                }
                break;
            }
        } while(nextword());
        if (to_remove)
            to_remove=0;
        else
            cur=cur->prev;
    }
}

/*==========================================================================*/

/*
**     function: void crk_q(struct acc_list *root)
**  description: cracks the given linked-list <root> against a wordfile
**               (quiet mode)
**      returns: nothing
*/

void crk_q(root)
    register struct acc_list *root;
{
    register char            i=0;
    register BU64            ec;
    register struct acc_list *cur, *remove;
    static   time_t          temp;

    do {
        for(cur=root; cur; ) {
            ec=bcrypt_encode(cur->SL[0], cur->SL[1]);
            combinations++;

#ifndef _UNIX
            if (timeout) {
                if (i++>=30) {
                    if ((timeout*60L)<(time(&temp)-timer))
                        handler();
                    i=0;
                }
            }
#endif

            if ((ec.L.U==cur->encode.L.U) && (ec.R.U==cur->encode.R.U)) {
                cracked++;
                found_valid(cur->login, lastword, cur->uid, cur->gid,
                    cur->gecos, cur->home, cur->shell, 0);
                remove=cur;
                cur=cur->prev;
                root=acc_remove(root, remove);
                if (!root)
                    return;
            }
            else
                cur=cur->prev;
        }
    } while(nextword());
}

/*==========================================================================*/

/*
**     function: void test_crypt(void)
**  description: performs one crypt and compares the result against a
**               pre-computed value
**      returns: nothing
*/

#define ENCRYPTED_TEST_PASSWORD  "MX4WdnjbWMTKQ"
#define PLAINTEXT_TEST_PASSWORD  "robert"

void test_crypt()
{
    char   epw[21];
    U32    SL[2];
    BU64   epwcode, resultcode;

    print_title();
    printf("Testing encrypted password '%s' as '%s'...",
        ENCRYPTED_TEST_PASSWORD, PLAINTEXT_TEST_PASSWORD);
    strcpy(epw, ENCRYPTED_TEST_PASSWORD);
    bcrypt_init();
    bcrypt_salt_to_E(epw[0], epw[1], SL);
    epwcode=bcrypt_pw_to_BU64(epw+2);
    bcrypt_set_word(PLAINTEXT_TEST_PASSWORD);
    resultcode=bcrypt_encode(SL[0], SL[1]);

#if defined(_TURBO) || defined(_MICROSOFT)
    bcrypt_done();
#endif

    if ((epwcode.L.U==resultcode.L.U) && (epwcode.R.U==resultcode.R.U)) {
        printf("\n\nTest complete.  No errors detected.\n");
        exit(0);
    }
    else {
        printf("\n\nEncryption/compare error.  The encrypted plaintext password");
        printf("\ndid not match the encrypted password.\n");
        exit(1);
    }
}

/*==========================================================================*/

/*
**     function: int getcmd(char *name)
**  description: searches [cmdtab] for a matching command
**      returns: value assigned to each command in [cmdtab] or ERROR_FLAG
**               upon error
*/

int getcmd(name)
    char *name;
{
    struct cmd *c;

    for(c=cmdtab; c; c++) {
        if (!strncmp(name, c->cmd_name, c->unique)) {
            if (strlen(name)<=strlen(c->cmd_name)) {
                if (!strncmp(name, c->cmd_name, strlen(name)))
                    return(c->cmd_code);
            }
            return(ERROR_FLAG);
        }
    }
    return(ERROR_FLAG);
}

/*==========================================================================*/

/*
**     function: void process_arg(char *arg)
**  description: processes the value of one command line argument
**      returns: nothing
*/

void process_arg(arg)
    char *arg;
{
    register int  i, result_code;
    static   char tail[MAX_TAIL];

    tail[0]=0;
    for(i=0; (arg[i]!=':') && (arg[i]); i++)
        ;
    if (arg[i]) {
        strcpy(tail, &arg[i+1]);
        arg[i]=0;
    }
    result_code=getcmd(lowcase(arg));
    switch(result_code) {
        case HELP_FLAG:
            print_title();
            print_usage();
            exit(0);
            break;

#ifdef _UNIX
        case FORK_FLAG:
            fork_process=1;
            quiet=1;
            break;
#endif

        case INACTIVE_FLAG:
            inactive=1;
            break;

#ifdef _BSD
        case MAXIMIZE_FLAG:
            maximize=1;
            break;
#endif

        case PWFILE_FLAG:
            strcpy(pwfile, tail);
            break;
        case QUIET_FLAG:
            quiet=1;
            break;
        case RESTORE_FLAG:
            init_vars();
            strcpy(restorefile, tail);
            restoring=1;
            break;
        case SINGLE_FLAG:
            single=1;
            break;
        case STDIN_FLAG:
            stdin_words=1;
            break;
        case TEST_FLAG:
            test_crypt();
            break;
        case TIMEOUT_FLAG:
            timeout=atol(tail);
            break;
        case VALIDFILE_FLAG:
            strcpy(validfile, tail);
            break;
        case WORDFILE_FLAG:
            strcpy(wordfile, tail);
            break;
        default:
            kc_exit(1, "invalid argument", arg);
            break;
    }
}

/*===========================================================================*/

/*
**     function: char *get_next_token(char *s, char c)
**  description: reads the next token delimited by <c> from <s>
**      returns: token read
*/

char *get_next_token(s, c)
    register char *s, c;
{
    register int i, j;
    static   char token[MAX_TAIL];

    for(i=0; s[i]!=c; i++)
        ;
    i++;
    for(j=0; (s[i]) && (s[i]!='\r') && (s[i]!='\n'); i++, j++)
        token[j]=s[i];
    token[j]=0;
    return(token);
}

/*===========================================================================*/

/*
**     function: char *get_first_token(char *s, char c)
**  description: reads the first token delimited by <c> from <s>
**      returns: token read
*/

char *get_first_token(s, c)
    register char *s, c;
{
    register int i;
    static   char token[MAX_TAIL];

    for(i=0; ((token[i]=s[i])!=c); i++)
        ;
    token[i]=0;
    return(token);
}

/*==========================================================================*/

/*
**     function: void restore_session(void)
**  description: reads saved information from [restorefile] and prepares
**               to begin the restored session
**      returns: nothing
*/

void restore_session()
{
    FILE *rf;
    char s[MAX_LINE], s1[MAX_LINE];

    rf=fopen(restorefile, "r");
    if (!rf)
        kc_exit(1, "error opening restorefile", restorefile);
    while(fgets(s, MAX_LINE-1, rf)) {
        strcpy(s1, lowcase(get_first_token(s, '=')));
        if (!strcmp(s1, "pwfile"))
            strcpy(pwfile, get_next_token(s, '='));
        else if (!strcmp(s1, "wordfile"))
            strcpy(wordfile, get_next_token(s, '='));
        else if (!strcmp(s1, "validfile"))
            strcpy(validfile, get_next_token(s, '='));
        else if (!strcmp(s1, "flag"))
            process_arg(get_next_token(s, '='));
        else if (!strcmp(s1, "lastuser"))
            lastuser=atoi(get_next_token(s, '='));
        else if (!strcmp(s1, "lastword"))
            strcpy(lastword, get_next_token(s, '='));
        else
            kc_exit(1, "invalid restorefile identifier", s1);
    }
    fclose(rf);
    if (!quiet)
        print_title();
    if ((!pwfile[0]) || (!validfile[0]) ||
        ((!wordfile[0]) && (!stdin_words)))
        kc_exit(1, "some files not specified", NULL);
    if ((single) && (!lastuser))
        kc_exit(1, "last user not specified", NULL);
    if ((!single) && (!lastword[0]))
        kc_exit(1, "last word not specified", NULL);
    if ((!strcmp(lastword, "****DONE*****")) || (lastuser==-1))
        kc_exit(1, "session previously completed", NULL);
    if (!quiet) {
        print_files();
        print_stat();
    }
}

/*===========================================================================*/

/*
**     function: struct acc_list *set_data_pointers(struct acc_list *root)
**  description: forwards the linked-list and wordfile to the appropriate
**               index for proper continuation of a restored session
**      returns: root of new list
*/

struct acc_list *set_data_pointers(root)
    struct acc_list *root;
{
    int             i;
    char            word[MAX_WORD];
    struct acc_list *cur, *remove;

    if (single) {
        for(i=1, cur=root; i<lastuser; i++) {
            remove=cur;
            cur=cur->next;
            root=acc_remove(root, remove);
            do {
                i=restore_nextword(word);
                if (!i)
                    kc_exit(1, "single word set not found", NULL);
            } while(strcmp(word, "***!***"));
        }
        nextword();
    }
    else {
        do {
            i=restore_nextword(word);
            if (!i)
                kc_exit(1, "word not found", lastword);
        } while(strcmp(word, lastword));
    }
    return(root);
}

/*==========================================================================*/

struct acc_list *set_last(root)
    struct acc_list *root;
{
    struct acc_list *cur;

    for(cur=root; cur->next; cur=cur->next)
        ;
    return(cur);
}

/*===========================================================================*/

/*
**     function: void set_signals(void)
**  description: sets up all signal/interrupt routines
**      returns: nothing
*/

void set_signals()
{

#ifdef _MSDOS
    signal(SIGINT, handler);
#endif

#ifdef _UNIX
    signal(SIGINT, handler);
    signal(SIGQUIT, handler);
    signal(SIGTERM, handler);
    signal(SIGALRM, handler);
    signal(SIGHUP, SIG_IGN);
#endif

}
#endif

/*==========================================================================*/

/*
**     function: void maximize_resources(void)
**  description: sets the current resource limit to the maximum allowed
**               resource limit (BSD versions only)
**      returns: nothing
*/

#ifdef _BSD
void maximize_resources()
{
    struct rlimit r;

    getrlimit(RLIMIT_CPU, &r);
    r.rlim_cur=r.rlim_max;
    setrlimit(RLIMIT_CPU, &r);
}
#endif

/*===========================================================================*/

/*
**     function: void bg_process(void)
**  description: puts the session process into the background (Unix only)
**      returns: nothing
*/

#ifdef _UNIX
void bg_process()
{
    if (isatty(0)) {
        close(0);
        close(1);
        close(2);
        if (fork())
            exit(0);
    }
    else {
        close(0);
        close(1);
        close(2);
    }
}
#endif

/*===========================================================================*/

/*
**     function: void session(void)
**  description: prepares & executes the current crack session
**      returns: nothing
*/

void session()
{
    char            s[81];
    time_t          temp;
    struct acc_list *root;

    if (!quiet) {
        print_title();
        if (((!pwfile[0]) || (!validfile[0])) && (stdin_words))
            kc_exit(1, "some files not specified", NULL);
        print_files();
    }
    if ((!pwfile[0]) || ((!wordfile[0]) && (!stdin_words)) ||
        (!validfile[0]))
        kc_exit(1, "some files not specified", NULL);
    if (!quiet)
        print_stat();

#ifndef _STRIPPED
    set_signals();
#endif

    if (!stdin_words)
        if (open_words()<0)
            kc_exit(1, "error opening wordfile", wordfile);
    if (open_valid()<0)
        kc_exit(1, "error opening validfile", validfile);

    if (!quiet) 
        show_string("Initializing session data...");
                
    root=read_pwfile();
    if (!quiet) {
        sprintf(s, "\nLoaded %d total accounts.\n", num_accs); 
        show_string(s);
        show_string("\n\n");
        show_string("Stripping accounts...  ");
    }
    root=acc_strip(root);
    if (!quiet)
        show_string("\n\n");
    bcrypt_init();

#ifdef _UNIX
    if (fork_process)
        bg_process();
    if (timeout)
        alarm((timeout*60));
#endif

#ifdef _BSD
    if (maximize)
        maximize_resources();
#endif

    fflush(stdout);
    if (restoring) {
        if (single)
            root=set_data_pointers();
        else
            set_data_pointers();
    }
    else
        nextword();
    root=set_last(root);
    if (!quiet)
        show_string("Cracking...\n");
    timer=time(&temp);
    if (single)
        if (quiet)
            crk_s_q(root);
        else
            crk_s(root);
    else
        if (quiet)
            crk_q(root);
        else
            crk(root);
    close_all(time(&temp)-timer);
    if (restorefile[0])
        save_options(1);
    if (!quiet)
        show_string("\n");
    kc_exit(0, "session complete", NULL);
}

/*==========================================================================*/

/*
**     function: void main(int argc, char **argv)
**  description: main function
**      returns: nothing
*/

void main(argc, argv)
    int  argc;
    char **argv;
{
    char s[MAX_LINE];

    init_vars();
    strcpy(progname, *argv);
    for(; --argc; ) {
        strcpy(s, *++argv);
        if ((s[0]=='-') || (s[0]=='/'))
            process_arg(&s[1]);
        else
            kc_exit(1, "invalid argument", s);
    }
    if (restoring)
        restore_session();
    session();
}
