/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.filter;

import javax.swing.JDialog;
import javax.swing.JOptionPane;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.util.Vector;
                    
public class CookieDetectFilter implements Filter{
  private JDialog dialog = null;
  private	Pattern pattern = Pattern.compile("^ *"+ "Set-[Cc]ookie" + " *: *([^\\r\\n]*)" + "\\r\\n", Pattern.CASE_INSENSITIVE | Pattern.MULTILINE);
  private Matcher matcher = null;
  private Vector result=null;   
  public CookieDetectFilter(){
	dialog = new PDialog();
  }

  public JDialog getDialog(){
  	return dialog;
  }

  /**
  *   used by FilterManager to run the filter 
  *   @param    header      header to be filtered
  *   @param    body 				body to be filtered (no use here)
  */
  public void process(HttpHeader header, HttpBody body){
    if (header != null && header instanceof HttpResponseHeader && header.getHeader("Set-cookie")!=null){
    		String content = header.toString();
    		matcher = pattern.matcher(content);
    		result = new Vector();
    		while (matcher.find()){
    			String cookie = matcher.group(1);
	        if (cookie != null){
	    
	          // Modal dialog with OK/cancel and a text field
	          Global.parosFrame.toFront();	    
	          String text = JOptionPane.showInputDialog(Global.parosFrame, "Accept the following cookie (Ok=Accept, Cancel=Reject)?", cookie);

	            // text == null means cancel pressed.  If cancel, cookie rejected 
	          if ((text != null && !text.equals(""))){            
	              header.setHeader("Set-cookie", null);          
	              result.add(text);
	              
	//            Global.parosFrame.logAppend(Global.parosFrame.COOKIE_LOG, text +"\r\n");
	          }            
	          else if (text==null){
	          		header.setHeader("Set-cookie", null);
//	          		result.add(cookie);          
	          }
	        }
    		}
    		
    		if (result.size() >0){
    			content = matcher.replaceAll("");
				
    			for (int i = 0;i< result.size(); i++){
    				content += "Set-Cookie: " + result.get(i).toString() + "\r\n";
    			}
    			try{
				//	header = new HttpResponseHeader(content);
    				header.setMessage(content);
    			}
    			catch (Exception e){
    				System.out.println(e.getMessage());
    			}
    		}
    		
    		result.clear();  		

    }
  }
  
  public String usage(){
    return "Detect and alert 'Set-cookie' attempt in HTTP response for modification.";
  }    

	class PDialog extends JDialog{
		PDialog(){super();}
		
  		public String toString(){
  			return "CookieDetectFilter";
  		}	
  		public void show(){};
	}
  
}