/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.filter;

import javax.swing.JDialog;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;

/* remove all 'If-Modified-Since' header line
 * 
 *
 */
public class IfModifiedSinceFilter implements Filter{
  private JDialog dialog = null;
    
  public IfModifiedSinceFilter(){
  	dialog = new JDialog(){
  		public String toString(){
  			return "IfModifiedSinceFilter";
  		}	
  		public void show(){}
  	};
  }

  public JDialog getDialog(){
  	return dialog;
  }
  
  /**
  *   used by FilterManager to run the filter 
  *   @param    header      header to be filtered
  *   @param    body 				body to be filtered (no use here)
  */
  public void process(HttpHeader header, HttpBody body){
    if (header != null && header.isText()){
        String ifModifed = header.getHeader("If-Modified-Since");
        if (ifModifed != null){    
              header.setHeader("If-Modified-Since", null);                   
        }
        String ifNoneMatch = header.getHeader("If-None-Match");
        if (ifNoneMatch != null){    
              header.setHeader("If-None-Match", null);                   
        }
        
    }
  }
  
  public String usage(){
    return "Remove 'If-Modified-Since' & 'If-None-Match' header fields in HTTP request.";
  }    
  
}
