/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.filter;

import java.util.Vector;

import javax.swing.JDialog;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpRequestHeader;
                    
public class LogCookie implements Filter{
	private Vector cookies = null;
  private JDialog dialog = null;
    
  public LogCookie(){
		dialog = new PDialog();
		cookies = new Vector();
  }

  public JDialog getDialog(){
  	return dialog;
  }

  /**
  *   used by FilterManager to run the filter 
  *   @param    header      header to be filtered
  *   @param    body 				body to be filtered (no use here)
  */
  public void process(HttpHeader header, HttpBody body){
    if (header != null && header instanceof HttpRequestHeader){
        String cookie = header.getHeader("Cookie");
        if (cookie != null && cookies.indexOf(cookie)==-1){           		
						HttpRequestHeader reqheader = (HttpRequestHeader)header;
						String uri = reqheader.getHostName(); //getAbsoluteURI();        
        		cookies.add(cookie);
        		Global.parosFrame.logAppend(com.proofsecure.paros.ui.ParosFrame.COOKIE_LOG, uri + "\t" + cookie +"\n");
        }
    }
  }
  
  public String usage(){
    return "Log all cookies sent from browser to server";
  }    

	class PDialog extends JDialog{
		PDialog(){super();}
		
  		public String toString(){
  			return "LogCookie";
  		}	
  		public void show(){};
	}
  
}