/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.filter;

import java.awt.Dimension;

import javax.swing.JDialog;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.util.Util;
                    
public class ReplaceRequestBody implements Filter{
  private JDialog dialog = null;
    
  public ReplaceRequestBody(){
	dialog = new PDialog(Global.parosFrame, true);
  }

  public JDialog getDialog(){
  	return dialog;
  }

  /**
  *   used by FilterManager to run the filter 
  *   @param    header      header to be filtered
  *   @param    body 				body to be filtered
  */
  public void process(HttpHeader header, HttpBody body){
    if (header != null && header instanceof HttpRequestHeader && header.isText()==true && body!=null){    	
    	  String txtFind = ((PDialog)dialog).getFindString();
    	  String txtReplace = ((PDialog)dialog).getReplaceString();
    	  if (txtFind != null && txtReplace != null){
    	  	String txtBody  = body.toString();
    	  	body.setBody(txtBody.replaceAll(txtFind, txtReplace));
    	  	System.out.println("replaced " + txtBody);
    	  }
    }
  }
  
  public String usage(){
    return "Click on the left cell to replace text pattern in HTTP request body.";
  }    

	class PDialog extends JDialog{
    private javax.swing.JButton btnFind;
    private javax.swing.JButton btnCancel;
    private javax.swing.JTextField txtFind;
    private javax.swing.JTextField txtReplace;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
		private String findString = null;
		private String replaceString = null;
		private String findStringOld = null;
		private String replaceStringOld = null;
		
  	public String toString(){
  		return "ReplaceRequestBody";
  	}	
  		
  		
  	public String getFindString(){ return findString;}
  	public String getReplaceString(){ return replaceString;}
  	
    /** Creates new form MenuOptions */
    public PDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    private void initComponents() {//GEN-BEGIN:initComponents

        btnFind = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        txtFind = new javax.swing.JTextField();
        txtReplace = new javax.swing.JTextField();
                
        getContentPane().setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setTitle(Global.APP_TITLE);

        setResizable(false);
        setBackground(java.awt.Color.lightGray);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        btnFind.setText("Save & Close");
        btnFind.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnFindActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.ipadx = 18;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints1.weightx = 0.5;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnFind, gridBagConstraints1);
        
        btnCancel.setText("Cancel");
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints1.weightx = 0.5;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnCancel, gridBagConstraints1);

				/*=-=-=-=-=-=-*/

        jLabel2.setText("Replace With:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.1;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabel2, gridBagConstraints1);

        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
//        gridBagConstraints1.gridheight = 2;        
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.4;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(txtReplace, gridBagConstraints1);
        
        jLabel1.setText("Pattern:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.1;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabel1, gridBagConstraints1);

        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        
        gridBagConstraints1.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.4;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(txtFind, gridBagConstraints1);

        
        pack();
    }//GEN-END:initComponents

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed        	
    	if (findStringOld==null) findStringOld = "";
    	if (!findStringOld.equals(""))
    		txtFind.setText(findStringOld);
    	if (replaceStringOld==null) replaceStringOld = "";
    	if (!replaceStringOld.equals(""))
    		txtReplace.setText(replaceString);
        // Add your handling code here:
        hide();
    }//GEN-LAST:event_btnCancelActionPerformed

    private void btnFindActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed
			findString = txtFind.getText();
			if (findString != null && findString.equals("")) findString = null;
			replaceString = txtReplace.getText();
			if (replaceString != null && replaceString.equals("")) replaceString = null;
			hide();

    }//GEN-LAST:event_btnOKActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }//GEN-LAST:event_closeDialog

	public void show(Dimension parentSize){
			findStringOld = findString;
			replaceStringOld = replaceString;
	/*	
		Dimension frameSize = this.getPreferredSize();
		  
		  if (parentSize == null){
			  	// get the desktop screen size
     		parentSize = Toolkit.getDefaultToolkit().getScreenSize();
	    }
	      
	    if (frameSize.height > parentSize.height) {
	      frameSize.height = parentSize.height;
	    }
	    if (frameSize.width > parentSize.width) {
	      frameSize.width = parentSize.width;
	    }
	    
	    this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
*/
			Util.centreChild(Global.parosFrame, this);
    	
      this.pack();
      this.show();  	
	}
 }
/*
		PDialog(){super();}
		
  		public String toString(){
  			return "PatternReplaceFilter";
  		}	
  		public void show(){
  		}
  
	}
  */
}