/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.log;
import java.awt.BorderLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/**
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class BrowserPanel extends JPanel{
	private JEditorPane editorPane;
	public BrowserPanel() {
		super();
		this.setLayout(new BorderLayout());
		editorPane = new JEditorPane();
//		editorPane.setEditable(false);		
//		JScrollPane jScrollPane = new JScrollPane(editorPane);  
		JScrollPane jScrollPane = new JScrollPane();
		add(jScrollPane, BorderLayout.CENTER);		
		jScrollPane.getViewport().add(editorPane, null);
	}
	
	public void show(String contentType, String s){
		editorPane.setContentType(contentType);
		String tmpfile = "htmlfile.tmp";
		writeTmpFile(tmpfile,s);
		try {
			editorPane.setPage((new File(tmpfile)).toURL());
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
/*
		Pattern pattern = Pattern.compile("<html>.*</html>");
		Matcher matcher = pattern.matcher(s);
		if (matcher.find()){			
			editorPane.setText(matcher.group(0));	
		}
		else
			editorPane.setText("<html><body>Content can't be displayed</body></html>");	
*/		
//		System.out.println(s);
//		editorPane.revalidate();
		editorPane.repaint();
	}

	private void writeTmpFile(String tmpfile, String s){	
		File logFile = new File(tmpfile);
		

		try {
			// Create a writable file channel
			FileChannel out = new FileOutputStream(logFile, false).getChannel();
			out.write(ByteBuffer.wrap(s.getBytes()));
			out.close();
		} catch (IOException e) {
			System.out.println(e.getMessage());
		}
	}

}
