/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.document.WebDoc;
import com.proofsecure.paros.document.WebDocExt;
import com.proofsecure.paros.document.WebLink;


public class OfflinePanel extends JPanel{
  private WebDoc webDoc = null;

  private JTextArea jTextArea3 = new JTextArea();
  private JToggleButton toggleOffline = new JToggleButton();
  private JButton jButton5 = new JButton();
  private JButton jButton6 = new JButton();
  private JButton jButton7 = new JButton();
  private JButton jButton8 = new JButton();
  private JScrollPane jScrollPane7 = new JScrollPane();
  private JScrollPane jScrollPane10 = new JScrollPane();
  private Box box2;

  
  public OfflinePanel(WebDoc doc){
    super();
    webDoc = doc;
    init();
  }
  

  private void init(){

    this.setLayout(new BorderLayout());

    jTextArea3.setBackground(Color.LIGHT_GRAY);
    jTextArea3.setEditable(false);
    jTextArea3.setMargin(new Insets(2, 4, 2, 4));

    box2 = Box.createHorizontalBox();

    box2.add(toggleOffline, null);
    box2.add(jButton5, null);
    box2.add(jButton6, null);
    box2.add(jButton7, null);
    box2.add(jButton8, null);

    this.add(jScrollPane7, BorderLayout.CENTER);

    this.add(jScrollPane10, BorderLayout.SOUTH);
    jScrollPane10.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
    jScrollPane10.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    jScrollPane10.getViewport().add(box2, null);
    jScrollPane7.getViewport().add(jTextArea3, null);

    toggleOffline.setText("Go Offline");
    toggleOffline.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        toggleOffline_actionPerformed(e);
      }
    });
    jButton5.setText("Clear Cache");
    jButton5.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton5_actionPerformed(e);
      }
    });
    jButton6.setText("Save Cache");
    jButton6.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton6_actionPerformed(e);
      }
    });
    jButton7.setText("Load Cache");
    jButton7.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton7_actionPerformed(e);
      }
    });
    jButton8.setText("Show Comment");
    jButton8.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        jButton8_actionPerformed(e);
      }
    });

  }

  public void setLogLink(WebLink w){
    webDoc.setHistory(w);
  }

  public Object getLogLink(String host, String s){
    return webDoc.getHistory(host, s);
  }
  public Object getLogLink(String host, String s, String post){
    return webDoc.getHistory(host, s, post);
  }


/* FUNCTIONS for the test Panel */
  
  void toggleOffline_actionPerformed(ActionEvent e) {
  if (toggleOffline.getText().equals("Go Offline")){
    Global.isOffline = true;
    //setOffline(true);
    toggleOffline.setText("Go Online");
  }
  else{
    Global.isOffline  = false;
    //setOffline(false);
    toggleOffline.setText("Go Offline");
  }

  }

  void jButton5_actionPerformed(ActionEvent e) {
    webDoc = new WebDoc();
    Global.parosFrame.clearTree();
    jTextArea3.setText("");     

  }

  void jButton6_actionPerformed(ActionEvent e) {
    // save cache
    try{

    String filename = File.separator+"par";
      JFileChooser fc = new JFileChooser(new File(filename));
    fc.addChoosableFileFilter(new MyFilter());

      // Show open dialog; this method does not return until the dialog is closed
      fc.showSaveDialog(this);
      File selFile = fc.getSelectedFile();

    if (selFile==null)
      return;



    filename = selFile.getPath();

    if (filename.indexOf(".par")==-1)
      filename += ".par";


//      XMLEncoder x = new XMLEncoder(
     ObjectOutputStream x= new ObjectOutputStream(
                          new BufferedOutputStream(
                              new GZIPOutputStream(
                              new FileOutputStream(filename))));
      x.writeObject(webDoc);
/*
      int cnt = webDoc.getTotalWebLink();
      WebLink wl=null;
      webDoc.resetIndex();

      while (cnt>0){
        wl = (WebLink)webDoc.getHistory();
        x.writeObject(wl);
        cnt--;
      }
  */
      x.close();
//    }catch(FileNotFoundException ae){System.out.println("File not found.");}
    }catch(IOException ae){System.out.println("File not found.");}
  }

  void jButton7_actionPerformed(ActionEvent e) {
    // load cache from default file test.xml
    try{

    String filename = File.separator+"par";
      JFileChooser fc = new JFileChooser(new File(filename));

    fc.addChoosableFileFilter(new MyFilter());

  // Show save dialog; this method does not return until the dialog is closed
      fc.showOpenDialog(this);
      File selFile = fc.getSelectedFile();

    if (selFile==null)
      return;

     ObjectInputStream d= new ObjectInputStream(
                new BufferedInputStream(
                                  new GZIPInputStream(
                                    new FileInputStream(selFile))));
//     XMLDecoder d = new XMLDecoder(is);
     webDoc = (WebDoc)d.readObject();
/*
      int cnt = webDoc.getTotalWebLink();
      webDoc.setTotalWebLink(0);
      WebLink wl=null;

      while (cnt>0){
        wl = (WebLink)d.readObject();
        webDoc.setHistory(wl);
        cnt--;
      }
      webDoc.resetIndex();
      */
    String line1 = "Website Cache Information:\r\n\r\n";
    String links = webDoc.toString();
    StringTokenizer st = new StringTokenizer(links, "\r\n");
      while (st.hasMoreTokens()) {
        String l = st.nextToken();
        String respcode = "";
        int index =0;
        if ((index=l.indexOf(" "))!=-1){
          respcode = l.substring(0,index);
          l = l.substring(index);         
        }
        if ((index=l.indexOf("/"))!=-1){
          String host = l.substring(0,index);
          String uri = l.substring(index);
          Global.parosFrame.setTreeNoGUI(host, uri);
//            println(st.nextToken());
        }
      }
  
    Global.parosFrame.refreshTree();
    
        
    jTextArea3.setText(line1 + links);      
    
    
//    setTree(client_is_reqh.getHostName(), client_is_reqh.getURI());

//    }catch(FileNotFoundException ae){System.out.println("File not found.");}
    }catch(Exception ae){
      //System.out.println(ae.getMessage());
      JOptionPane.showMessageDialog(this, "Incompatible file format or file corrupted."); 
    }
  }

  void jButton8_actionPerformed(ActionEvent e) {
    jTextArea3.setText(WebDocExt.toStringForComment(webDoc));     
  }


  class MyFilter extends javax.swing.filechooser.FileFilter {
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.endsWith(".par");
        }
        public String getDescription() {
            return "*.par";
        }
    }



}