/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.net.URISyntaxException;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.document.WebDoc;
import com.proofsecure.paros.document.WebLink;
import com.proofsecure.paros.log.DumpResponsePanel;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.util.Util;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 * @author unascribed
 * @version 1.0
 */

public class ParosFrame extends JFrame implements ComponentListener{
  // for logPane at the lower part of GUI
  public final static String OUTPUT_LOG = "Output";
  public final static String ERROR_LOG = "Errors";
  public static final String COOKIE_LOG = "Cookies";
  public static final String URL_LOG = "URLs";
  public static final String REQUEST_LOG = "Requests";
  public static final String RESPONSE_LOG = "Responses";
  public static final String TRAP_PANEL = "Trap";
  public static final String OPTION_PANEL = "Options";
  public static final String FILTER_PANEL = "Filters";
  public static final String SCAN_PANEL = "Scan";
  public static final String LOG_PANE = "LogPane";
  public static final String RIGHT_PANE = "RightPane";
  private static final int LOG_PANE_HEIGHT = 200;
  private static final int FRAME_HEIGHT = 480;
  private JList urlList = null; 
    
  private JPanel contentPane;
  
  // for menu
  public ParosMenu menubar = new ParosMenu(this);

  // for toolbar 
  private JToolBar jToolBar = new JToolBar();
  private JButton jButton1 = new JButton();
  private JButton jButton2 = new JButton();
  private JButton jButton3 = new JButton();
  private ImageIcon image1;
  private ImageIcon image2;
  private ImageIcon image3;
  private Border border3;


  // for the size-adjustable panels
  private JSplitPane jSplitPane1 = new JSplitPane();
  private JSplitPane jSplitPane2 = new JSplitPane();
  
  // for other stuffs
  private JLabel statusBar = new JLabel();

  // Panels
  private ParosTabbedPane rightTabPane = new ParosTabbedPane();
  private ParosTabbedPane logPane = new ParosTabbedPane();
  private TreePanel treePanel = Global.treePanel;	//new TreePanel();
  private TrapPanel trapPanel = Global.trapPanel;	//new TrapPanel();
  private DumpResponsePanel responsePanel = new DumpResponsePanel();
  private DumpResponsePanel requestPanel = new DumpResponsePanel();

  // local data 
  private int old_frame_height = FRAME_HEIGHT;
  private static java.lang.Object sem = new java.lang.Object();
  private WebDoc webDoc = Global.webDoc;

  
  //Construct the frame
  public ParosFrame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  
  public ParosMenu getParosMenu() {
  	return menubar;
  }
  //Component initialization
  private void jbInit() throws Exception  {
  	  	
/*
    image1 = new ImageIcon(paros.Frame2.class.getResource("openFile.gif"));
    image2 = new ImageIcon(paros.Frame2.class.getResource("closeFile.gif"));
    image3 = new ImageIcon(paros.Frame2.class.getResource("help.gif"));
    image4 = new ImageIcon(paros.Frame2.class.getResource("header3.gif"));
    image5 = new ImageIcon(paros.Frame2.class.getResource("header3.gif"));
*/
	  image1 = new ImageIcon("openFile.gif");
    image2 = new ImageIcon("closeFile.gif");
    image3 = new ImageIcon("help.gif");

    setIconImage(Toolkit.getDefaultToolkit().createImage("paros_logo.gif"));
    //setIconImage(Toolkit.getDefaultToolkit().createImage(Frame2.class.getResource("[Your Icon]")));
    contentPane = (JPanel) this.getContentPane();
    border3 = BorderFactory.createEmptyBorder(2,2,2,2);
    contentPane.setLayout(new BorderLayout());
    this.setSize(new Dimension(640, FRAME_HEIGHT));
    this.setTitle(Global.APP_TITLE);

    this.setJMenuBar(menubar);

    // Toolbar creation
    jButton1.setIcon(image1);
    jButton1.setMargin(new Insets(2, 2, 2, 2));
    jButton1.setBorder(border3);
    jButton1.setToolTipText("Open File");
    jButton1.setBorderPainted(false);
    jButton2.setIcon(image2);
    jButton2.setMargin(new Insets(2, 2, 2, 2));
    jButton2.setBorder(border3);
    jButton2.setToolTipText("Close File");
    jButton2.setBorderPainted(false);
    jButton3.setIcon(image3);
    jButton3.setMargin(new Insets(2, 2, 2, 2));
    jButton3.setBorder(border3);
    jButton3.setToolTipText("Help");
    jButton3.setBorderPainted(false);

    jToolBar.setEnabled(false);
    jToolBar.add(jButton1);
    jToolBar.add(jButton2);
    jToolBar.add(jButton3);

    // statusBar creation
    statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
    statusBar.setDisplayedMnemonic('0');
    statusBar.setText(" ");

    // Creating 3 resizable Panel areas
    jSplitPane1.setOrientation(JSplitPane.VERTICAL_SPLIT);
    jSplitPane1.setBorder(BorderFactory.createEtchedBorder());
    jSplitPane1.setDividerSize(3);
    jSplitPane2.setBorder(BorderFactory.createEtchedBorder());
    jSplitPane2.setDividerSize(3);



/*
    jTextArea2.setMargin(new Insets(2, 4, 2, 4));
    jTextArea2.setText("Write your notes here");
    jTextArea2.setLineWrap(true);
*/
    jSplitPane1.add(jSplitPane2, JSplitPane.TOP);
    jSplitPane2.add(treePanel, JSplitPane.TOP);
    jSplitPane2.add(rightTabPane, JSplitPane.RIGHT);
    
    logPane.setTabPlacement(JTabbedPane.BOTTOM);

	urlList = logPane.addListPanel(URL_LOG);
	urlList.setModel(Global.urlLog);
	
    logPane.addLogPanel(OUTPUT_LOG);
    //logPane.addLogPanel(ERROR_LOG);
    logPane.addLogPanel(COOKIE_LOG);
	
    this.logAppend(COOKIE_LOG, "Accepted cookie will be shown here if LogCookie is enabled.\r\n");

	if (!Global.isDumpLog){
		logPane.addLogPanel(REQUEST_LOG);
		logPane.addLogPanel(RESPONSE_LOG);
	}
    jSplitPane1.add(logPane, JSplitPane.BOTTOM);
    
	rightTabPane.add(requestPanel,REQUEST_LOG);
	rightTabPane.add(responsePanel,RESPONSE_LOG);
    rightTabPane.add(trapPanel,TRAP_PANEL);
  /*
    rightTabPane.addFocusListener(new FocusAdapter() {
	public void focusGained (MouseEvent e) {
		String selected = urlList.getSelectedValue().toString();		
		if (requestPanel.isVisible()){
			Vector v = Global.dumpAnalyzer.searchRequest(selected);
			if (v!=null){
				requestPanel.setMessage(v.get(0).toString(), v.get(1).toString());
			}
		}
		else if (responsePanel.isVisible()){
			Vector v = Global.dumpAnalyzer.searchResponse(selected);
			if (v!=null){
				responsePanel.setMessage(v.get(0).toString(), v.get(1).toString());
			}
		}

	}
	});  	
*/
	rightTabPane.addMouseListener(new MouseAdapter() {
	public void mousePressed (MouseEvent e) {
		super.mousePressed(e);
		if (urlList.getSelectedValue()==null)
			return;
		String selected = urlList.getSelectedValue().toString();	
		selected = selected.substring(0,selected.indexOf(":"));
//		System.out.println(rightTabPane.getSelectedIndex());
//		System.out.println("2 " + rightTabPane.indexOfTab(ParosFrame.REQUEST_LOG) + selected);
		
		if (rightTabPane.getSelectedIndex() == rightTabPane.indexOfTab(ParosFrame.REQUEST_LOG)){
//		if (requestPanel.isVisible()){
			Vector v = Global.dumpAnalyzer.searchRequest(selected);
			if (v!=null){
				requestPanel.setMessage(v.get(0).toString(), v.get(1).toString());
			}
		}
		else if (rightTabPane.getSelectedIndex() == rightTabPane.indexOfTab(ParosFrame.RESPONSE_LOG)){
			Vector v = Global.dumpAnalyzer.searchResponse(selected);
			if (v!=null){
				responsePanel.setMessage(v.get(0).toString(), v.get(1).toString());
			}
		}
	}
	});	
/*
    requestPanel.addMouseListener(new MouseAdapter() {
	public void mousePressed (MouseEvent e) {
		super.mousePressed(e);
		String selected = urlList.getSelectedValue().toString();
		selected = selected.substring(0,selected.indexOf(":"));
		Vector v = Global.dumpAnalyzer.searchRequest(selected);
		if (v!=null){
			requestPanel.setMessage(v.get(0).toString(), v.get(1).toString());
		}
		System.out.println("test");

	}
  	});
  	
	requestPanel.addFocusListener(new FocusAdapter() {
	public void focusGained (MouseEvent e) {
		//super.mousePressed(e);
		String selected = urlList.getSelectedValue().toString();
		selected = selected.substring(0,selected.indexOf(":"));
		Vector v = Global.dumpAnalyzer.searchRequest(selected);
		if (v!=null){
			requestPanel.setMessage(v.get(0).toString(), v.get(1).toString());
		}
		System.out.println("test");

	}
	});  	
	
	*/
	
  //    rightTabPane.add(new FilterPanel(),     FILTER_PANEL);
//    rightTabPane.add(new ScanPanel(),     SCAN_PANEL);
    rightTabPane.add(new FunctionPanel(Global.filterManager, "Filters are run automatically after being enabled."),FILTER_PANEL);
    rightTabPane.add(new FunctionPanel(Global.scanManager, "Select the website(tree) on left and click menu Tree => Scan Selected/All to start."),SCAN_PANEL);
    rightTabPane.add(new OptionPanel(),     OPTION_PANEL);
//    rightTabPane.add(new OfflinePanel(webDoc),"Offline Mode");
    //rightTabPane.addLogPanel("Notes");
    //rightTabPane.setEditable("Notes", true);

	urlList.addListSelectionListener(new ListSelectionListener(){
		// This method is called each time the user changes the set of selected items
		public void valueChanged(ListSelectionEvent evt) {
			// When the user release the mouse button and completes the selection,
			// getValueIsAdjusting() becomes false
			if (!evt.getValueIsAdjusting()) {
				JList list = (JList)evt.getSource();
				if (list.getModel().getSize()<= 0)
					return;
				String selected = list.getSelectedValue().toString();
				selected = selected.substring(0,selected.indexOf(":"));
				if (requestPanel.isVisible()){
					Vector v = Global.dumpAnalyzer.searchRequest(selected);
					if (v!=null){
						requestPanel.setMessage(v.get(0).toString(), v.get(1).toString());
					}
				}
				else if (responsePanel.isVisible()){
					Vector v = Global.dumpAnalyzer.searchResponse(selected);
					if (v!=null){
						responsePanel.setMessage(v.get(0).toString(), v.get(1).toString());
					}
				}
				//}
				//requestPanel.deliverEvent();

			}
		}
	});	

//    jScrollPane6.getViewport().add(jTextArea2, null);
    contentPane.setEnabled(true);
    contentPane.setToolTipText("");
    contentPane.add(jSplitPane1, BorderLayout.CENTER);
    contentPane.add(statusBar, BorderLayout.SOUTH);
//    contentPane.add(jToolBar, BorderLayout.NORTH);
    jSplitPane1.setDividerLocation(FRAME_HEIGHT-LOG_PANE_HEIGHT);
    jSplitPane2.setDividerLocation(180);
    jSplitPane1.addComponentListener(this);
    

  }


  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
//      jMenuFileExit_actionPerformed(null);
      System.exit(0);
    }
    //else if (e.getSource() instanceof JFrame ) {
    else if (e.getID() == WindowEvent.COMPONENT_RESIZED ) {
    	componentResized(e);
	}
//      jMenuFileExit_actionPerformed(null); e.getSource()
//      System.out.println(e);
    //}
  }

  public void componentResized(ComponentEvent e){
    // SplitPane
    
    
    if (e.getComponent() == jSplitPane1){
	    if (this.getSize().height - old_frame_height > 0) { // expand
	    	jSplitPane1.setDividerLocation(this.getSize().height - (old_frame_height - jSplitPane1.getDividerLocation()));

		}
	   	if (this.getSize().height > LOG_PANE_HEIGHT && this.getSize().height - jSplitPane1.getDividerLocation() < LOG_PANE_HEIGHT){
	    	jSplitPane1.setDividerLocation(this.getSize().height - LOG_PANE_HEIGHT);
	    }
	}
//    else if (e.getComponent() == jSplitPane3){
   	//if (jSplitPane3.getSize().height!= old_pane3_height &&  jSplitPane3.getSize().height > 150){ // && jSplitPane3.getDividerLocation() < 150){ // && jSplitPane2.getSize().height - jSplitPane3.getDividerLocation() > 150){
//		jSplitPane3.setDividerLocation(150);
//	}
/*
	int location =jSplitPane3.getDividerLocation();
	if (jSplitPane3.getSize().height - location < 100)
		location = jSplitPane3.getSize().height - 100;
	if (location < 100)
		location = 100;
	jSplitPane3.setDividerLocation(location);
*/

    old_frame_height = this.getSize().height;

  }

  public void componentMoved(ComponentEvent e){
  }
  public void componentShown(ComponentEvent e){
  }
  public void componentHidden(ComponentEvent e){
  }

  public static void main(String[] args) {
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch(Exception e) {
      e.printStackTrace();
    }

    boolean packFrame = false;

    ParosFrame frame = new ParosFrame();
    //Validate frames that have preset sizes
    //Pack frames that have useful preferred size info, e.g. from their layout
    if (packFrame) {
      frame.pack();
    }
    else {
      frame.validate();
    }
    //Center the window
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    Dimension frameSize = frame.getSize();
    if (frameSize.height > screenSize.height) {
      frameSize.height = screenSize.height;
    }
    if (frameSize.width > screenSize.width) {
      frameSize.width = screenSize.width;
    }
    frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    frame.setVisible(true);
  }




/* FUNCTIONS for GUI Control */
  
  /**
    show the panel in the right-hand Frame
    @param pane   the pane name of the panel to be shown
    @param label  the tag name of the panel to be shown
  */
  public void showPanel(final String pane, final String label){
      JTabbedPane tabPane = null;
      if (pane.equals(ParosFrame.LOG_PANE)){
        tabPane = this.logPane;
      }
      else if (pane.equals(ParosFrame.RIGHT_PANE)){
        tabPane = this.rightTabPane;
      }
      int index = tabPane.indexOfTab(label);
      if (index != -1){
       // found
       tabPane.setSelectedIndex(index); 
      }
  }

    
	public void setTree(HttpRequestHeader req, HttpBody body) throws HttpMalformedHeaderException, URISyntaxException {
		treePanel.setTree(req, body);
	}

  public void refreshTree(){
        treePanel.TreeRefresh();

  }

  public void setTreeNoGUI(String host, String uri){    
    System.out.println("setTreeNoGUI called");
    //treePanel.setTreeNoGUI(host, uri, null);
  }
        
  public void setStatus(final String status) {
  	
	SwingUtilities.invokeLater(new Runnable() {
		public void run() {
           statusBar.setText(status);
        }
    });
  	
  }


        public void setPanel(final HttpHeader hdr, final HttpBody body, final String status, final boolean isRequest) {
/*        	
        	if (isRequest && !((String)(myModel.getValueAt(4,1))).equals("")){
        		try{
        		 hdr.setHeader(textReplace(hdr.toString(),"jsessionid=", " \r\n;", (String)(myModel.getValueAt(4,1))));
        		}catch(HttpMalformedHeaderException he){System.out.println(he);}
        	}
*/        	
          if (hdr.isImage()) // let all image request pass thru without trapping
            return;
          if (isRequest  && !trapPanel.isTrapRequest() && !hdr.isImage()) // request not TrapOn
            return;
          if (!isRequest && !trapPanel.isTrapResponse() && !hdr.isImage())  // response not TrapOn
            return;

          synchronized (sem) {

            trapPanel.setContinue(false);

						trapPanel.setMessage(hdr.toString(), body.toString());						
            toFront();

            while (!trapPanel.isContinue()) {
              Util.sleep(100);
            }						
/*						
        		SwingUtilities.invokeLater(new Runnable() {
              public void run() {                    
*/
            try {
              EventQueue.invokeAndWait(new Runnable() {
              public void run() {     
                try{
										hdr.setMessage(trapPanel.getHeader());
				            if (body != null) 
											body.setBody(trapPanel.getBody());
										trapPanel.setMessage("","");

									}catch(HttpMalformedHeaderException he){
//									   he.printStackTrace();
                     logPane.append(ERROR_LOG,he.getMessage());
									}

			            trapPanel.setContinue(false);

                }
              });
            }catch(Exception ie){
               logPane.append(ERROR_LOG,ie.getMessage());            
            }


          } // end sync

        }

  public void logAppend(String s){
      logPane.append(OUTPUT_LOG,s);
  		//JLabel theLabel = new JLabel("<font color=blue>" + s + "</font>");

  }

  public void logAppend(String name, String s){
      logPane.append(name,s);
  }


	public void requestLogFocus(String pane) {
		logPane.requestLogFocus(pane);
	}
	
/* FUNCTIONS for web links data structure */

	public void setLogLink(WebLink w){
		webDoc.setHistory(w);
	}

	public Object getLogLink(String host, String s){
		return webDoc.getHistory(host, s);
	}
	public Object getLogLink(String host, String s, String post){
		return webDoc.getHistory(host, s, post);
	}


/* FUNCTIONS for the test Panel */
  

  	public void clearTree(){
    	treePanel.clearTree();
  	}


}


