/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.ui;

import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;

import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

import com.proofsecure.paros.Global;

public class ParosTabbedPane extends JTabbedPane{

	/**	Maximum log size before truncate occurs */
	private final static int	MAX_LOG_SIZE = 1024000;	
  	Hashtable panels = new Hashtable();     
 
  ParosTabbedPane() {
    super();
  }

  JList addListPanel(String name){
	JScrollPane scrollPane = new JScrollPane();
    
	final JList list = new JList();
	list.setFont(new java.awt.Font("Dialog", 0, 11));
	scrollPane.getViewport().add(list, null);
	panels.put(name,scrollPane);    
	this.addTab(name, scrollPane);
	return list;  
  } 
    
  void addLogPanel(String name){
    JScrollPane scrollPane = new JScrollPane();
    
    final JTextArea textArea = new JTextArea();
    textArea.setFont(new java.awt.Font("Dialog", 0, 11));
    textArea.setEditable(false);
    textArea.setLineWrap(true);
    textArea.setMargin(new Insets(0, 5, 5, 0));
    textArea.addMouseListener (new MouseAdapter() {
      public void mousePressed (MouseEvent e) {
        if ((e.getModifiers() & InputEvent.BUTTON3_MASK) != 0) {  // right mouse button
          PopupPanel pp = new PopupPanel(textArea);   // should pass component to popup
          pp.getPopupMenu().show (e.getComponent(),
            e.getX(), e.getY());
        }
        else{
          super.mousePressed(e);
        }
      }
    });

    scrollPane.getViewport().add(textArea, null);
    panels.put(name,scrollPane);    
    this.addTab(name, scrollPane);  
  } 


  void setEditable(final String name, boolean b){
    ((JTextArea)((JScrollPane)panels.get(name)).getViewport().getView()).setEditable(b);
  }
  
  void append(final String name, final String text){
    
    SwingUtilities.invokeLater(new Runnable() {
       public void run() {
		Object log = (((JScrollPane)panels.get(name)).getViewport().getView());
		if (log instanceof JTextArea){
			String		newText = "";
       		
			JTextArea area = ((JTextArea)((JScrollPane)panels.get(name)).getViewport().getView());
       	
			// check if the textarea is too large.  If so, truncate it nearly half at the next LF.
			if (area.getText().length() + text.length() > MAX_LOG_SIZE) {
				int pos = area.getText().indexOf( "\\n", area.getText().length() /2);
				if (pos > -1) {
					newText = area.getText().substring(pos);
				} else {
					newText = area.getText().substring(area.getText().length() /2);
				}
				area.setText(newText);
			}
			area.append(text);
			//((JTextArea)((JScrollPane)panels.get(name)).getViewport().getView()).append(text);
		  ((JScrollPane)panels.get(name)).getVerticalScrollBar().setValue(((JScrollPane)panels.get(name)).getVerticalScrollBar().getMaximum());
		}
		else if (log instanceof JList){
			//JList area = (JList)log;
			Global.urlLog.addElement(text);
			//area.setModel(Global.urlLog); 
			((JScrollPane)panels.get(name)).getVerticalScrollBar().setValue(((JScrollPane)panels.get(name)).getVerticalScrollBar().getMaximum());
		}
       }
     }
    );

	}
	
	public void requestLogFocus(String pane) {
		try {
			setSelectedComponent((JScrollPane) (panels.get(pane)));
		} catch (Exception e) {
		}
	}
	
/*
	void appendUrl(final String text, DefaultListModel){
    
	  SwingUtilities.invokeLater(new Runnable() {
		 public void run() {
			JList list =  (JList)((JScrollPane)panels.get(name)).getViewport().getView();	
			DefaultListModel m = ((DefaultListModel)(list.getModel()));
			m.addElement(name);
			list.setModel(m);			
		  }
	   }
	  );
   
	}
*/	
/*
  
  JTextArea getTextArea(String name){   
    return (JTextArea)((JScrollPane)panels.get(name)).getViewport().getView();
  }
*/  
  
}