/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.Component;

import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JFrame;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.util.Util;


public class PopupPanel extends JPanel {
  JPopupMenu popup = new JPopupMenu ();
  JComponent control = null;
//      JMenuItem item;
    JMenuItem item2;
		JMenuItem jMenuScanSelected ;
	JMenuItem jMenuScanDeleteTree;		
  JMenuItem jMenuEditFind;
	
  public JPopupMenu getPopupMenu(){
  	return popup;
  }

  public PopupPanel(JComponent c) {
  	this();
  	control = c;
  	if (c instanceof JTree){
  		popup.remove (jMenuEditFind);
//  		popup.remove(item);
  	}
  	else if (c instanceof JTextArea){
  		popup.remove(jMenuScanSelected);
  		popup.remove(jMenuScanDeleteTree);
  	}
  }


  public PopupPanel() {
		jMenuScanSelected = new JMenuItem ("Scan Selected Node");
		
//	  jMenuScanSelected.setText("Scan Selected Node");
		jMenuScanSelected.setMnemonic(KeyEvent.VK_S);
	    jMenuScanSelected.addActionListener(new ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
	        	if (Global.treePanel.getSelectedParsedEntity() != null) {
	          		Global.scanner.startScan(Global.treePanel.getSelectedParsedEntity());
	        	} else {
	        		Util.showMessageDialog("Please select a site or folder.");
	        	}
	      	}
	    });

    popup.add(jMenuScanSelected);

	jMenuScanDeleteTree = new JMenuItem("Delete Selected Node");
	popup.add(jMenuScanDeleteTree);
	jMenuScanDeleteTree.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {   
    		
        	ParsedEntity entity = null;
        	
        	//entity = Global.treePanel.getSelectedParsedEntity();
        	//Global.treePanel.getTree().removeSelectionPath(Global.treePanel.getTree().getSelectionPath());
        	
        	
        	ParsedEntity parent = null;
        	entity = Global.treePanel.getSelectedParsedEntity();

        	if (entity == null) {
        		Util.showMessageDialog("Please select a site or folder.");
				return;
        	}

			parent = (ParsedEntity) entity.getParent();
			if (parent != null) {
                Global.treePanel.getTreeModel().removeNodeFromParent(entity);
                Global.treePanel.getTree().setModel(Global.treePanel.getTreeModel());
            }
			
       	
		}
    });

//    popup.add (item = new JMenuItem ("Cut"));
//    popup.add (new JMenuItem ("Popup"));
    popup.add (item2 = new JMenuItem ("Clear All"));
//    popup.addSeparator();
//    popup.add (item = new JMenuItem ("Paste"));
//		item = new JMenuItem ("Select All");
/*
        item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
              if (control instanceof JTextArea){
//              			((JTextArea)control).setEditable(true);
  //            			((JTextArea)control).setCaretPosition(1);
    //          			((JTextArea)control).setDragEnabled(true);
                    ((JTextArea)control).selectAll();                
      //              ((JTextArea)control).repaint();                
                     //((JTextArea)control).select(0,((JTextArea)control).getText().length()); 
              }
            }
        });

    popup.add (item);
*/
        item2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
            	if (control instanceof JTextArea){
            		  ((JTextArea)control).setText("");
            	}
            	else if (control instanceof JTree){
//            		((JTree)control).removeAll();
            		Global.parosFrame.clearTree();

            	}
                //mnuFileExitActionPerformed(evt);
//                System.out.println(evt);
            }
        });

    jMenuEditFind = new JMenuItem("Find...");
//    jMenuEditFind.setMnemonic(KeyEvent.VK_F);
//    jMenuEditFind.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, KeyEvent.CTRL_MASK));
    jMenuEditFind.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
      		Component c = control;
      		JFrame parent = null;
      		try {
      			while (c.getParent() != null) {
      				c = c.getParent();
      				if (c instanceof JFrame) {
      					parent = (JFrame) c;
      					break;
      				}
      			}
      		} catch (Exception ex) {
      			ex.printStackTrace();
      			parent = Global.parosFrame;
      		}

			if (parent == null) {
				parent = Global.parosFrame;
			}
			      			
      		Global.findDialog = new FindDialog(parent, false);
			Util.centreChild(parent, Global.findDialog);
			Global.findDialog.show();	      
	    }
    });
	
		popup.add (jMenuEditFind);


    popup.setInvoker (this);
/*
    addMouseListener (new MouseAdapter() {
      public void mousePressed (MouseEvent e) {
        if (e.isPopupTrigger()) {
          popup.show (e.getComponent(),
            e.getX(), e.getY());
//					System.out.println("AA 1");
        }
      }
      public void mouseReleased (MouseEvent e) {
        if (e.isPopupTrigger()) {
          popup.show (e.getComponent(),
            e.getX(), e.getY());
          //  JOptionPane.showInternalMessageDialog(popup, "information2","information2", JOptionPane.INFORMATION_MESSAGE);
//					System.out.println("AA 2");
        }
      }
    });
*/    
  }



}
