/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.util;

public class SerialCounter {
	
	int		mNextNewSerial = 0;
	int		mCurrentSerial = 0;

	public SerialCounter() {
		mNextNewSerial = 1;
		mCurrentSerial = 1;
	}
		
	public synchronized int getNextSerial() {
		int result = mNextNewSerial++;
		return result;
	}
	
	/**
	Wait for the turn of the serial number until
	1/ its serial number is matched for its turn; or
	2/ time out.
	@param	mySerial		Serial number passed in for checking.
	@param	timeOutMillis	Timeout value in millisecond.
	*/
	public synchronized void waitForTurn(int mySerial, int timeOutMillis) {
		
		long 	startTime	= System.currentTimeMillis();
		long	now			= startTime;
		while (mySerial > mCurrentSerial) {
			try {
				this.wait(20);
			} catch (InterruptedException e) {
			}
			
			now = System.currentTimeMillis();
			if (startTime + timeOutMillis < now) {
				mCurrentSerial = mySerial;
				this.notifyAll();
				break;
			}
		}
	}

	/**
	Set the turn to serial number.
	@param	mySerial		Serial number passed in for checking.
	*/	
	public synchronized void setTurn(int mySerial) {
		if (mySerial >= mCurrentSerial) {
			mCurrentSerial = (mySerial == mCurrentSerial)? mCurrentSerial+1 : mySerial;
			this.notifyAll();
		}
	}
	
	/**
	Get current serial
	*/
	public int getCurrentSerial() {
		return mCurrentSerial;
	}
			
}

