/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros;

import com.proofsecure.paros.AdminServer;
import com.proofsecure.paros.ConnectionQueueEntry;
import com.proofsecure.paros.Global;
import com.proofsecure.paros.SSLProxyHandler;
import com.proofsecure.paros.log.Dump;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.HttpConnectionPool;
import com.proofsecure.paros.network.HttpInputStream;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.util.SerialCounter;
import com.proofsecure.paros.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.util.Vector;

class ProxyHandler
implements Runnable {
    protected static final byte[] CONNECT_HTTP_200 = "HTTP/1.0 200 Connection established\r\nProxy-Connection: Close\r\n\r\n".getBytes();
    protected static Vector tunnelProcessList = new Vector();
    protected static DecimalFormat decimalFormat = new DecimalFormat("##0.###");
    protected static final int BUFFEREDSTREAM_SIZE = 4096;
    protected static SerialCounter counter = new SerialCounter();
    protected static DecimalFormat decFormat = new DecimalFormat("##0.###");
    private int count = 0;
    protected Socket mInSocket = null;
    protected Socket mOutSocket = null;
    protected boolean disconnect = false;
    protected HttpInputStream mClientHttpIn = null;
    protected HttpInputStream mHostHttpIn = null;
    protected HttpOutputStream mClientHttpOut = null;
    protected HttpOutputStream mHostHttpOut = null;
    protected HttpRequestHeader mClientHttpInReqHeader = null;
    protected HttpResponseHeader mHostHttpInResHeader = null;
    protected HttpBody mClientHttpInReqBody = null;
    protected HttpBody mHostHttpInResBody = null;
    BufferedInputStream tunnel_in = null;
    BufferedOutputStream tunnel_out = null;
    protected HttpConnection mConn = null;
    protected HttpConnectionPool mPool = null;
    protected String mHostName = "";
    protected int mHostPort = 0;
    protected boolean isUseAbsolueteUri = false;
    protected Thread myThread = new Thread(this);
    protected ProxyHandler mOriginHandler = null;
    protected boolean httpsFlag = false;
    private boolean isTunnelInputBufferEmpty = true;

    ProxyHandler() {
        this.myThread.setDaemon(true);
        this.mOriginHandler = this;
    }

    public void start(Socket sock) {
        this.mInSocket = sock;
        try {
            this.mInSocket.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.myThread.start();
    }

    public void start(Socket sock, boolean flag) {
        this.httpsFlag = flag;
        this.mInSocket = sock;
        try {
            this.mInSocket.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.myThread.start();
    }

    public boolean isAlive() {
        return this.myThread.isAlive();
    }

    public Thread getThread() {
        return this.myThread;
    }

    public void run() {
        this.process();
        this.disconnect();
        if (this.count != 0) {
            counter.setTurn(this.count);
        }
    }

    protected void process() {
        this.http();
    }

    private void http() {
        try {
            this.mClientHttpIn = new HttpInputStream(this.mInSocket.getInputStream());
            this.mClientHttpOut = new HttpOutputStream(this.mInSocket.getOutputStream());
            this.mClientHttpInReqHeader = (HttpRequestHeader)this.mClientHttpIn.readHeader();
            this.afterRequestHeaderRead(this.mClientHttpInReqHeader);
            if (this.mClientHttpInReqHeader.getMethod().equalsIgnoreCase("CONNECT")) {
                this.mClientHttpOut.write(CONNECT_HTTP_200);
                this.processViaTunnel();
            } else if (this.isTrapEnabled() || this.mClientHttpInReqHeader.isHttp10()) {
                this.processDirectHttp10();
            } else {
                this.processDirectHttp11();
            }
        }
        catch (HttpMalformedHeaderException e) {
            try {
                HttpResponseHeader errResponse = HttpResponseHeader.getError("HTTP/1.0 400 Bad request\r\n\r\n");
                this.mClientHttpOut.write(errResponse);
                this.mClientHttpOut.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.showErrMessage("Malformed HTTP header from client.");
        }
        catch (IOException ioe) {
            this.showErrMessage("Error: " + ioe.getMessage() + ". connection closed");
        }
        catch (Exception e) {
            this.showErrMessage("Error: " + e.getMessage());
        }
    }

    private synchronized void processAdmin() throws Exception {
        String LOCALHOST = "127.0.0.1";
        if (!Global.adminServer.isAccessAllowed(this.mInSocket) || !this.httpsFlag) {
            this.disconnect();
            return;
        }
        this.mClientHttpInReqHeader.setHostName(LOCALHOST);
        this.mClientHttpInReqHeader.setHeader("Host", String.valueOf(LOCALHOST) + ":" + this.mClientHttpInReqHeader.getHostPort());
        this.mClientHttpInReqHeader.setHeader(Global.adminServer.getAuthCode(), "paros");
        Global.parosFrame.setPanel(this.mClientHttpInReqHeader, this.mClientHttpInReqBody, this.mClientHttpInReqHeader.getURI(), true);
        this.mClientHttpInReqHeader.setContentLength(this.mClientHttpInReqBody.length());
        try {
            this.mOutSocket = Util.connect(LOCALHOST, this.mClientHttpInReqHeader.getHostPort(), true);
            this.mHostHttpIn = new HttpInputStream(this.mOutSocket.getInputStream());
            this.mHostHttpOut = new HttpOutputStream(this.mOutSocket.getOutputStream());
        }
        catch (IOException ioe) {
            System.out.println("Error: " + ioe.getMessage());
            this.disconnect();
            return;
        }
        this.mClientHttpInReqHeader.setAbsoluteUriRequired(this.isUseAbsoluteUri(this.mClientHttpInReqHeader.getHostName()));
        this.mHostHttpOut.write(this.mClientHttpInReqHeader);
        this.mHostHttpOut.write(this.mClientHttpInReqBody);
        Thread.yield();
        this.mHostHttpInResBody = null;
        this.mHostHttpInResHeader = (HttpResponseHeader)this.mHostHttpIn.readHeader();
        this.mHostHttpInResBody = this.mHostHttpIn.readBody();
        Global.parosFrame.setPanel(this.mHostHttpInResHeader, this.mHostHttpInResBody, " " + this.mClientHttpInReqHeader.getURI(), false);
        this.mHostHttpInResHeader.setContentLength(this.mHostHttpInResBody.length());
        if (this.mHostHttpInResHeader != null) {
            this.mClientHttpOut.write(this.mHostHttpInResHeader);
        }
        if (this.mHostHttpInResBody != null) {
            this.mClientHttpOut.write(this.mHostHttpInResBody);
        }
        this.notifyWrittenToTunnel();
    }

    private void processDirectHttp10() throws Exception {
        long sendTime = 0L;
        long diffTime = 0L;
        String statusLog = "";
        String diffTimeString = "";
        this.mPool = new HttpConnectionPool(Global.config, Global.ssl);
        ConnectionQueueEntry queueEntry = null;
        this.mClientHttpInReqHeader.setHeader("Connection", "Close");
        this.mClientHttpInReqHeader.setHeader("Proxy-Connection", "Close");
        this.mClientHttpInReqBody = this.mClientHttpIn.readBody();
        this.afterRequestBodyRead(this.mClientHttpInReqHeader, this.mClientHttpInReqBody);
        if (this.mClientHttpInReqHeader.isHttp11()) {
            this.mClientHttpInReqHeader.setVersion("HTTP/1.0");
        }
        if (Global.isRunAdminServer && this.mClientHttpInReqHeader.getHostPort() == AdminServer.ADMIN_SERVER_PORT && this.mClientHttpInReqHeader.getHostName().equalsIgnoreCase("paros")) {
            this.processAdmin();
            return;
        }
        this.mClientHttpInReqHeader.setAbsoluteUriRequired(this.isUseAbsoluteUri(this.mClientHttpInReqHeader.getHostName()));
        Global.filterManager.process(this.mClientHttpInReqHeader, this.mClientHttpInReqBody);
        Global.parosFrame.setPanel(this.mClientHttpInReqHeader, this.mClientHttpInReqBody, this.mClientHttpInReqHeader.getURI(), true);
        this.mClientHttpInReqHeader.setContentLength(this.mClientHttpInReqBody.length());
        Global.treePanel.setTree(this.mClientHttpInReqHeader, this.mClientHttpInReqBody);
        this.connectHost(this.mClientHttpInReqHeader);
        this.modifyHeaders(this.mClientHttpInReqHeader);
        this.mHostHttpOut.write(this.mClientHttpInReqHeader);
        this.mHostHttpOut.write(this.mClientHttpInReqBody);
        queueEntry = new ConnectionQueueEntry(this.mConn);
        queueEntry.setRequest(this.mClientHttpInReqHeader, this.mClientHttpInReqBody, counter.getNextSerial());
        this.processRequestLog(queueEntry);
        sendTime = System.currentTimeMillis();
        Thread.yield();
        this.mHostHttpInResBody = null;
        this.mHostHttpInResHeader = (HttpResponseHeader)this.mHostHttpIn.readHeader();
        this.beforeResponseHeaderWrite(this.mHostHttpInResHeader);
        if (!this.mClientHttpInReqHeader.isImage() && (this.mHostHttpInResHeader.isText() || !this.mHostHttpInResHeader.isText() && this.mHostHttpInResHeader.getContentLength() < 512000)) {
            this.mHostHttpInResBody = this.mHostHttpIn.readBody();
            Global.filterManager.process(this.mHostHttpInResHeader, this.mHostHttpInResBody);
            Global.parosFrame.setPanel(this.mHostHttpInResHeader, this.mHostHttpInResBody, String.valueOf(diffTimeString) + " " + this.mClientHttpInReqHeader.getURI(), false);
            this.mHostHttpInResHeader.setContentLength(this.mHostHttpInResBody.length());
            this.mClientHttpOut.write(this.mHostHttpInResHeader);
            this.mClientHttpOut.write(this.mHostHttpInResBody);
        } else if (!this.mHostHttpInResHeader.isText() && !this.mClientHttpInReqHeader.isImage()) {
            this.mHostHttpInResBody = new HttpBody("");
            Global.parosFrame.setPanel(this.mHostHttpInResHeader, null, String.valueOf(diffTimeString) + " " + this.mClientHttpInReqHeader.getURI(), false);
            this.mClientHttpOut.write(this.mHostHttpInResHeader);
            this.mHostHttpIn.pipeBody(this.mClientHttpOut);
        } else {
            this.mClientHttpOut.write(this.mHostHttpInResHeader);
            this.mHostHttpInResBody = this.mHostHttpIn.pipeBody(this.mClientHttpOut, true);
        }
        diffTime = System.currentTimeMillis() - sendTime;
        this.writeOutputLog(queueEntry.mCount, this.mClientHttpInReqHeader, this.mHostHttpInResHeader, diffTime);
        this.notifyWrittenToTunnel();
        this.writeResponseLog(queueEntry.mCount, this.mHostHttpInResHeader, this.mHostHttpInResBody);
    }

    private void processViaTunnel() {
        int len = 0;
        byte[] buf = new byte[4096];
        boolean isError = false;
        long startTime = System.currentTimeMillis();
        this.setDisconnect(false);
        try {
            Vector vector = tunnelProcessList;
            synchronized (vector) {
                this.mOutSocket = new Socket(Global.config.getProxyIP(), Global.config.getProxyPortSSL());
                this.mOutSocket.setTcpNoDelay(true);
                tunnelProcessList.add(this);
                this.tunnel_out = new BufferedOutputStream(this.mOutSocket.getOutputStream());
                this.tunnel_in = new BufferedInputStream(this.mOutSocket.getInputStream());
            }
        }
        catch (Exception e) {
            this.showErrMessage("Error connecting to internal SSL proxy.");
            isError = true;
        }
        try {
            while (!isError) {
                int i22 = 0;
                while (i22 < 2 && this.mClientHttpIn.available() > 0) {
                    len = this.mClientHttpIn.read(buf);
                    if (len > -1) {
                        this.tunnel_out.write(buf, 0, len);
                        this.tunnel_out.flush();
                        startTime = System.currentTimeMillis();
                    }
                    ++i22;
                }
                Thread.yield();
                ProxyHandler i22 = this;
                synchronized (i22) {
                    try {
                        if (this.tunnel_in.available() == 0) {
                            this.wait(30L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int i = 0;
                    while (i < 5 && this.tunnel_in.available() > 0) {
                        len = this.tunnel_in.read(buf);
                        if (len > -1) {
                            this.mClientHttpOut.write(buf, 0, len);
                            this.mClientHttpOut.flush();
                            startTime = System.currentTimeMillis();
                        }
                        ++i;
                    }
                    if (this.tunnel_in.available() == 0) {
                        this.setTunnelInputBufferEmpty(true);
                    }
                }
                if ((!this.isDisconnect() || !this.isTunnelInputBufferEmpty()) && System.currentTimeMillis() - startTime < 60000L) continue;
                break;
            }
        }
        catch (Exception e) {
            this.showErrMessage("Error in tunnel: " + e.getMessage());
        }
        this.removeFromList();
        Util.closeInputStream(this.tunnel_in);
        Util.closeOutputStream(this.tunnel_out);
    }

    protected void afterRequestHeaderRead(HttpRequestHeader req) {
        req.setSecure(false);
        this.mHostName = req.getHostName();
        this.mHostPort = req.getHostPort();
    }

    protected void afterRequestBodyRead(HttpRequestHeader req, HttpBody body) {
    }

    protected void beforeResponseHeaderWrite(HttpResponseHeader res) {
    }

    protected boolean isUseAbsoluteUri(String hostName) {
        boolean isSecure = false;
        if (this instanceof SSLProxyHandler) {
            isSecure = true;
        }
        return !isSecure && Util.checkAndUseProxy(hostName);
    }

    private void connectHost(HttpRequestHeader req) throws IOException {
        this.mConn = this.mPool.connect(req.getHostName(), req.getHostPort(), req.getSecure(), Global.isUseClientCert);
        this.mOutSocket = this.mConn.mSocket;
        this.mHostHttpIn = this.mConn.mHttpIn;
        this.mHostHttpOut = this.mConn.mHttpOut;
    }

    protected void removeFromList() {
        Vector vector = tunnelProcessList;
        synchronized (vector) {
            tunnelProcessList.remove(this);
        }
    }

    protected synchronized boolean isDisconnect() {
        return this.disconnect;
    }

    protected synchronized void setDisconnect(boolean flag) {
        this.disconnect = flag;
    }

    protected synchronized void disconnect() {
        if (this.mPool != null) {
            this.mPool.close();
        }
        try {
            if (this.mClientHttpIn != null) {
                this.mClientHttpIn.close();
            }
            if (this.mClientHttpOut != null) {
                this.mClientHttpOut.close();
            }
            if (this.mHostHttpIn != null) {
                this.mHostHttpIn.close();
            }
            if (this.mHostHttpOut != null) {
                this.mHostHttpOut.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mClientHttpIn = null;
        this.mClientHttpOut = null;
        this.mHostHttpIn = null;
        this.mHostHttpOut = null;
        Util.closeSocket(this.mInSocket);
        Util.closeSocket(this.mOutSocket);
        this.mOriginHandler = null;
    }

    protected synchronized void setTunnelInputBufferEmpty(boolean bufferEmpty) {
        this.isTunnelInputBufferEmpty = bufferEmpty;
    }

    protected synchronized boolean isTunnelInputBufferEmpty() {
        try {
            if (this.tunnel_in.available() > 0) {
                this.setTunnelInputBufferEmpty(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isTunnelInputBufferEmpty;
    }

    protected static ProxyHandler getOriginatingTunnelProcess(int remotePortUsing) {
        ProxyHandler temp = null;
        Vector vector = tunnelProcessList;
        synchronized (vector) {
            int i = 0;
            while (i < tunnelProcessList.size()) {
                temp = (ProxyHandler)tunnelProcessList.elementAt(i);
                if (temp.mOutSocket.getLocalPort() == remotePortUsing) {
                    return temp;
                }
                ++i;
            }
        }
        return null;
    }

    private void writeRequestLog(int count, HttpRequestHeader reqh, HttpBody reqBody) {
        StringBuffer sb = new StringBuffer(1024);
        if (reqh == null || reqh.isImage() && !Global.isViewImage) {
            return;
        }
        sb.append(reqh.toString());
        if (reqBody != null) {
            sb.append(reqBody.toString());
        }
        if (Global.isDumpLog) {
            if (reqBody != null) {
                Global.dumpLog.log(Dump.REQUEST_FILE, count, reqh.toString(), reqBody.toString());
            } else {
                Global.dumpLog.log(Dump.REQUEST_FILE, count, reqh.toString(), null);
            }
        } else {
            Global.parosFrame.logAppend("Requests", this.getLogSeparator(count));
            Global.parosFrame.logAppend("Requests", String.valueOf(sb.toString()) + "\r\n");
        }
    }

    private void writeResponseLog(int count, HttpResponseHeader resh, HttpBody resBody) {
        if (resh == null || resh.isImage() && !Global.isViewImage) {
            return;
        }
        StringBuffer sb = new StringBuffer(1024);
        sb.append(resh.toString());
        if (resBody != null) {
            sb.append(resBody.toString());
        }
        if (Global.isDumpLog) {
            if (resBody != null) {
                Global.dumpLog.log(Dump.RESPONSE_FILE, count, resh.toString(), resBody.toString());
            } else {
                Global.dumpLog.log(Dump.RESPONSE_FILE, count, resh.toString(), null);
            }
        } else {
            Global.parosFrame.logAppend("Responses", this.getLogSeparator(count));
            Global.parosFrame.logAppend("Responses", String.valueOf(sb.toString()) + "\r\n");
        }
    }

    protected String getLogSeparator(int id) {
        return "\r\n****************** " + id + " ******************\r\n";
    }

    protected void showErrMessage(String errMsg) {
        System.out.println(errMsg);
    }

    private void modifyUserAgent(HttpRequestHeader req) {
        if (!Global.isModifyUserAgent) {
            return;
        }
        String userAgent = req.getHeader("User-Agent");
        if (userAgent == null) {
            userAgent = "";
        }
        String delimiter = "";
        if (!userAgent.equals("") && !userAgent.endsWith(" ")) {
            delimiter = " ";
        }
        userAgent = String.valueOf(userAgent) + delimiter + "Paros" + "/" + "3.1.1";
        req.setHeader("User-Agent", userAgent);
    }

    private void processDirectHttp11() throws Exception {
        Vector<ConnectionQueueEntry> queue = new Vector<ConnectionQueueEntry>();
        boolean isFirstRequest = true;
        boolean isHostCloseRequired = false;
        boolean isExit = false;
        ConnectionQueueEntry queueEntry = null;
        this.mPool = new HttpConnectionPool(Global.config, Global.ssl);
        this.mClientHttpIn.setSocket(this.mInSocket);
        while (true) {
            if (isFirstRequest || this.mClientHttpIn.available() > 0) {
                if (!isFirstRequest) {
                    this.mClientHttpInReqHeader = (HttpRequestHeader)this.mClientHttpIn.readHeader();
                    this.afterRequestHeaderRead(this.mClientHttpInReqHeader);
                }
                isFirstRequest = false;
                this.mClientHttpInReqBody = this.mClientHttpIn.readBody();
                if (Global.isRunAdminServer && this.mClientHttpInReqHeader.getHostPort() == AdminServer.ADMIN_SERVER_PORT && this.mClientHttpInReqHeader.getHostName().equalsIgnoreCase("paros")) {
                    this.processAdmin();
                    return;
                }
                Global.filterManager.process(this.mClientHttpInReqHeader, this.mClientHttpInReqBody);
                this.connectHost(this.mClientHttpInReqHeader);
                this.modifyHeaders(this.mClientHttpInReqHeader);
                Global.treePanel.setTree(this.mClientHttpInReqHeader, this.mClientHttpInReqBody);
                this.mHostHttpOut.write(this.mClientHttpInReqHeader);
                this.mHostHttpOut.write(this.mClientHttpInReqBody);
                queueEntry = new ConnectionQueueEntry(this.mConn);
                queueEntry.setRequest(this.mClientHttpInReqHeader, this.mClientHttpInReqBody, counter.getNextSerial());
                this.processRequestLog(queueEntry);
                queue.add(queueEntry);
                this.count = queueEntry.mCount;
                continue;
            }
            Thread.yield();
            if (!queue.isEmpty()) {
                queueEntry = (ConnectionQueueEntry)queue.firstElement();
                this.mConn = queueEntry.conn;
                if (this.mConn.mHttpIn.available() > 0) {
                    this.mOutSocket = this.mConn.mSocket;
                    this.mHostHttpIn = this.mConn.mHttpIn;
                    this.mHostHttpInResHeader = (HttpResponseHeader)this.mHostHttpIn.readHeader();
                    this.mHostHttpInResBody = this.mHostHttpIn.readBody();
                    Global.filterManager.process(this.mHostHttpInResHeader, this.mHostHttpInResBody);
                    this.processResponseLog(queueEntry);
                    if (this.mHostHttpInResHeader.isConnectionClose()) {
                        isHostCloseRequired = true;
                        this.mConn.close();
                    }
                    this.mClientHttpOut.write(this.mHostHttpInResHeader);
                    this.mClientHttpOut.write(this.mHostHttpInResBody);
                    this.notifyWrittenToTunnel();
                    if (this.mClientHttpInReqHeader.isConnectionClose()) break;
                    if (this.mHostHttpInResHeader.getStatusCode() != 100) {
                        queue.remove(queueEntry);
                    }
                }
            }
            if ((queue.size() <= 0 || this.mPool.available() <= 0) && this.mClientHttpIn.available() <= 0) {
                if (queue.size() == 0 && isHostCloseRequired) break;
                Util.sleep(20);
                if (queue.size() == 0 && this.mClientHttpIn.available() == 0 && this.timeDiffMillis() > 1000L) break;
            }
            if (this.timeDiffMillis() >= 45000L || this.isTrapEnabled()) break;
        }
    }

    private void modifyHeaders(HttpRequestHeader req) {
        boolean useAbsoluteUri = this.isUseAbsoluteUri(req.getHostName());
        req.setAbsoluteUriRequired(useAbsoluteUri);
        this.modifyUserAgent(req);
        req.setHeader("Accept-Encoding", null);
    }

    private long timeDiffMillis() {
        return System.currentTimeMillis() - this.mPool.lastActiveTimeMillis();
    }

    private boolean isTrapEnabled() {
        boolean isEnabled = Global.trapPanel.isTrapRequest() || Global.trapPanel.isTrapResponse();
        return isEnabled;
    }

    private void processRequestLog(ConnectionQueueEntry entry) {
        if (entry.mReqHeader.isImage() && !Global.isViewImage) {
            return;
        }
        String statusLog = entry.mReqHeader.getPrimeHeader();
        Global.parosFrame.setStatus(statusLog);
        this.writeRequestLog(entry.mCount, entry.mReqHeader, entry.mReqBody);
    }

    private void processResponseLog(ConnectionQueueEntry entry) {
        Object statusLog = null;
        if (entry.mReqHeader.isImage()) {
            counter.waitForTurn(entry.mCount, 1);
        } else {
            counter.waitForTurn(entry.mCount, 2000);
        }
        this.writeOutputLog(entry.mCount, entry.mReqHeader, this.mHostHttpInResHeader, System.currentTimeMillis() - entry.mTimeMillis);
        this.writeResponseLog(entry.mCount, this.mHostHttpInResHeader, this.mHostHttpInResBody);
        counter.setTurn(entry.mCount);
    }

    private void notifyWrittenToTunnel() {
        ProxyHandler proxyHandler = this.mOriginHandler;
        synchronized (proxyHandler) {
            this.mOriginHandler.setTunnelInputBufferEmpty(false);
            this.mOriginHandler.notify();
        }
    }

    private void writeOutputLog(int counter, HttpRequestHeader reqHeader, HttpResponseHeader resHeader, long diffTimeMillis) {
        Global.parosFrame.setStatus(" ");
        if ((reqHeader.isImage() || resHeader.isImage()) && !Global.isViewImage) {
            return;
        }
        StringBuffer sb = new StringBuffer(String.valueOf(counter) + ": " + reqHeader.getPrimeHeader() + "\t=> ");
        sb.append(resHeader.getPrimeHeader());
        String diffTimeString = " [" + decimalFormat.format((double)diffTimeMillis / 1000.0) + " s]";
        sb.append(diffTimeString);
        Global.parosFrame.logAppend("URLs", sb.toString());
    }
}

