/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.log;

import com.proofsecure.paros.ui.ParosSplitPane;
import com.proofsecure.paros.ui.PopupPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class DumpRequestPanel
extends JPanel {
    private static final String TRAPVIEW_TABULAR = "Tabular View";
    private static final String TRAPVIEW_ORIGINAL = "Original View";
    private Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Matcher matcher2;
    private boolean isContinue = false;
    private JSplitPane jSplitPane5 = new JSplitPane();
    private ParosSplitPane jSplitPane4 = new ParosSplitPane();
    private JScrollPane jScrollPane4 = new JScrollPane();
    private JScrollPane jScrollPane5 = new JScrollPane();
    private JPanel jPanel4 = new JPanel();
    private JTextArea txtHeader = new JTextArea();
    JTextArea txtBody = new JTextArea();
    private JTable jTable2 = new JTable();
    private JScrollPane jScrollPane8 = new JScrollPane();
    private JScrollPane jScrollPane9 = new JScrollPane();
    private Box box1;
    private JButton jButton4 = new JButton();
    private JLabel jLabel9 = new JLabel();
    private JLabel jLabel10 = new JLabel();
    private JCheckBox TrapReq = new JCheckBox();
    private JCheckBox TrapResp = new JCheckBox();
    private JLabel jLabel11 = new JLabel();
    private JButton TrapView = new JButton();

    DumpRequestPanel() {
        this.init();
    }

    private void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.box1 = Box.createHorizontalBox();
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.activeCaptionBorder);
        this.jPanel4.setLayout(new BorderLayout());
        this.jSplitPane4.setOrientation(0);
        this.jSplitPane4.setDividerSize(3);
        this.jScrollPane8.getViewport().add((Component)this.jTable2, null);
        this.jSplitPane5.add((Component)this.jPanel4, "left");
        this.jSplitPane5.add((Component)this.jScrollPane8, "right");
        this.jSplitPane5.setDividerSize(0);
        this.add((Component)this.jSplitPane5, "Center");
        this.add((Component)this.jScrollPane9, "South");
        this.jLabel9.setText("  ");
        this.jLabel10.setText("        ");
        this.TrapReq.setText("Trap Request");
        this.TrapResp.setText("Trap Response");
        this.jLabel11.setText("   ");
        this.TrapView.setText(TRAPVIEW_TABULAR);
        this.TrapView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DumpRequestPanel.this.TrapView_actionPerformed(e);
            }
        });
        this.jScrollPane9.setVerticalScrollBarPolicy(21);
        this.jScrollPane9.setHorizontalScrollBarPolicy(31);
        this.jScrollPane9.getViewport().add((Component)this.box1, null);
        this.jButton4.setText("Continue");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DumpRequestPanel.this.jButton4_actionPerformed(e);
            }
        });
        this.box1.add((Component)this.jButton4, null);
        this.box1.add((Component)this.jLabel9, null);
        this.box1.add((Component)this.TrapView, null);
        this.jPanel4.add((Component)this.jSplitPane4.getJSplitPaneHeader(), "West");
        this.jPanel4.add((Component)this.jSplitPane4, "Center");
        this.jSplitPane4.add((Component)this.jScrollPane4, "top");
        this.jSplitPane4.add((Component)this.jScrollPane5, "bottom");
        this.txtHeader.setLineWrap(true);
        this.txtBody.setLineWrap(true);
        this.jScrollPane5.getViewport().add((Component)this.txtBody, null);
        this.jScrollPane4.getViewport().add((Component)this.txtHeader, null);
        this.jScrollPane8.setVisible(false);
        this.txtHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    PopupPanel pp = new PopupPanel(DumpRequestPanel.this.txtHeader);
                    pp.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else {
                    super.mousePressed(e);
                }
            }
        });
        this.txtBody.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    PopupPanel pp = new PopupPanel(DumpRequestPanel.this.txtBody);
                    pp.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else {
                    super.mousePressed(e);
                }
            }
        });
    }

    public boolean isContinue() {
        return this.isContinue;
    }

    public void setContinue(boolean s) {
        this.isContinue = s;
    }

    public boolean isTrapRequest() {
        return this.TrapReq.isSelected();
    }

    public boolean isTrapResponse() {
        return this.TrapResp.isSelected();
    }

    public String getHeader() {
        String result = this.txtHeader.getText().replaceAll("\\n", "\r\n");
        result = String.valueOf(result.replaceAll("(\\r\\n)*\\z", "")) + "\r\n\r\n";
        return result;
    }

    public String getBody() {
        return this.txtBody.getText();
    }

    public void setMessage(final String header, final String body) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DumpRequestPanel.this.txtHeader.setText(header.replaceAll("\\r\\n", "\n"));
                DumpRequestPanel.this.txtHeader.setCaretPosition(0);
                if (body == null) {
                    DumpRequestPanel.this.txtBody.setEnabled(false);
                } else {
                    DumpRequestPanel.this.txtBody.setEnabled(true);
                    DumpRequestPanel.this.txtBody.setText(body);
                    DumpRequestPanel.this.txtBody.setCaretPosition(0);
                }
            }
        });
    }

    void jButton4_actionPerformed(ActionEvent e) {
        this.isContinue = true;
    }

    void TrapView_actionPerformed(ActionEvent e) {
    }
}

