/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.network;

import com.proofsecure.paros.network.HttpConnectionPool;
import com.proofsecure.paros.network.HttpInputStream;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpUtil;
import java.io.IOException;
import java.net.Socket;

public class HttpConnection {
    public String mHostName = "";
    public int mPort = 80;
    public boolean mIsSecure = false;
    public HttpInputStream mHttpIn = null;
    public HttpOutputStream mHttpOut = null;
    public Socket mSocket = null;
    public HttpConnectionPool mPool = null;
    private boolean mIsClosed = false;

    HttpConnection(String hostName, int port, boolean isSecure, Socket socket, HttpConnectionPool pool) throws IOException {
        this.mHostName = hostName;
        this.mPort = port;
        this.mIsSecure = isSecure;
        this.mPool = pool;
        this.setSocket(socket);
    }

    void setSocket(Socket socket) throws IOException {
        this.mSocket = socket;
        this.mHttpIn = new HttpInputStream(this, this.mPool);
        this.mHttpOut = new HttpOutputStream(this, this.mPool);
        this.mIsClosed = this.mSocket.isClosed();
    }

    public void close() {
        this.mIsClosed = true;
        this.mHttpIn.close();
        this.mHttpOut.close();
        HttpUtil.close(this.mSocket);
    }

    public boolean isClosed() {
        if (!this.mIsClosed) {
            this.mIsClosed = this.mSocket.isClosed();
        }
        return this.mIsClosed;
    }
}

