/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.network;

import com.proofsecure.paros.network.ConnectorConfig;
import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.LastActiveAdapter;
import com.proofsecure.paros.network.SSLConnector;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

public class HttpConnectionPool
implements LastActiveAdapter {
    private static final int IDLE_CONNECTION_TIMEOUT_SEC = 30;
    private Vector mPool = new Vector();
    private String mHostName = "";
    private int mHostPort = 80;
    private boolean mIsSecure = false;
    private long mLastActiveTime = System.currentTimeMillis();
    private SSLConnector mSSL = null;
    private ConnectorConfig mConfig = null;

    public HttpConnectionPool(ConnectorConfig config, SSLConnector ssl) {
        this.mConfig = config;
        this.mSSL = ssl;
    }

    protected void finalize() {
        this.close();
    }

    public synchronized HttpConnection connect(String hostName, int port, boolean isSecure, boolean isUseClientCert) throws IOException {
        HttpConnection conn = null;
        this.removeClosedSocket();
        int i = 0;
        while (i < this.mPool.size()) {
            conn = (HttpConnection)this.mPool.elementAt(i);
            if (hostName.equalsIgnoreCase(conn.mHostName) && port == conn.mPort && isSecure == conn.mIsSecure && !conn.isClosed()) {
                return conn;
            }
            ++i;
        }
        conn = this.createConnection(hostName, port, isSecure, isUseClientCert);
        this.mPool.add(conn);
        return conn;
    }

    private HttpConnection createConnection(String hostName, int hostPort, boolean isSecure, boolean isUseClientCert) throws IOException {
        Socket socket = null;
        if (isSecure) {
            if (this.checkAndUseProxy(hostName)) {
                try {
                    socket = this.mSSL.clientViaProxy(hostName, hostPort, this.mConfig.getProxyChainName(), this.mConfig.getProxyChainPort(), isUseClientCert);
                }
                catch (SocketException e) {
                    socket = this.mSSL.client(hostName, hostPort, isUseClientCert);
                }
            } else {
                socket = this.mSSL.client(hostName, hostPort, isUseClientCert);
            }
        } else if (this.checkAndUseProxy(hostName)) {
            try {
                socket = new Socket(this.mConfig.getProxyChainName(), this.mConfig.getProxyChainPort());
            }
            catch (SocketException e) {
                socket = new Socket(hostName, hostPort);
            }
        } else {
            socket = new Socket(hostName, hostPort);
        }
        socket.setTcpNoDelay(true);
        this.setLastActive();
        HttpConnection conn = new HttpConnection(hostName, hostPort, isSecure, socket, this);
        return conn;
    }

    public boolean checkAndUseProxy(String hostName) {
        return this.mConfig.getProxyChainName() != null && !this.mConfig.getProxyChainName().equals("") && !this.mConfig.isSkipProxyChain(hostName);
    }

    public int available() {
        this.removeClosedSocket();
        int i = 0;
        while (i < this.mPool.size()) {
            HttpConnection conn = (HttpConnection)this.mPool.elementAt(i);
            int avail = 0;
            try {
                avail = conn.mHttpIn.available();
            }
            catch (Exception e) {
                conn.close();
            }
            if (avail > 0) {
                return avail;
            }
            ++i;
        }
        return 0;
    }

    private synchronized void removeClosedSocket() {
        HttpConnection conn = null;
        int i = 0;
        while (i < this.mPool.size()) {
            conn = (HttpConnection)this.mPool.elementAt(i);
            if (conn.isClosed()) {
                this.mPool.remove(i);
                continue;
            }
            ++i;
        }
    }

    public synchronized boolean isClosed() {
        this.removeClosedSocket();
        return this.mPool.isEmpty();
    }

    public synchronized void close() {
        HttpConnection conn = null;
        while (!this.mPool.isEmpty()) {
            conn = (HttpConnection)this.mPool.firstElement();
            conn.close();
            this.mPool.remove(conn);
        }
    }

    public long lastActiveTimeMillis() {
        return this.mLastActiveTime;
    }

    public void setLastActive() {
        this.mLastActiveTime = System.currentTimeMillis();
    }
}

