/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.network;

import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class HttpHeader
implements Serializable {
    public static final String CRLF = "\r\n";
    public static final String LF = "\n";
    public static final String CONTENT_LENGTH = "Content-length";
    public static final String TRANSFER_ENCODING = "Transfer-encoding";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String PROXY_CONNECTION = "Proxy-Connection";
    public static final String PROXY_AUTHENTICATE = "Proxy-authenticate";
    public static final String CONNECTION = "Connection";
    public static final String AUTHORIZATION = "Authorization";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String LOCATION = "Location";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String USER_AGENT = "User-Agent";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CACHE_CONTROL = "Cache-control";
    public static final String PRAGMA = "Pragma";
    public static final String VERSION_HTTP10 = "HTTP/1.0";
    public static final String VERSION_HTTP11 = "HTTP/1.1";
    public static final String _CLOSE = "Close";
    public static final String _KEEP_ALIVE = "Keep-alive";
    public static final String _CHUNKED = "Chunked";
    public static final String SCHEME_HTTP = "http://";
    public static final String SCHEME_HTTPS = "https://";
    public static Pattern patternCRLF = Pattern.compile("\\r\\n", 8);
    public static Pattern patternLF = Pattern.compile("\\n", 8);
    protected static final String p_TEXT = "[^\\x00-\\x1f\\r\\n]*";
    protected static final String p_METHOD = "(\\w+)";
    protected static final String p_SP = " +";
    protected static final String p_URI = "(\\S+)";
    protected static final String p_VERSION = "(HTTP/\\d+\\.\\d+)";
    protected static final String p_STATUS_CODE = "(\\d{3})";
    protected static final String p_REASON_PHRASE = "([^\\x00-\\x1f\\r\\n]*)";
    protected String mStartLine = "";
    protected String mMsgHeader = "";
    protected boolean mMalformedHeader = false;
    protected Hashtable mHeaderFields = new Hashtable();
    protected String[] primeHeader = new String[]{"", "", ""};
    protected int content_length = -1;
    protected boolean isAbsoluteUriRequired = false;
    protected String mLineDelimiter = "\r\n";
    protected String mVersion = "";

    public HttpHeader() {
        this.init();
    }

    public static HttpHeader getInstance(String data) throws HttpMalformedHeaderException {
        if (HttpResponseHeader.isStatusLine(data)) {
            return new HttpResponseHeader(data);
        }
        if (HttpRequestHeader.isRequestLine(data)) {
            return new HttpRequestHeader(data);
        }
        throw new HttpMalformedHeaderException("Invalid header:\r\n" + data);
    }

    public HttpHeader(String data) throws HttpMalformedHeaderException {
        this();
        this.setMessage(data);
    }

    public String getMessage() {
        return this.mMsgHeader;
    }

    private void init() {
        this.mHeaderFields = new Hashtable();
        this.mStartLine = "";
        this.mMsgHeader = "";
        this.mMalformedHeader = false;
        this.content_length = -1;
        this.mLineDelimiter = CRLF;
    }

    public void setMessage(String data) throws HttpMalformedHeaderException {
        this.init();
        this.mMsgHeader = data;
        try {
            if (!this.parseHeader(data)) {
                this.mMalformedHeader = true;
            }
        }
        catch (Exception e) {
            this.mMalformedHeader = true;
        }
        if (this.mMalformedHeader) {
            throw new HttpMalformedHeaderException();
        }
    }

    public String getHeader(String name) {
        Vector v = this.getHeaders(name);
        if (v == null) {
            return null;
        }
        return (String)v.firstElement();
    }

    public Vector getHeaders(String name) {
        Vector v = (Vector)this.mHeaderFields.get(name.toUpperCase());
        return v;
    }

    public String getDelimiter() {
        return this.mLineDelimiter;
    }

    public void addHeader(String name, String val) {
        this.mMsgHeader = String.valueOf(this.mMsgHeader) + name + ": " + val + this.mLineDelimiter;
        this.setInternalHeaderFields(name, val);
    }

    public void setHeader(String name, String value) {
        boolean pos = false;
        boolean crlfpos = false;
        Object sb = null;
        Pattern pattern = null;
        if (this.getHeaders(name) == null && value != null) {
            this.addHeader(name, value);
        } else {
            try {
                pattern = this.getHeaderRegex(name);
                Matcher matcher = pattern.matcher(this.mMsgHeader);
                if (value == null) {
                    this.mMsgHeader = matcher.replaceAll("");
                } else {
                    String newString = String.valueOf(name) + ": " + value + this.mLineDelimiter;
                    this.mMsgHeader = matcher.replaceAll(newString);
                }
                this.setInternalHeaderFields(name, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Pattern getHeaderRegex(String name) throws PatternSyntaxException {
        return Pattern.compile("^ *" + name + " *: *[^\\r\\n]*" + this.mLineDelimiter, 10);
    }

    public String getVersion() {
        return this.mVersion;
    }

    public abstract void setVersion(String var1);

    public int getContentLength() {
        return this.content_length;
    }

    public void setContentLength(int len) {
        if (this.content_length != len) {
            this.setHeader(CONTENT_LENGTH, Integer.toString(len));
            this.content_length = len;
        }
    }

    public boolean isConnectionClose() {
        boolean result = true;
        if (this.mMalformedHeader) {
            return true;
        }
        if (this.isHttp10()) {
            result = true;
            try {
                if (this.getHeader(CONNECTION).equalsIgnoreCase(_KEEP_ALIVE) || this.getHeader(PROXY_CONNECTION).equalsIgnoreCase(_KEEP_ALIVE)) {
                    return false;
                }
            }
            catch (NullPointerException e) {}
        } else if (this.isHttp11()) {
            result = false;
            try {
                if (this.getHeader(CONNECTION).equalsIgnoreCase(_CLOSE)) {
                    return true;
                }
                if (this.getHeader(PROXY_CONNECTION).equalsIgnoreCase(_CLOSE)) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isHttp10() {
        return this.mVersion.equals(VERSION_HTTP10);
    }

    public boolean isHttp11() {
        return this.mVersion.equals(VERSION_HTTP11);
    }

    public boolean isTransferEncodingChunked() {
        String transferEncoding = this.getHeader(TRANSFER_ENCODING);
        return transferEncoding != null && transferEncoding.equalsIgnoreCase(_CHUNKED);
    }

    public Hashtable getAllHeaderFields() {
        return this.mHeaderFields;
    }

    public boolean parseHeader(String data) throws Exception {
        Object tokenizer = null;
        String token = null;
        String name = null;
        String value = null;
        int pos = 0;
        Pattern pattern = null;
        if (data == null || data.equals("")) {
            return true;
        }
        pos = data.indexOf(CRLF);
        if (pos < 0) {
            pos = data.indexOf(LF);
            if (pos < 0) {
                return false;
            }
            this.mLineDelimiter = LF;
            pattern = patternLF;
        } else {
            this.mLineDelimiter = CRLF;
            pattern = patternCRLF;
        }
        String[] split = pattern.split(data);
        this.mStartLine = split[0];
        StringBuffer sb = new StringBuffer(2048);
        int i = 1;
        while (i < split.length) {
            token = split[i];
            if (!token.equals("")) {
                pos = token.indexOf(":");
                if (pos < 0) {
                    this.mMalformedHeader = true;
                    return false;
                }
                name = token.substring(0, pos).trim();
                value = token.substring(pos + 1).trim();
                if (name.equalsIgnoreCase(CONTENT_LENGTH)) {
                    try {
                        this.content_length = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!name.equalsIgnoreCase(PROXY_CONNECTION) && !name.equalsIgnoreCase(CONNECTION)) {
                    sb.append(String.valueOf(name) + ": " + value + this.mLineDelimiter);
                }
                this.setInternalHeaderFields(name, value);
            }
            ++i;
        }
        this.mMsgHeader = sb.toString();
        return true;
    }

    private void setInternalHeaderFields(String name, String value) {
        String key = name.toUpperCase();
        Vector<String> v = this.getHeaders(key);
        if (v == null) {
            v = new Vector<String>();
            this.mHeaderFields.put(key, v);
        }
        if (value != null) {
            v.add(value);
        } else {
            this.mHeaderFields.remove(key);
        }
    }

    public boolean isMalformedHeader() {
        return this.mMalformedHeader;
    }

    public String toStringNoAbsoluteUri() {
        return this.toStringAbsoluteUri();
    }

    public String toString() {
        if (this.isAbsoluteUriRequired) {
            return this.toStringAbsoluteUri();
        }
        return this.toStringNoAbsoluteUri();
    }

    public String toStringAbsoluteUri() {
        return String.valueOf(this.getStartLine()) + this.mLineDelimiter + this.mMsgHeader + this.mLineDelimiter;
    }

    public String getPrimeHeader() {
        return this.getStartLine();
    }

    public String getStartLine() {
        return this.mStartLine;
    }

    public boolean isImage() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public void setAbsoluteUriRequired(boolean isRequired) {
        this.isAbsoluteUriRequired = isRequired;
    }

    public static void showDebugMsg(String msg) {
        System.out.println(msg);
    }
}

