/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.network;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.network.HttpUtil;
import com.proofsecure.paros.network.LastActiveAdapter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpInputStream {
    public static final String SIMPLE_RESPONSE_HEADER = "HTTP/1.0 200 OK SIMPLE RESPONSE\r\n\r\n";
    private static final int BUFFER_SIZE = 4096;
    private static final String CRLF = "\r\n";
    private static final String CRLF2 = "\r\n\r\n";
    private static final String LF = "\n";
    private static final String LF2 = "\n\n";
    private static final Pattern patternChunked = Pattern.compile("(\\w+);?\\S*\\s*", 10);
    private HttpHeader mHeader = null;
    private int readBodyLength = 0;
    private byte[] buf = new byte[4096];
    private BufferedInputStream in = null;
    private String simpleResponseBuffer = null;
    private StringBuffer msb = new StringBuffer(1024);
    private long mLastActiveTime = System.currentTimeMillis();
    private LastActiveAdapter mLastActiveAdapter = null;
    private boolean mCloseConnection = true;
    private Socket mSocket = null;

    public HttpInputStream(InputStream in) {
        this.in = new BufferedInputStream(in);
    }

    public HttpInputStream(HttpConnection conn, LastActiveAdapter lastActiveAdapter) throws IOException {
        this(conn.mSocket.getInputStream());
        this.mSocket = conn.mSocket;
        this.mLastActiveAdapter = lastActiveAdapter;
    }

    public void setSocket(Socket socket) {
        this.mSocket = socket;
    }

    /*
     * Exception decompiling
     */
    public int available() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 114->117)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized HttpHeader readHeader() throws HttpMalformedHeaderException, IOException {
        String msg = "";
        int oneByte = -1;
        boolean eoh = false;
        boolean neverReadOnce = true;
        boolean len = false;
        boolean headerCompared = false;
        this.processBeforeReadHeader();
        this.in.mark(256);
        do {
            if ((oneByte = this.in.read()) == -1) {
                eoh = true;
                if (!neverReadOnce) break;
                this.sleep(20);
                continue;
            }
            neverReadOnce = false;
            this.msb.append((char)oneByte);
            if (!headerCompared && this.msb.length() > 7) {
                msg = this.msb.toString();
                headerCompared = true;
                if (!HttpRequestHeader.isRequestLine(msg) && !HttpResponseHeader.isStatusLine(msg)) {
                    eoh = true;
                    this.in.reset();
                    msg = SIMPLE_RESPONSE_HEADER;
                }
            }
            if ((char)oneByte != '\n' || !this.isHeaderEnd(this.msb)) continue;
            eoh = true;
            msg = this.msb.toString();
        } while (!eoh || neverReadOnce);
        this.setLastActive();
        this.mHeader = HttpHeader.getInstance(msg);
        this.processAfterReadHeader();
        return this.mHeader;
    }

    private boolean isHeaderEnd(StringBuffer sb) {
        int len = sb.length();
        if (len > 2 && LF2.equals(sb.substring(len - 2))) {
            return true;
        }
        return len > 4 && CRLF2.equals(sb.substring(len - 4));
    }

    private int readBody(byte[] data) throws IOException {
        int len = 0;
        int remainingLen = 0;
        if (this.mHeader.getContentLength() == -1) {
            len = this.in.read(data);
        } else {
            remainingLen = this.mHeader.getContentLength() - this.readBodyLength;
            if (remainingLen < data.length && remainingLen > 0) {
                len = this.in.read(data, 0, remainingLen);
            } else if (remainingLen > data.length) {
                len = this.in.read(data);
            }
        }
        if (len > 0) {
            this.setLastActive();
            this.readBodyLength += len;
        }
        return len;
    }

    public HttpBody readBody() throws IOException {
        return this.readBody(this.mHeader);
    }

    public HttpBody readBody(HttpHeader hdr) {
        HttpBody body = null;
        if (hdr.isTransferEncodingChunked()) {
            body = this.readBodyChunked(hdr);
        } else {
            body = new HttpBody();
            this.readEntity(hdr.getContentLength(), body, null);
        }
        body.setLength(body.length());
        return body;
    }

    private void processBeforeReadHeader() {
        this.msb.setLength(0);
        this.mCloseConnection = true;
        this.readBodyLength = 0;
    }

    private void processAfterReadHeader() {
    }

    private int readEntity(int expectedLength, HttpBody entityBody, HttpOutputStream out) {
        int len = 0;
        int remainingLength = 0;
        int readEntityLength = 0;
        if (expectedLength == 0) {
            return 0;
        }
        remainingLength = expectedLength - readEntityLength;
        try {
            do {
                len = 0;
                len = expectedLength < 0 || remainingLength > this.buf.length ? this.in.read(this.buf) : this.in.read(this.buf, 0, remainingLength);
                if (len > 0) {
                    this.setLastActive();
                    remainingLength = expectedLength - (readEntityLength += len);
                    if (entityBody != null) {
                        entityBody.append(this.buf, len);
                    }
                    if (out == null) continue;
                    out.write(this.buf, len);
                    out.flush();
                    continue;
                }
                this.sleep(10);
            } while (len != -1 && (expectedLength < 0 || expectedLength > 0 && remainingLength > 0));
        }
        catch (IOException e) {
            this.close();
        }
        return readEntityLength;
    }

    public HttpBody readBodyChunked(HttpHeader hdr) {
        int len = 0;
        int readLen = 0;
        String line = null;
        int chunkSize = 0;
        int readChunkSize = 0;
        HttpBody body = new HttpBody();
        Matcher matcher = null;
        try {
            line = this.readLine();
            matcher = patternChunked.matcher(line);
            matcher.find();
            String result = matcher.group(1);
            chunkSize = Integer.parseInt(result, 16);
            while (chunkSize > 0) {
                readChunkSize = 0;
                while (readChunkSize < chunkSize) {
                    len = this.readEntity(chunkSize - readChunkSize, body, null);
                    readChunkSize += len;
                }
                readLen += chunkSize;
                line = this.readLine();
                line = this.readLine();
                matcher = patternChunked.matcher(line);
                matcher.find();
                chunkSize = Integer.parseInt(matcher.group(1), 16);
            }
            String entityHeaderLine = null;
            while (!(entityHeaderLine = this.readLine()).equals(hdr.getDelimiter())) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        hdr.setHeader("Transfer-encoding", null);
        hdr.setContentLength(readLen);
        body.setLength(body.length());
        return body;
    }

    private String readLine() throws IOException {
        int oneByte = -1;
        boolean eol = false;
        boolean len = false;
        String msg = null;
        this.msb.setLength(0);
        do {
            if ((oneByte = this.in.read()) == -1) {
                eol = true;
            } else {
                this.msb.append((char)oneByte);
            }
            msg = this.msb.toString();
            if (!msg.endsWith(CRLF) && !msg.endsWith(LF)) continue;
            eol = true;
        } while (!eol);
        this.setLastActive();
        return this.msb.toString();
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpUtil.close(this.mSocket);
    }

    public synchronized void pipeBody(HttpOutputStream out) throws IOException {
        this.pipeBody(out, false);
    }

    public synchronized HttpBody pipeBody(HttpOutputStream out, boolean isReturnBody) throws IOException {
        HttpBody body = null;
        if (isReturnBody) {
            body = new HttpBody();
        }
        this.readEntity(this.mHeader.getContentLength(), body, out);
        return body;
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setLastActive() {
        this.mLastActiveTime = System.currentTimeMillis();
        if (this.mLastActiveAdapter != null) {
            this.mLastActiveAdapter.setLastActive();
        }
    }

    long lastActiveTimeMillis() {
        return this.mLastActiveTime;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }
}

