/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.network;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpConnection;
import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpUtil;
import com.proofsecure.paros.network.LastActiveAdapter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

public class HttpOutputStream {
    private static final String CODEPAGE = "8859_1";
    private static final String CRLF2 = "\r\n\r\n";
    private static final String LF2 = "\n\n";
    private BufferedOutputStream out = null;
    private long mLastActiveTime = System.currentTimeMillis();
    private LastActiveAdapter mLastActiveAdapter = null;
    private Socket mSocket = null;
    private boolean mCloseConnection = true;

    public HttpOutputStream(OutputStream out) {
        this.out = new BufferedOutputStream(out);
    }

    public HttpOutputStream(HttpConnection conn, LastActiveAdapter lastActiveAdapter) throws IOException {
        this(conn.mSocket.getOutputStream());
        this.mSocket = conn.mSocket;
        this.mLastActiveAdapter = lastActiveAdapter;
    }

    public void write(HttpHeader header) throws IOException {
        String tmp = header.toString();
        this.out.write(tmp.getBytes(CODEPAGE));
        this.flush();
        this.setLastActive();
        this.processAfterWriteHeader(header);
    }

    public void write(HttpBody body) throws IOException {
        byte[] buf = body.toString().getBytes(CODEPAGE);
        this.write(buf);
        this.processAfterWriteBody();
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int len) throws IOException {
        this.write(buf, 0, len);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        if (len > 0) {
            this.setLastActive();
            this.out.write(buf, off, len);
            this.flush();
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpUtil.close(this.mSocket);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    long lastActiveTimeMillis() {
        return this.mLastActiveTime;
    }

    private void setLastActive() {
        this.mLastActiveTime = System.currentTimeMillis();
        if (this.mLastActiveAdapter != null) {
            this.mLastActiveAdapter.setLastActive();
        }
    }

    private void processAfterWriteHeader(HttpHeader header) {
        this.mCloseConnection = header.isConnectionClose();
    }

    private void processAfterWriteBody() {
    }
}

