/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.scan.AlertItem;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AlertDB {
    private static final String ALERTITEM = "alertitem";
    private static final String ID = "id";
    private static final String ALERT = "alert";
    private static final String DESC = "desc";
    private static final String SOLUTION = "solution";
    private static final String REFERENCE = "reference";
    private static final String[] PATH_ID = new String[]{"alertitem", "id"};
    private static final String[] PATH_ALERT = new String[]{"alertitem", "alert"};
    private static final String[] PATH_DESC = new String[]{"alertitem", "desc"};
    private static final String[] PATH_SOLUTION = new String[]{"alertitem", "solution"};
    private static final String[] PATH_REFERENCE = new String[]{"alertitem", "reference"};
    private Document mDoc = null;
    private DocumentBuilderFactory mFactory = null;
    private DocumentBuilder mBuilder = null;
    private Hashtable mAlertTable = new Hashtable();

    public AlertDB() {
        try {
            this.mFactory = DocumentBuilderFactory.newInstance();
            this.mFactory.setValidating(false);
            this.mBuilder = this.mFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public void read(String fileName) throws SAXException, IOException {
        this.mDoc = this.mBuilder.parse(fileName);
        this.processAlert();
    }

    public void processAlert() {
        NodeList nodes = this.mDoc.getElementsByTagName(ALERTITEM);
        Object ele = null;
        AlertItem item = null;
        String tmp = null;
        int id = 0;
        int i = 0;
        while (i < nodes.getLength()) {
            tmp = this.getText(this.getElement(nodes, i, PATH_ID));
            try {
                id = Integer.parseInt(tmp);
                item = new AlertItem(id);
                tmp = this.getText(this.getElement(nodes, i, PATH_ALERT));
                item.setAlert(tmp);
                tmp = this.getText(this.getElement(nodes, i, PATH_DESC));
                item.setDesc(tmp);
                tmp = this.getText(this.getElement(nodes, i, PATH_SOLUTION));
                item.setSolution(tmp);
                tmp = this.getText(this.getElement(nodes, i, PATH_REFERENCE));
                item.setReference(tmp);
                this.mAlertTable.put(new Integer(id), item);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void main(String[] args) {
        try {
            AlertDB db = new AlertDB();
            db.read(args[0]);
        }
        catch (SAXParseException e) {
            e.printStackTrace();
            System.out.println(String.valueOf(e.getMessage()) + " Line=" + e.getLineNumber() + e.getPublicId());
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Element getElement(NodeList nodes, int num, String[] path) {
        Element ele = (Element)nodes.item(num);
        int i = 1;
        while (i < path.length) {
            nodes = ele.getElementsByTagName(path[i]);
            ele = (Element)nodes.item(0);
            ++i;
        }
        return ele;
    }

    private String getText(Element element) {
        if (element == null) {
            return "";
        }
        int i = 0;
        while (i < element.getChildNodes().getLength()) {
            Node node = element.getChildNodes().item(i);
            if (node.getNodeType() == 3) {
                return node.getNodeValue();
            }
            ++i;
        }
        return "";
    }

    private void setText(Element element, String text) {
        int i = 0;
        while (i < element.getChildNodes().getLength()) {
            Node node = element.getChildNodes().item(i);
            if (node.getNodeType() == 3) {
                node.setNodeValue(text);
                return;
            }
            ++i;
        }
    }

    public AlertItem get(int id) {
        AlertItem result = null;
        try {
            result = (AlertItem)this.mAlertTable.get(new Integer(id));
        }
        catch (NullPointerException e) {
            result = new AlertItem(0);
            result.setAlert("Alert not found");
        }
        return result;
    }

    public AlertItem getInstance(int id) {
        AlertItem result = this.get(id).newInstance();
        return result;
    }

    Hashtable getTable() {
        return this.mAlertTable;
    }
}

