/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.scan.ParsedEntity;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedURL
extends ParsedEntity {
    private Hashtable mTableQueryURL = new Hashtable();
    private Hashtable mTableQueryBody = new Hashtable();
    private static final Pattern patternQuery = Pattern.compile("([^/?=&]+)=([^/?=&]*)&?");

    public ParsedURL(String caption, HttpRequestHeader req, HttpBody body) throws HttpMalformedHeaderException, URISyntaxException {
        super(caption, req, body);
        this.analyse(req, body);
    }

    private void analyse(HttpRequestHeader req, HttpBody body) throws URISyntaxException {
        this.parseQuery(req, body);
    }

    private void parseQuery(HttpRequestHeader req, HttpBody body) throws URISyntaxException {
        this.mTableQueryURL.clear();
        this.mTableQueryBody.clear();
        String query = "";
        try {
            query = new URI(req.getURIHostPathQuery()).getQuery();
            this.parseQueryParam(query, this.mTableQueryURL, patternQuery);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            query = body.toString().trim();
            this.parseQueryParam(query, this.mTableQueryBody, patternQuery);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseQueryParam(String query, Hashtable table, Pattern p) {
        Matcher matcher = p.matcher(query);
        while (matcher.find()) {
            String field = matcher.group(0);
            String val = matcher.group(1);
            if (field == null || val == null || field.equals("")) continue;
            table.put(field, val);
        }
    }
}

