/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.scan.AbstractServerTest;
import com.proofsecure.paros.scan.ParsedEntity;
import java.io.IOException;
import java.util.Vector;
import javax.net.ssl.SSLSocket;

class TestCipherSuite
extends AbstractServerTest {
    private String[] mCipherSuite = null;
    private static final String[] CIPHER_SUITE_NULL = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
    private static final String[] CIPHER_SUITE_WEAK = new String[]{"SSL_DH_anon_WITH_RC4_128_MD5", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] CIPHER_SUITE_MEDIUM = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA"};

    TestCipherSuite() {
    }

    public String toString() {
        return "TestCipherSuite";
    }

    public String getTestName() {
        return "SSL Cipher Suite";
    }

    public int getAlertID() {
        return 10008;
    }

    protected void init(ParsedEntity entity) throws Exception {
        super.init(entity);
        TestCipherSuite test = new TestCipherSuite();
        test.initForRun(entity);
        this.addTestCase(test);
    }

    protected void initForRun(ParsedEntity entity) throws Exception {
        super.init(entity);
    }

    protected void scan() throws Exception {
        if (!this.getRequestHeader().getSecure()) {
            return;
        }
        String host = this.getRequestHeader().getHostName();
        int port = this.getRequestHeader().getHostPort();
        SSLSocket socket = null;
        Vector supportedList = new Vector();
        try {
            socket = this.getSSLSocket(host, port);
            this.mCipherSuite = socket.getSupportedCipherSuites();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.mCipherSuite.length) {
            this.writeStatus("SSLCipherSuite: " + this.mCipherSuite[i]);
            this.checkCipher(host, port, this.mCipherSuite[i], supportedList);
            ++i;
        }
        StringBuffer sbAll = new StringBuffer();
        StringBuffer sbWeak = new StringBuffer();
        StringBuffer sbNull = new StringBuffer();
        String cipher = null;
        int i2 = 0;
        while (i2 < supportedList.size()) {
            cipher = (String)supportedList.elementAt(i2);
            if (this.checkDefinition(CIPHER_SUITE_NULL, cipher)) {
                sbNull.append(String.valueOf(cipher) + "\r\n");
            } else if (this.checkDefinition(CIPHER_SUITE_WEAK, cipher)) {
                sbWeak.append(String.valueOf(cipher) + "\r\n");
            }
            sbAll.append(String.valueOf(cipher) + "\r\n");
            ++i2;
        }
        if (sbNull.length() > 0) {
            this.bingo(10009, 2, 2, "", "", sbNull.toString());
        }
        if (sbWeak.length() > 0) {
            this.bingo(10014, 1, 2, "", "", sbWeak.toString());
        }
        if (sbAll.length() > 0) {
            this.bingo(10008, 0, 0, "", "", sbAll.toString());
        }
    }

    private boolean checkDefinition(String[] def, String cipher) {
        int i = 0;
        while (i < def.length) {
            if (cipher.compareToIgnoreCase(def[i]) == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private SSLSocket getSSLSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        socket = !Global.config.isUseProxyChain() || Global.config.isSkipProxyChain(host) ? Global.ssl.clientNoHandshake(host, port, false) : Global.ssl.clientViaProxyNoHandshake(host, port, Global.config.getProxyChainName(), Global.config.getProxyChainPort(), false);
        return socket;
    }

    private void checkCipher(String host, int port, String suite, Vector supportedList) {
        String[] suites = new String[]{suite};
        SSLSocket socket = null;
        try {
            socket = this.getSSLSocket(host, port);
            socket.setEnabledCipherSuites(suites);
            socket.startHandshake();
            supportedList.add(suite);
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

