/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpStatusCode;
import com.proofsecure.paros.scan.TestAbstractParam;
import java.io.IOException;
import java.util.regex.Pattern;

class TestSQLInjection
extends TestAbstractParam {
    private static String SQL_OR_1 = "%20OR%201=1;--";
    private static String SQL_OR_2 = "'%20OR%201=1;--";
    private static String SQL_OR_3 = "'%20OR%20'1'='1";
    private static String SQL_DELAY_1 = "';waitfor%20delay%20'0:0:15';--";
    private static String SQL_DELAY_2 = ";waitfor%20delay%20'0:0:15';--";
    private static String SQL_BLIND_MS_INSERT = ");waitfor%20delay%20'0:0:15';--";
    private static String SQL_BLIND_INSERT = ");--";
    private static String SQL_AND_1 = "%20AND%201=1";
    private static String SQL_AND_1_ERR = "%20AND%201=2";
    private static String SQL_AND_2 = "'%20AND%20'1'='1";
    private static String SQL_AND_2_ERR = "'%20AND%20'1'='2";
    private static String SQL_CHECK_ERR = "'INJECTED_PARAM";
    private static int TIME_SPREAD = 15000;
    private static Pattern patternErrorODBC1 = Pattern.compile("Microsoft OLE DB Provider for ODBC Drivers.*error", 42);
    private static Pattern patternErrorODBC2 = Pattern.compile("ODBC.*Drivers.*error", 42);
    private static Pattern patternErrorGeneric = Pattern.compile("JDBC|ODBC|SQL", 42);
    private String mResBodyNormal = "";
    private String mResBodyError = "";

    TestSQLInjection() {
    }

    public String toString() {
        return "TestSQLInjection";
    }

    public String getTestName() {
        return "SQL Injection";
    }

    protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {
        String bingoQuery = null;
        String displayURI = null;
        String newQuery = null;
        String resBodyAND = null;
        String resBodyANDErr = null;
        boolean pos = false;
        long defaultTimeUsed = 0L;
        long timeUsed = 0L;
        long lastTime = 0L;
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        defaultTimeUsed = System.currentTimeMillis() - lastTime;
        if (this.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        this.mResBodyNormal = this.getResponseBody().toString();
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + SQL_CHECK_ERR);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        defaultTimeUsed = System.currentTimeMillis() - lastTime;
        this.mResBodyError = this.getResponseBody().toString();
        if (this.checkANDResult(newQuery)) {
            return;
        }
        bingoQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + SQL_AND_1);
        this.createMessage(isBody, bingoQuery);
        this.sendAndReceive();
        displayURI = this.getRequestHeader().getURIHostPathQuery();
        if (this.checkANDResult(bingoQuery)) {
            return;
        }
        if (this.getResponseHeader().getStatusCode() == 200 && (resBodyAND = this.getResponseBody().toString().replaceAll(SQL_AND_1, "")).compareTo(this.mResBodyNormal) == 0) {
            newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + SQL_AND_1_ERR);
            this.createMessage(isBody, newQuery);
            this.sendAndReceive();
            resBodyANDErr = this.getResponseBody().toString().replaceAll(SQL_AND_1_ERR, "");
            if (resBodyANDErr.compareTo(this.mResBodyNormal) != 0) {
                this.bingo(20001, 3, 2, displayURI, bingoQuery, "");
                return;
            }
        }
        bingoQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + SQL_AND_2);
        this.createMessage(isBody, bingoQuery);
        this.sendAndReceive();
        displayURI = this.getRequestHeader().getURIHostPathQuery();
        if (this.checkANDResult(bingoQuery)) {
            return;
        }
        if (this.getResponseHeader().getStatusCode() == 200 && (resBodyAND = this.getResponseBody().toString().replaceAll(SQL_AND_2, "")).compareTo(this.mResBodyNormal) == 0) {
            newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + SQL_AND_2_ERR);
            this.createMessage(isBody, newQuery);
            this.sendAndReceive();
            resBodyANDErr = this.getResponseBody().toString().replaceAll(SQL_AND_2_ERR, "");
            if (resBodyANDErr.compareTo(this.mResBodyNormal) != 0) {
                this.bingo(20001, 3, 2, displayURI, bingoQuery, "");
                return;
            }
        }
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + SQL_DELAY_1);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        timeUsed = System.currentTimeMillis() - lastTime;
        if (this.checkTimeResult(newQuery, defaultTimeUsed, timeUsed)) {
            return;
        }
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + SQL_DELAY_2);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        timeUsed = System.currentTimeMillis() - lastTime;
        if (this.checkTimeResult(newQuery, defaultTimeUsed, timeUsed)) {
            return;
        }
        this.testBlindINSERT(isBody, paramKey, paramValue, query, insertPos);
    }

    private void testBlindINSERT(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {
        if (!Global.isST) {
            return;
        }
        Object bingoQuery = null;
        Object displayURI = null;
        String newQuery = null;
        Object resBody = null;
        Object resBodyErr = null;
        boolean pos = false;
        long defaultTimeUsed = 0L;
        long timeUsed = 0L;
        long lastTime = 0L;
        int TRY_COUNT = 10;
        StringBuffer sbInsertValue = new StringBuffer();
        sbInsertValue = new StringBuffer();
        int i = 0;
        while (i < TRY_COUNT) {
            block7: {
                if (i > 0) {
                    sbInsertValue.append(",'0'");
                }
                newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + "'" + sbInsertValue.toString() + SQL_BLIND_MS_INSERT);
                this.createMessage(isBody, newQuery);
                lastTime = System.currentTimeMillis();
                this.sendAndReceive();
                timeUsed = System.currentTimeMillis() - lastTime;
                if (this.checkTimeResult(newQuery, defaultTimeUsed, timeUsed)) {
                    return;
                }
                try {
                    long tmp = Long.parseLong(paramValue);
                }
                catch (NumberFormatException e) {
                    break block7;
                }
                newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue + sbInsertValue.toString() + SQL_BLIND_MS_INSERT);
                this.createMessage(isBody, newQuery);
                lastTime = System.currentTimeMillis();
                this.sendAndReceive();
                timeUsed = System.currentTimeMillis() - lastTime;
                if (this.checkTimeResult(newQuery, defaultTimeUsed, timeUsed)) {
                    return;
                }
            }
            ++i;
        }
    }

    private boolean checkANDResult(String query) {
        StringBuffer sb = new StringBuffer();
        if (this.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(this.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (this.matchBodyPattern(patternErrorODBC1, sb) || this.matchBodyPattern(patternErrorODBC2, sb)) {
            this.bingo(20001, 3, 2, "", query, sb.toString());
            return true;
        }
        if (this.matchBodyPattern(patternErrorGeneric, sb)) {
            this.bingo(20001, 3, 1, "", query, sb.toString());
            return true;
        }
        return false;
    }

    private boolean checkTimeResult(String query, long defaultTimeUsed, long timeUsed) {
        boolean result = this.checkANDResult(query);
        if (result) {
            return result;
        }
        if (timeUsed > defaultTimeUsed + (long)TIME_SPREAD - 500L) {
            this.bingo(20001, 3, 1, "", query, "");
            return true;
        }
        return false;
    }

    protected void scan() throws Exception {
        boolean skip = this.getEntity().mState == 1;
        this.writeStatus("SQL Injection: " + (skip ? "(skipped) " : "") + this.getRequestHeader().getURIHostPath());
        if (skip) {
            return;
        }
        this.init();
        this.checkUrlOrBody(false, this.myQuery);
        this.checkUrlOrBody(true, this.myReqBody.toString());
    }
}

